/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.InvalidObjectException;
import java.io.Serializable;
import java.text.ParseException;
import java.time.MonthDay;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Map;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.SystemClock;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.TimeSource;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.Chronology;
import net.time4j.engine.Converter;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.Temporal;
import net.time4j.engine.ThreetenAdapter;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.tz.Timezone;

@CalendarType(value="iso8601")
public final class AnnualDate
extends ChronoEntity<AnnualDate>
implements Comparable<AnnualDate>,
Temporal<AnnualDate>,
ThreetenAdapter,
LocalizedPatternSupport,
Serializable {
    @FormattableElement(format="M", alt="L")
    public static final ChronoElement<Month> MONTH_OF_YEAR = PlainDate.MONTH_OF_YEAR;
    public static final ChronoElement<Integer> MONTH_AS_NUMBER = PlainDate.MONTH_AS_NUMBER;
    @FormattableElement(format="d")
    public static final ChronoElement<Integer> DAY_OF_MONTH = PlainDate.DAY_OF_MONTH;
    private static final Chronology<AnnualDate> ENGINE = Chronology.Builder.setUp(AnnualDate.class, new Merger()).appendElement(DAY_OF_MONTH, new IntegerElementRule(true)).appendElement(MONTH_OF_YEAR, new MonthElementRule()).appendElement(MONTH_AS_NUMBER, new IntegerElementRule(false)).build();
    private static final Chronology<MonthDay> THREETEN;
    private static final long serialVersionUID = 7510648008819092983L;
    private final int month;
    private final int dayOfMonth;

    private AnnualDate(int n2, int n3) {
        this.month = n2;
        this.dayOfMonth = n3;
    }

    public static AnnualDate of(Month month, int n2) {
        return AnnualDate.of(month.getValue(), n2);
    }

    public static AnnualDate of(int n2, int n3) {
        AnnualDate.check(n2, n3);
        return new AnnualDate(n2, n3);
    }

    public static AnnualDate from(GregorianDate gregorianDate) {
        PlainDate plainDate = PlainDate.from(gregorianDate);
        return new AnnualDate(plainDate.getMonth(), plainDate.getDayOfMonth());
    }

    public static AnnualDate from(MonthDay monthDay) {
        return new AnnualDate(monthDay.getMonthValue(), monthDay.getDayOfMonth());
    }

    public static AnnualDate nowInSystemTime() {
        return SystemClock.inLocalView().now(ENGINE);
    }

    public Month getMonth() {
        return Month.valueOf(this.month);
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    @Override
    public boolean isAfter(AnnualDate annualDate) {
        return this.compareTo(annualDate) > 0;
    }

    @Override
    public boolean isBefore(AnnualDate annualDate) {
        return this.compareTo(annualDate) < 0;
    }

    @Override
    public boolean isSimultaneous(AnnualDate annualDate) {
        return this.compareTo(annualDate) == 0;
    }

    @Override
    public int compareTo(AnnualDate annualDate) {
        if (this.month < annualDate.month) {
            return -1;
        }
        if (this.month > annualDate.month) {
            return 1;
        }
        if (this.dayOfMonth < annualDate.dayOfMonth) {
            return -1;
        }
        if (this.dayOfMonth > annualDate.dayOfMonth) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AnnualDate) {
            AnnualDate annualDate = (AnnualDate)object;
            return this.month == annualDate.month && this.dayOfMonth == annualDate.dayOfMonth;
        }
        return false;
    }

    public int hashCode() {
        return (this.month << 16) + this.dayOfMonth;
    }

    public String toString() {
        return AnnualDate.toString(this.month, this.dayOfMonth);
    }

    public static AnnualDate parseXML(String string) throws ParseException {
        if (string.length() == 7 && string.charAt(0) == '-' && string.charAt(1) == '-' && string.charAt(4) == '-') {
            int n2 = AnnualDate.toDigit(string, 2);
            int n3 = AnnualDate.toDigit(string, 3);
            int n4 = AnnualDate.toDigit(string, 5);
            int n5 = AnnualDate.toDigit(string, 6);
            return new AnnualDate(n2 * 10 + n3, n4 * 10 + n5);
        }
        throw new ParseException("Not compatible to standard XML-format: " + string, string.length());
    }

    public PlainDate atYear(int n2) {
        return PlainDate.of(n2, this.month, this.dayOfMonth);
    }

    public boolean isValidDate(int n2) {
        return n2 >= -999999999 && n2 <= 999999999 && (this.month != 2 || this.dayOfMonth != 29 || GregorianMath.isLeapYear(n2));
    }

    @Override
    public MonthDay toTemporalAccessor() {
        return MonthDay.of(this.month, this.dayOfMonth);
    }

    public ChronoOperator<PlainDate> asNextExactEvent() {
        return plainDate -> {
            int n2 = plainDate.getYear();
            int n3 = this.getMonth().getValue();
            int n4 = this.getDayOfMonth();
            if (n3 < plainDate.getMonth() || n3 == plainDate.getMonth() && n4 <= plainDate.getDayOfMonth()) {
                ++n2;
            }
            if (n3 == 2 && n4 == 29) {
                while (!GregorianMath.isLeapYear(n2)) {
                    ++n2;
                }
            }
            return PlainDate.of(n2, n3, n4);
        };
    }

    public ChronoOperator<PlainDate> asNextRoundedEvent() {
        return plainDate -> {
            int n2 = plainDate.getYear();
            int n3 = this.getMonth().getValue();
            int n4 = this.getDayOfMonth();
            if (n3 < plainDate.getMonth() || n3 == plainDate.getMonth() && n4 <= plainDate.getDayOfMonth()) {
                ++n2;
            }
            if (n3 == 2 && n4 == 29 && !GregorianMath.isLeapYear(n2)) {
                n3 = 3;
                n4 = 1;
            }
            return PlainDate.of(n2, n3, n4);
        };
    }

    public static Chronology<AnnualDate> chronology() {
        return ENGINE;
    }

    public static Chronology<MonthDay> threeten() {
        return THREETEN;
    }

    @Override
    protected Chronology<AnnualDate> getChronology() {
        return ENGINE;
    }

    @Override
    protected AnnualDate getContext() {
        return this;
    }

    private static void check(int n2, int n3) {
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("Month not in range 1-12: " + n2);
        }
        if (n3 < 1 || n3 > AnnualDate.getMaxDay(n2)) {
            throw new IllegalArgumentException("Out of bounds: " + AnnualDate.toString(n2, n3));
        }
    }

    private static int getMaxDay(int n2) {
        switch (n2) {
            case 2: {
                return 29;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    private static int toDigit(String string, int n2) throws ParseException {
        char c2 = string.charAt(n2);
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        throw new ParseException("Digit expected: " + string, n2);
    }

    private static String toString(int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("--");
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        stringBuilder.append('-');
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        return stringBuilder.toString();
    }

    private Object readResolve() throws InvalidObjectException {
        try {
            AnnualDate.check(this.month, this.dayOfMonth);
            return this;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidObjectException(illegalArgumentException.getMessage());
        }
    }

    static {
        Converter<MonthDay, AnnualDate> converter = new Converter<MonthDay, AnnualDate>(){

            @Override
            public AnnualDate translate(MonthDay monthDay) {
                return new AnnualDate(monthDay.getMonthValue(), monthDay.getDayOfMonth());
            }

            @Override
            public MonthDay from(AnnualDate annualDate) {
                return MonthDay.of(annualDate.month, annualDate.dayOfMonth);
            }

            @Override
            public Class<MonthDay> getSourceType() {
                return MonthDay.class;
            }
        };
        THREETEN = new BridgeChronology<MonthDay, AnnualDate>(converter, ENGINE);
    }

    private static class Merger
    implements ChronoMerger<AnnualDate> {
        private Merger() {
        }

        @Override
        public AnnualDate createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            Timezone timezone;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                timezone = Timezone.of(attributeQuery.get(Attributes.TIMEZONE_ID));
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                timezone = Timezone.ofSystem();
            } else {
                return null;
            }
            PlainDate plainDate = Moment.from(timeSource.currentTime()).toZonalTimestamp(timezone.getID()).toDate();
            return AnnualDate.of(plainDate.getMonth(), plainDate.getDayOfMonth());
        }

        @Override
        public AnnualDate createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl2, boolean bl3) {
            int n2 = chronoEntity.getInt(DAY_OF_MONTH);
            if (n2 != Integer.MIN_VALUE) {
                int n3 = chronoEntity.getInt(PlainDate.MONTH_AS_NUMBER);
                if (n3 == Integer.MIN_VALUE && chronoEntity.contains(MONTH_OF_YEAR)) {
                    n3 = chronoEntity.get(MONTH_OF_YEAR).getValue();
                }
                if (n3 != Integer.MIN_VALUE) {
                    if (n2 >= 1 && n2 <= AnnualDate.getMaxDay(n3)) {
                        if (n3 >= 1 && n3 <= 12) {
                            return new AnnualDate(n3, n2);
                        }
                        chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Month out of bounds: " + n3);
                    } else {
                        chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Day-of-month out of bounds: " + n2);
                    }
                }
            }
            return null;
        }

        @Override
        public String getFormatPattern(FormatStyle formatStyle, Locale locale) {
            Map<String, String> map = CalendarText.getIsoInstance(locale).getTextForms();
            String string = null;
            switch (formatStyle) {
                case FULL: {
                    string = "F_MMMMd";
                    break;
                }
                case LONG: {
                    string = "F_MMMd";
                    break;
                }
                case MEDIUM: {
                    string = "F_MMd";
                    break;
                }
                case SHORT: {
                    string = "F_Md";
                }
            }
            String string2 = Merger.getFormatPattern(map, string);
            return string2 == null ? "MM-dd" : string2;
        }

        private static String getFormatPattern(Map<String, String> map, String string) {
            if (string == null) {
                return null;
            }
            if (map.containsKey(string)) {
                return map.get(string);
            }
            switch (string) {
                case "F_MMMMd": {
                    return Merger.getFormatPattern(map, "F_MMMd");
                }
                case "F_MMMd": {
                    return Merger.getFormatPattern(map, "F_MMd");
                }
                case "F_MMd": {
                    return Merger.getFormatPattern(map, "F_Md");
                }
            }
            return null;
        }
    }

    private static class IntegerElementRule
    implements IntElementRule<AnnualDate> {
        private final boolean daywise;

        IntegerElementRule(boolean bl2) {
            this.daywise = bl2;
        }

        @Override
        public int getInt(AnnualDate annualDate) {
            return this.daywise ? annualDate.dayOfMonth : annualDate.month;
        }

        @Override
        public boolean isValid(AnnualDate annualDate, int n2) {
            if (n2 < 1) {
                return false;
            }
            if (this.daywise) {
                return n2 <= AnnualDate.getMaxDay(annualDate.month);
            }
            return n2 <= 12;
        }

        @Override
        public AnnualDate withValue(AnnualDate annualDate, int n2, boolean bl2) {
            if (this.daywise) {
                return AnnualDate.of(annualDate.month, n2);
            }
            return AnnualDate.of(n2, Math.min(annualDate.dayOfMonth, AnnualDate.getMaxDay(n2)));
        }

        @Override
        public Integer getValue(AnnualDate annualDate) {
            return this.getInt(annualDate);
        }

        @Override
        public Integer getMinimum(AnnualDate annualDate) {
            return 1;
        }

        @Override
        public Integer getMaximum(AnnualDate annualDate) {
            if (this.daywise) {
                return AnnualDate.getMaxDay(annualDate.month);
            }
            return 12;
        }

        @Override
        public boolean isValid(AnnualDate annualDate, Integer n2) {
            if (n2 == null) {
                return false;
            }
            return this.isValid(annualDate, (int)n2);
        }

        @Override
        public AnnualDate withValue(AnnualDate annualDate, Integer n2, boolean bl2) {
            if (n2 == null) {
                throw new IllegalArgumentException("Missing new value.");
            }
            return this.withValue(annualDate, (int)n2, bl2);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(AnnualDate annualDate) {
            return this.daywise ? null : DAY_OF_MONTH;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(AnnualDate annualDate) {
            return this.daywise ? null : DAY_OF_MONTH;
        }
    }

    private static class MonthElementRule
    implements ElementRule<AnnualDate, Month> {
        private MonthElementRule() {
        }

        @Override
        public Month getValue(AnnualDate annualDate) {
            return annualDate.getMonth();
        }

        @Override
        public Month getMinimum(AnnualDate annualDate) {
            return Month.JANUARY;
        }

        @Override
        public Month getMaximum(AnnualDate annualDate) {
            return Month.DECEMBER;
        }

        @Override
        public boolean isValid(AnnualDate annualDate, Month month) {
            return month != null;
        }

        @Override
        public AnnualDate withValue(AnnualDate annualDate, Month month, boolean bl2) {
            if (month == null) {
                throw new IllegalArgumentException("Missing new value.");
            }
            int n2 = month.getValue();
            return new AnnualDate(n2, Math.min(annualDate.dayOfMonth, AnnualDate.getMaxDay(n2)));
        }

        @Override
        public ChronoElement<?> getChildAtFloor(AnnualDate annualDate) {
            return DAY_OF_MONTH;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(AnnualDate annualDate) {
            return DAY_OF_MONTH;
        }
    }
}

