/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.Utils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.MultipleSelectionModelBase;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TreeItem;

class ControlUtils {
    private ControlUtils() {
    }

    public static void scrollToIndex(Control control, int n2) {
        Utils.executeOnceWhenPropertyIsNonNull(control.skinProperty(), skin -> Event.fireEvent(control, new ScrollToEvent<Integer>(control, control, ScrollToEvent.scrollToTopIndex(), n2)));
    }

    public static void scrollToColumn(Control control, TableColumnBase<?, ?> tableColumnBase) {
        Utils.executeOnceWhenPropertyIsNonNull(control.skinProperty(), skin -> control.fireEvent(new ScrollToEvent<TableColumnBase>(control, control, ScrollToEvent.scrollToColumn(), tableColumnBase)));
    }

    static void requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(Control control) {
        Node node;
        Scene scene = control.getScene();
        Node node2 = node = scene == null ? null : scene.getFocusOwner();
        if (node == null) {
            control.requestFocus();
        } else if (!control.equals(node)) {
            for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
                if (!control.equals(parent)) continue;
                control.requestFocus();
                break;
            }
        }
    }

    static <T> ListChangeListener.Change<T> buildClearAndSelectChange(ObservableList<T> observableList, final List<T> list, final T t2, final Comparator<T> comparator) {
        return new ListChangeListener.Change<T>(observableList){
            private final int[] EMPTY_PERM;
            private final int removedSize;
            private final List<T> firstRemovedRange;
            private final List<T> secondRemovedRange;
            private boolean invalid;
            private boolean atFirstRange;
            private int from;
            {
                super(observableList);
                this.EMPTY_PERM = new int[0];
                this.removedSize = list.size();
                this.invalid = true;
                this.atFirstRange = true;
                this.from = -1;
                int n2 = Collections.binarySearch(list, t2, comparator);
                if (n2 >= 0) {
                    this.firstRemovedRange = list;
                    this.secondRemovedRange = Collections.emptyList();
                } else {
                    int n3 = -n2 - 1;
                    this.firstRemovedRange = list.subList(0, n3);
                    this.secondRemovedRange = list.subList(n3, this.removedSize);
                }
            }

            @Override
            public int getFrom() {
                this.checkState();
                return this.from;
            }

            @Override
            public int getTo() {
                return this.getFrom();
            }

            @Override
            public List<T> getRemoved() {
                this.checkState();
                return this.atFirstRange ? this.firstRemovedRange : this.secondRemovedRange;
            }

            @Override
            public int getRemovedSize() {
                this.checkState();
                return this.atFirstRange ? this.firstRemovedRange.size() : this.secondRemovedRange.size();
            }

            @Override
            protected int[] getPermutation() {
                this.checkState();
                return this.EMPTY_PERM;
            }

            @Override
            public boolean next() {
                if (this.invalid) {
                    this.invalid = false;
                    this.from = this.atFirstRange ? 0 : 1;
                    return true;
                }
                if (this.atFirstRange && !this.secondRemovedRange.isEmpty()) {
                    this.atFirstRange = false;
                    this.from = 1;
                    return true;
                }
                return false;
            }

            @Override
            public void reset() {
                this.invalid = true;
                this.atFirstRange = !this.firstRemovedRange.isEmpty();
            }

            private void checkState() {
                if (this.invalid) {
                    throw new IllegalStateException("Invalid Change state: next() must be called before inspecting the Change.");
                }
            }
        };
    }

    public static <S> void updateSelectedIndices(MultipleSelectionModelBase<S> multipleSelectionModelBase, boolean bl2, ListChangeListener.Change<? extends TablePositionBase<?>> change, IntPredicate intPredicate) {
        multipleSelectionModelBase.selectedIndices._beginChange();
        while (change.next()) {
            int n2;
            multipleSelectionModelBase.startAtomic();
            List list = change.getRemoved().stream().mapToInt(TablePositionBase::getRow).distinct().filter(intPredicate).boxed().peek(multipleSelectionModelBase.selectedIndices::clear).collect(Collectors.toList());
            int n3 = (int)change.getAddedSubList().stream().mapToInt(TablePositionBase::getRow).distinct().peek(multipleSelectionModelBase.selectedIndices::set).count();
            multipleSelectionModelBase.stopAtomic();
            int n4 = change.getFrom();
            if (bl2 && 0 < n4 && n4 < change.getList().size()) {
                n2 = ((TablePositionBase)change.getList().get(n4)).getRow();
                n4 = multipleSelectionModelBase.selectedIndices.indexOf(n2);
            }
            n2 = n4 + n3;
            if (change.wasReplaced()) {
                multipleSelectionModelBase.selectedIndices._nextReplace(n4, n2, list);
                continue;
            }
            if (change.wasRemoved()) {
                multipleSelectionModelBase.selectedIndices._nextRemove(n4, list);
                continue;
            }
            if (!change.wasAdded()) continue;
            multipleSelectionModelBase.selectedIndices._nextAdd(n4, n2);
        }
        change.reset();
        multipleSelectionModelBase.selectedIndices.reset();
        if (multipleSelectionModelBase.isAtomic()) {
            return;
        }
        if (multipleSelectionModelBase.getSelectedItems().isEmpty() && multipleSelectionModelBase.getSelectedItem() != null) {
            multipleSelectionModelBase.setSelectedItem(null);
        }
        multipleSelectionModelBase.selectedIndices._endChange();
    }

    public static <S> int getIndexOfChildWithDescendant(TreeItem<S> treeItem, TreeItem<S> treeItem2) {
        if (treeItem2 == null || treeItem == null) {
            return -1;
        }
        TreeItem<S> treeItem3 = treeItem2;
        TreeItem<S> treeItem4 = treeItem2.getParent();
        while (treeItem4 != null) {
            if (treeItem4 == treeItem) {
                return treeItem.getChildren().indexOf(treeItem3);
            }
            treeItem3 = treeItem4;
            treeItem4 = treeItem3.getParent();
        }
        return -1;
    }

    public static <S> boolean isTreeItemIncludingAncestorsExpanded(TreeItem<S> treeItem) {
        if (treeItem == null || !treeItem.isExpanded()) {
            return false;
        }
        for (TreeItem<S> treeItem2 = treeItem.getParent(); treeItem2 != null; treeItem2 = treeItem2.getParent()) {
            if (treeItem2.isExpanded()) continue;
            return false;
        }
        return true;
    }
}

