/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.swe.common.simple;

import de.fraunhofer.iosb.ilt.swe.common.constraint.AllowedValues;
import de.fraunhofer.iosb.ilt.swe.common.simple.AbstractSimpleComponent;
import java.math.BigDecimal;
import java.util.Objects;

public class Quantity
extends AbstractSimpleComponent<BigDecimal> {
    private BigDecimal value;
    private AllowedValues constraint;
    private String uom;

    public void setConstraint(AllowedValues constraint) {
        this.constraint = constraint;
    }

    public void setUom(String uom) {
        this.uom = uom;
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public void setValue(BigDecimal value) {
        this.value = value;
    }

    @Override
    public boolean valueIsValid() {
        if (this.value == null) {
            return false;
        }
        if (this.constraint == null) {
            return true;
        }
        return this.constraint.isValid(this.value);
    }

    public String getUom() {
        return this.uom;
    }

    public AllowedValues getConstraint() {
        return this.constraint;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Objects.hashCode(this.value);
        hash = 53 * hash + Objects.hashCode(this.constraint);
        hash = 53 * hash + Objects.hashCode(this.uom);
        hash = 53 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quantity other = (Quantity)obj;
        if (!Objects.equals(this.uom, other.uom)) {
            return false;
        }
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (!Objects.equals(this.constraint, other.constraint)) {
            return false;
        }
        return super.equals(obj);
    }
}

