/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model.builder.api;

import de.fraunhofer.iosb.ilt.sta.model.HistoricalLocation;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.builder.api.BuildingException;
import de.fraunhofer.iosb.ilt.sta.model.builder.api.EntityBuilder;
import java.util.Collection;
import java.util.List;
import org.geojson.GeoJsonObject;

public abstract class AbstractLocationBuilder<U extends AbstractLocationBuilder<U>>
extends EntityBuilder<Location, U> {
    @Override
    protected Location newBuildingInstance() {
        return new Location();
    }

    public U name(String name) {
        ((Location)this.getBuildingInstance()).setName(name);
        return (U)((AbstractLocationBuilder)this.getSelf());
    }

    public U description(String description) {
        ((Location)this.getBuildingInstance()).setDescription(description);
        return (U)((AbstractLocationBuilder)this.getSelf());
    }

    public U encodingType(ValueCode encodingType) {
        ((Location)this.getBuildingInstance()).setEncodingType(encodingType.getValue());
        return (U)((AbstractLocationBuilder)this.getSelf());
    }

    public U location(Object location) {
        if (!(location instanceof GeoJsonObject)) {
            throw new BuildingException("Whereas the OGC SensorThings API specifies the Location#location as an Any type (so any Object can be used), the FROST-Client only accepts GeoJSONObject type");
        }
        ((Location)this.getBuildingInstance()).setLocation((GeoJsonObject)location);
        return (U)((AbstractLocationBuilder)this.getSelf());
    }

    public U things(List<Thing> things) {
        ((Location)this.getBuildingInstance()).getThings().addAll((Collection<Thing>)things);
        return (U)((AbstractLocationBuilder)this.getSelf());
    }

    public U thing(Thing thing) {
        ((Location)this.getBuildingInstance()).getThings().add(thing);
        return (U)((AbstractLocationBuilder)this.getSelf());
    }

    public U historicalLocations(List<HistoricalLocation> historicalLocations) {
        ((Location)this.getBuildingInstance()).getHistoricalLocations().addAll((Collection<HistoricalLocation>)historicalLocations);
        return (U)((AbstractLocationBuilder)this.getSelf());
    }

    public U historicalLocation(HistoricalLocation historicalLocation) {
        ((Location)this.getBuildingInstance()).getHistoricalLocations().add(historicalLocation);
        return (U)((AbstractLocationBuilder)this.getSelf());
    }

    public static enum ValueCode {
        GeoJSON("application/vnd.geo+json");

        private final String value;

        private ValueCode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

