/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSystem;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.Iso8601Format;
import net.time4j.format.expert.IsoDateStyle;
import net.time4j.format.expert.IsoDecimalStyle;
import net.time4j.range.MomentInterval;
import net.time4j.tz.ZonalOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringHelper {
    public static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final Logger LOGGER = LoggerFactory.getLogger(StringHelper.class);
    private static final String UTF8_NOT_SUPPORTED = "UTF-8 not supported?";
    private static final NonZeroCondition NON_ZERO_FRACTION = new NonZeroCondition(PlainTime.NANO_OF_SECOND);
    public static final ChronoPrinter<Moment> FORMAT_MOMENT = StringHelper.buildMomentFormatter();
    public static final ChronoPrinter<MomentInterval> FORMAT_INTERVAL = StringHelper.buildIntervalFormatter();

    private StringHelper() {
    }

    public static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String deCapitalize(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String cleanForLogging(String string) {
        if (string == null) {
            return "null";
        }
        return string.replaceAll("[\\n\\r\\t]", "_nrt_");
    }

    public static String cleanForLogging(Object object) {
        return StringHelper.cleanForLogging(Objects.toString(object));
    }

    public static String escapeForStringConstant(String in2) {
        return in2.replace("'", "''");
    }

    public static String urlEncode(String input) {
        try {
            return URLEncoder.encode(input, UTF8.name());
        }
        catch (UnsupportedEncodingException exc) {
            LOGGER.error(UTF8_NOT_SUPPORTED);
            throw new IllegalStateException(UTF8_NOT_SUPPORTED, exc);
        }
    }

    public static String urlDecode(String input) {
        try {
            return URLDecoder.decode(input, UTF8.name());
        }
        catch (UnsupportedEncodingException exc) {
            LOGGER.error(UTF8_NOT_SUPPORTED);
            throw new IllegalStateException(UTF8_NOT_SUPPORTED, exc);
        }
    }

    public static String urlEncode(String string, boolean notSlashes) {
        if (notSlashes) {
            return StringHelper.urlEncodeNotSlashes(string);
        }
        return StringHelper.urlEncode(string);
    }

    public static String urlEncodeNotSlashes(String string) {
        CharSequence[] split = string.split("/");
        for (int i2 = 0; i2 < split.length; ++i2) {
            split[i2] = StringHelper.urlEncode((String)split[i2]);
        }
        return String.join((CharSequence)"/", split);
    }

    private static ChronoPrinter<MomentInterval> buildIntervalFormatter() {
        return (formattable, buffer, attributes) -> {
            MomentInterval interval = (MomentInterval)formattable.toCanonical();
            if (interval.getStart().isInfinite()) {
                buffer.append("-");
            } else {
                FORMAT_MOMENT.print(interval.getStartAsMoment(), buffer);
            }
            buffer.append('/');
            if (interval.getEnd().isInfinite()) {
                buffer.append("-");
            } else {
                FORMAT_MOMENT.print(interval.getEndAsMoment(), buffer);
            }
            return Collections.emptySet();
        };
    }

    private static ChronoPrinter<Moment> buildMomentFormatter() {
        IsoDateStyle dateStyle = IsoDateStyle.EXTENDED_CALENDAR_DATE;
        IsoDecimalStyle decimalStyle = IsoDecimalStyle.DOT;
        ZonalOffset offset = ZonalOffset.UTC;
        ChronoFormatter.Builder builder = ChronoFormatter.setUp(Moment.axis(), Locale.ROOT);
        builder.addCustomized(PlainDate.COMPONENT, Iso8601Format.ofDate(dateStyle), (text, status, attributes) -> null);
        builder.addLiteral('T');
        StringHelper.addWallTime(builder, dateStyle.isExtended(), decimalStyle);
        builder.addTimezoneOffset(FormatStyle.MEDIUM, dateStyle.isExtended(), Collections.singletonList("Z"));
        return ((ChronoFormatter)builder.build().with(Leniency.STRICT)).withTimezone(offset);
    }

    private static <T extends ChronoEntity<T>> void addWallTime(ChronoFormatter.Builder<T> builder, boolean extended, IsoDecimalStyle decimalStyle) {
        builder.startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
        builder.startSection(Attributes.ZERO_DIGIT, 48);
        builder.addFixedInteger(PlainTime.HOUR_FROM_0_TO_24, 2);
        if (extended) {
            builder.addLiteral(':');
        }
        builder.addFixedInteger(PlainTime.MINUTE_OF_HOUR, 2);
        if (extended) {
            builder.addLiteral(':');
        }
        builder.addFixedInteger(PlainTime.SECOND_OF_MINUTE, 2);
        builder.startOptionalSection(NON_ZERO_FRACTION);
        switch (decimalStyle) {
            case COMMA: {
                builder.addLiteral(',', '.');
                break;
            }
            case DOT: {
                builder.addLiteral('.', ',');
                break;
            }
            default: {
                throw new UnsupportedOperationException(decimalStyle.name());
            }
        }
        builder.addFraction(PlainTime.NANO_OF_SECOND, 1, 9, false);
        for (int i2 = 0; i2 < 3; ++i2) {
            builder.endSection();
        }
    }

    private static class NonZeroCondition
    implements ChronoCondition<ChronoDisplay> {
        private final ChronoElement<Integer> element;

        NonZeroCondition(ChronoElement<Integer> element) {
            this.element = element;
        }

        @Override
        public boolean test(ChronoDisplay context) {
            return context.getInt(this.element) > 0;
        }

        ChronoCondition<ChronoDisplay> or(NonZeroCondition other) {
            return context -> this.test((ChronoDisplay)context) || other.test((ChronoDisplay)context);
        }
    }
}

