/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.model.core.IdLong;
import de.fraunhofer.iosb.ilt.frostserver.model.core.IdString;
import de.fraunhofer.iosb.ilt.frostserver.model.core.IdUuid;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.PathParser;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.QueryParser;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import java.util.UUID;

public class ParserUtils {
    private ParserUtils() {
    }

    public static Query parsePathAndQuery(String serviceRootUrl, Version version, String pathAndQuery, CoreSettings settings) {
        int index = pathAndQuery.indexOf(63);
        String pathString = pathAndQuery.substring(0, index);
        String queryString = pathAndQuery.substring(index + 1);
        ResourcePath path = PathParser.parsePath(settings.getModelRegistry(), serviceRootUrl, version, pathString);
        return QueryParser.parseQuery(queryString, settings, path).validate(path.getMainElementType());
    }

    public static Id idFromObject(Object input) {
        if (input instanceof UUID) {
            return new IdUuid((UUID)input);
        }
        if (input instanceof Number) {
            return new IdLong(((Number)input).longValue());
        }
        if (input instanceof CharSequence) {
            return new IdString(input.toString());
        }
        throw new IllegalArgumentException("Can not use " + (input == null ? "null" : input.getClass().getName()) + " (" + input + ") as an Id");
    }
}

