/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util;

import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import java.util.EnumMap;
import java.util.Map;

public class AuthUtils {
    private AuthUtils() {
    }

    public static Map<Role, String> loadRoleMapping(Settings authSettings) {
        EnumMap<Role, String> mapping = new EnumMap<Role, String>(Role.class);
        mapping.put(Role.READ, authSettings.get("role.read", CoreSettings.class));
        mapping.put(Role.CREATE, authSettings.get("role.create", CoreSettings.class));
        mapping.put(Role.UPDATE, authSettings.get("role.update", CoreSettings.class));
        mapping.put(Role.DELETE, authSettings.get("role.delete", CoreSettings.class));
        mapping.put(Role.ADMIN, authSettings.get("role.admin", CoreSettings.class));
        return mapping;
    }

    public static enum Role {
        READ,
        CREATE,
        UPDATE,
        DELETE,
        ADMIN,
        NONE,
        ERROR;

    }
}

