/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.settings;

import de.fraunhofer.iosb.ilt.frostserver.extensions.Extension;
import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatter;
import de.fraunhofer.iosb.ilt.frostserver.messagebus.MessageBus;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.path.CustomLinksHelper;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.query.QueryDefaults;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginManager;
import de.fraunhofer.iosb.ilt.frostserver.settings.BusSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.CachedSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.MqttSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.PersistenceSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.settings.SettingsMigrator;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValue;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueBoolean;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueInt;
import de.fraunhofer.iosb.ilt.frostserver.util.LiquibaseUser;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncorrectRequestException;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreSettings
implements ConfigDefaults {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreSettings.class);
    public static final String PREFIX_BUS = "bus.";
    public static final String PREFIX_MQTT = "mqtt.";
    public static final String PREFIX_HTTP = "http.";
    public static final String PREFIX_AUTH = "auth.";
    public static final String PREFIX_EXTENSION = "extension.";
    public static final String PREFIX_PERSISTENCE = "persistence.";
    public static final String PREFIX_PLUGINS = "plugins.";
    @DefaultValueBoolean(value=false)
    public static final String TAG_LOG_SENSITIVE_DATA = "logSensitiveData";
    @DefaultValueBoolean(value=true)
    public static final String TAG_DEFAULT_COUNT = "defaultCount";
    @DefaultValueInt(value=100)
    public static final String TAG_DEFAULT_TOP = "defaultTop";
    @DefaultValueInt(value=100)
    public static final String TAG_MAX_TOP = "maxTop";
    @DefaultValueInt(value=25000000)
    public static final String TAG_MAX_DATASIZE = "maxDataSize";
    @DefaultValueBoolean(value=true)
    public static final String TAG_ALWAYS_ORDERBY_ID = "alwaysOrderbyId";
    @DefaultValue(value="")
    public static final String TAG_SERVICE_ROOT_URL = "serviceRootUrl";
    @DefaultValueBoolean(value=true)
    public static final String TAG_USE_ABSOLUTE_NAVIGATION_LINKS = "useAbsoluteNavigationLinks";
    @DefaultValue(value="")
    public static final String TAG_TEMP_PATH = "tempPath";
    @DefaultValueInt(value=0)
    public static final String TAG_QUEUE_LOGGING_INTERVAL = "queueLoggingInterval";
    public static final String TAG_CORE_SETTINGS = "CoreSettings";
    @DefaultValueBoolean(value=false)
    public static final String TAG_CORS_ENABLE = "cors.enable";
    @DefaultValue(value="*")
    public static final String TAG_CORS_ALLOWED_ORIGINS = "cors.allowed.origins";
    @DefaultValue(value="GET,POST,HEAD,OPTIONS")
    public static final String TAG_CORS_ALLOWED_METHODS = "cors.allowed.methods";
    @DefaultValue(value="Location")
    public static final String TAG_CORS_EXPOSED_HEADERS = "cors.exposed.headers";
    @DefaultValue(value="Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers, Authorization")
    public static final String TAG_CORS_ALLOWED_HEADERS = "cors.allowed.headers";
    @DefaultValueBoolean(value=false)
    public static final String TAG_CORS_SUPPORT_CREDENTIALS = "cors.support.credentials";
    @DefaultValueInt(value=1800)
    public static final String TAG_CORS_PREFLIGHT_MAXAGE = "cors.preflight.maxage";
    @DefaultValueBoolean(value=true)
    public static final String TAG_CORS_REQUEST_DECORATE = "cors.request.decorate";
    @DefaultValue(value="")
    public static final String TAG_AUTH_PROVIDER = "provider";
    @DefaultValueBoolean(value=false)
    public static final String TAG_AUTH_ALLOW_ANON_READ = "allowAnonymousRead";
    @DefaultValue(value="read")
    public static final String TAG_AUTH_ROLE_READ = "role.read";
    @DefaultValue(value="create")
    public static final String TAG_AUTH_ROLE_CREATE = "role.create";
    @DefaultValue(value="update")
    public static final String TAG_AUTH_ROLE_UPDATE = "role.update";
    @DefaultValue(value="delete")
    public static final String TAG_AUTH_ROLE_DELETE = "role.delete";
    @DefaultValue(value="admin")
    public static final String TAG_AUTH_ROLE_ADMIN = "role.admin";
    @DefaultValueBoolean(value=false)
    public static final String TAG_FILTER_DELETE_ENABLE = "extension.filterDelete.enable";
    @DefaultValueBoolean(value=false)
    public static final String TAG_CUSTOM_LINKS_ENABLE = "customLinks.enable";
    @DefaultValueInt(value=0)
    public static final String TAG_CUSTOM_LINKS_RECURSE_DEPTH = "customLinks.recurseDepth";
    private final PluginManager pluginManager = new PluginManager();
    private final QueryDefaults queryDefaults = new QueryDefaults(this.defaultValueBoolean("useAbsoluteNavigationLinks"), this.defaultValueBoolean("defaultCount"), this.defaultValueInt("defaultTop"), this.defaultValueInt("maxTop"), this.defaultValueBoolean("alwaysOrderbyId"));
    private long dataSizeMax = this.defaultValueInt("maxDataSize");
    private String tempPath;
    private boolean filterDeleteEnabled;
    private final Set<Extension> enabledExtensions = EnumSet.noneOf(Extension.class);
    private Settings settings;
    private boolean logSensitiveData;
    private MqttSettings mqttSettings;
    private BusSettings busSettings;
    private PersistenceSettings persistenceSettings;
    private Settings httpSettings;
    private Settings authSettings;
    private Settings pluginSettings;
    private Settings extensionSettings;
    private final Set<LiquibaseUser> liquibaseUsers = new LinkedHashSet<LiquibaseUser>();
    private final ModelRegistry modelRegistry = new ModelRegistry();
    private MessageBus messageBus;
    private CustomLinksHelper customLinksHelper;

    public CoreSettings() {
        this.settings = new Settings(new Properties());
        this.initChildSettings();
    }

    public CoreSettings(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must be non-null");
        }
        this.init(properties);
    }

    private void init(Properties properties) {
        this.settings = new Settings(properties);
        SettingsMigrator.migrate(this.settings.getProperties());
        this.initLocalFields();
        this.initChildSettings();
        this.initExtensions();
        this.pluginManager.init();
    }

    private void initLocalFields() {
        this.logSensitiveData = this.settings.getBoolean(TAG_LOG_SENSITIVE_DATA, this.getClass());
        this.settings.setLogSensitiveData(this.logSensitiveData);
        if (!this.settings.containsName(TAG_SERVICE_ROOT_URL)) {
            throw new IllegalArgumentException(this.getClass().getName() + " must contain property 'serviceRootUrl'");
        }
        if (!this.settings.containsName(TAG_TEMP_PATH)) {
            throw new IllegalArgumentException(this.getClass().getName() + " must contain property 'tempPath'");
        }
        this.tempPath = this.settings.get(TAG_TEMP_PATH);
        if (this.tempPath == null || this.tempPath.isEmpty()) {
            throw new IllegalArgumentException("tempPath must be non-empty");
        }
        try {
            if (!Paths.get(this.tempPath, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toFile().exists()) {
                throw new IllegalArgumentException("tempPath '" + this.tempPath + "' does not exist");
            }
        }
        catch (IOException exc) {
            LOGGER.error("Failed to find tempPath: {}.", (Object)this.tempPath);
            throw new IllegalArgumentException("tempPath '" + this.tempPath + "' does not exist", exc);
        }
        this.queryDefaults.setServiceRootUrl(this.settings.get(TAG_SERVICE_ROOT_URL));
        this.queryDefaults.setUseAbsoluteNavigationLinks(this.settings.getBoolean(TAG_USE_ABSOLUTE_NAVIGATION_LINKS, this.getClass()));
        this.queryDefaults.setCountDefault(this.settings.getBoolean(TAG_DEFAULT_COUNT, this.getClass()));
        this.queryDefaults.setTopDefault(this.settings.getInt(TAG_DEFAULT_TOP, this.getClass()));
        this.queryDefaults.setTopMax(this.settings.getInt(TAG_MAX_TOP, this.getClass()));
        this.queryDefaults.setAlwaysOrder(this.settings.getBoolean(TAG_ALWAYS_ORDERBY_ID, this.getClass()));
        this.dataSizeMax = this.settings.getLong(TAG_MAX_DATASIZE, this.getClass());
        this.filterDeleteEnabled = this.settings.getBoolean(TAG_FILTER_DELETE_ENABLE, this.getClass());
    }

    private void initChildSettings() {
        this.pluginManager.setCoreSettings(this);
        this.mqttSettings = new MqttSettings(this, new Settings(this.settings.getProperties(), PREFIX_MQTT, false, this.logSensitiveData));
        this.persistenceSettings = new PersistenceSettings(new Settings(this.settings.getProperties(), PREFIX_PERSISTENCE, false, this.logSensitiveData));
        this.busSettings = new BusSettings(new Settings(this.settings.getProperties(), PREFIX_BUS, false, this.logSensitiveData));
        this.httpSettings = new Settings(this.settings.getProperties(), PREFIX_HTTP, false, this.logSensitiveData);
        this.authSettings = new Settings(this.settings.getProperties(), PREFIX_AUTH, false, this.logSensitiveData);
        this.pluginSettings = new CachedSettings(this.settings.getProperties(), PREFIX_PLUGINS, false, this.logSensitiveData);
        this.extensionSettings = new CachedSettings(this.settings.getProperties(), PREFIX_EXTENSION, false, this.logSensitiveData);
    }

    private void initExtensions() {
        this.enabledExtensions.add(Extension.CORE);
        if (this.getExtensionSettings().getBoolean(TAG_CUSTOM_LINKS_ENABLE, CoreSettings.class)) {
            this.enabledExtensions.add(Extension.ENTITY_LINKING);
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public ModelRegistry getModelRegistry() {
        return this.modelRegistry;
    }

    public static CoreSettings load(String file) {
        Properties properties = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(file, new String[]{null}));){
            properties.load(reader);
        }
        catch (IOException ex2) {
            LOGGER.error("error loading properties file, using defaults", ex2);
        }
        return CoreSettings.load(properties);
    }

    public static CoreSettings load(Properties properties) {
        return new CoreSettings(properties);
    }

    public Set<Extension> getEnabledExtensions() {
        return this.enabledExtensions;
    }

    public Settings getAuthSettings() {
        return this.authSettings;
    }

    public BusSettings getBusSettings() {
        return this.busSettings;
    }

    public Settings getExtensionSettings() {
        return this.extensionSettings;
    }

    public Settings getHttpSettings() {
        return this.httpSettings;
    }

    public MqttSettings getMqttSettings() {
        return this.mqttSettings;
    }

    public PersistenceSettings getPersistenceSettings() {
        return this.persistenceSettings;
    }

    public Settings getPluginSettings() {
        return this.pluginSettings;
    }

    public String getTempPath() {
        return this.tempPath;
    }

    public QueryDefaults getQueryDefaults() {
        return this.queryDefaults;
    }

    public long getDataSizeMax() {
        return this.dataSizeMax;
    }

    public void setDataSizeMax(long dataSizeMax) {
        this.dataSizeMax = dataSizeMax;
    }

    public boolean isFilterDeleteEnabled() {
        return this.filterDeleteEnabled;
    }

    public Set<LiquibaseUser> getLiquibaseUsers() {
        return Collections.unmodifiableSet(this.liquibaseUsers);
    }

    public void addLiquibaseUser(LiquibaseUser liquibaseUser) {
        this.liquibaseUsers.add(liquibaseUser);
    }

    public ResultFormatter getFormatter(Version version, String formatterName) throws IncorrectRequestException {
        if (formatterName == null) {
            return this.pluginManager.getFormatter(version, "default");
        }
        ResultFormatter formatter = this.pluginManager.getFormatter(version, formatterName);
        if (formatter == null) {
            throw new IncorrectRequestException("Unknown ResultFormatter: " + StringHelper.cleanForLogging(formatterName));
        }
        return formatter;
    }

    public MessageBus getMessageBus() {
        return this.messageBus;
    }

    public void setMessageBus(MessageBus messageBus) {
        this.messageBus = messageBus;
    }

    public CustomLinksHelper getCustomLinksHelper() {
        if (this.customLinksHelper == null) {
            Settings experimentalSettings = this.getExtensionSettings();
            boolean customLinksEnabled = experimentalSettings.getBoolean(TAG_CUSTOM_LINKS_ENABLE, CoreSettings.class);
            int customLinksRecurseDepth = experimentalSettings.getInt(TAG_CUSTOM_LINKS_RECURSE_DEPTH, CoreSettings.class);
            this.customLinksHelper = new CustomLinksHelper(this.modelRegistry, customLinksEnabled, customLinksRecurseDepth);
        }
        return this.customLinksHelper;
    }
}

