/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query.expression.function.arithmetic;

import de.fraunhofer.iosb.ilt.frostserver.query.expression.Expression;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.ExpressionVisitor;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.DoubleConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.IntegerConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.NumericConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.Function;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.Utils;

public class Divide
extends Function {
    public Divide() {
    }

    public Divide(Expression ... parameters) {
        super(parameters);
    }

    protected NumericConstant eval(NumericConstant<? extends Number> p1, NumericConstant<? extends Number> p2) {
        Number n1 = (Number)p1.getValue();
        Number n2 = (Number)p2.getValue();
        if (n1 instanceof Double || n2 instanceof Double) {
            return new DoubleConstant(n1.doubleValue() / n2.doubleValue());
        }
        return new IntegerConstant(n1.longValue() / n2.longValue());
    }

    @Override
    protected void initAllowedTypeBindings() {
        Utils.allowTypeBindingsCommonNumbers(this.allowedTypeBindings);
    }

    @Override
    public String toUrl() {
        return "(" + ((Expression)this.parameters.get(0)).toUrl() + " div " + ((Expression)this.parameters.get(1)).toUrl() + ")";
    }

    @Override
    public <O> O accept(ExpressionVisitor<O> visitor) {
        return visitor.visit(this);
    }
}

