/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementCustomProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyCustomSelect;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Expand;
import de.fraunhofer.iosb.ilt.frostserver.query.Metadata;
import de.fraunhofer.iosb.ilt.frostserver.query.OrderBy;
import de.fraunhofer.iosb.ilt.frostserver.query.PropertyPlaceholder;
import de.fraunhofer.iosb.ilt.frostserver.query.QueryDefaults;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Expression;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Path;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Query {
    private static final Set<EntityPropertyMain> refSelect = Collections.unmodifiableSet(new HashSet<EntityPropertyMain>(Arrays.asList(ModelRegistry.EP_SELFLINK)));
    private final QueryDefaults settings;
    private final ModelRegistry modelRegistry;
    private ResourcePath path;
    private Expand parentExpand;
    private EntityType entityType;
    private Set<EntityPropertyMain> selectEntityPropMain;
    private Set<NavigationPropertyMain> selectNavProp;
    private Optional<Integer> top;
    private Optional<Integer> skip;
    private Optional<Boolean> count;
    private final List<PropertyPlaceholder> rawSelect;
    private final Set<Property> select;
    private boolean selectDistinct = false;
    private Expression filter;
    private Expression skipFilter;
    private List<Expand> expand;
    private List<OrderBy> orderBy;
    private boolean pkOrder = false;
    private String format;
    private Metadata metadata;

    public Query(ModelRegistry modelRegistry, QueryDefaults settings, ResourcePath path) {
        this.modelRegistry = modelRegistry;
        this.path = path;
        this.settings = settings;
        this.top = Optional.empty();
        this.skip = Optional.empty();
        this.count = Optional.empty();
        this.orderBy = new ArrayList<OrderBy>();
        this.expand = new ArrayList<Expand>();
        this.rawSelect = new ArrayList<PropertyPlaceholder>();
        this.select = new LinkedHashSet<Property>();
    }

    public boolean isEmpty() {
        return this.top.isEmpty() && this.skip.isEmpty() && this.count.isEmpty() && this.select.isEmpty() && this.expand.isEmpty() && this.filter == null;
    }

    public Query validate() {
        PathElement mainElement = this.path.getMainElement();
        if (mainElement instanceof PathElementProperty || mainElement instanceof PathElementCustomProperty) {
            throw new IllegalArgumentException("No queries allowed for property paths.");
        }
        EntityType pathEntityType = this.path.getMainElementType();
        if (pathEntityType == null) {
            throw new IllegalStateException("Unkown ResourcePathElementType found.");
        }
        this.validate(pathEntityType);
        return this;
    }

    public Query validate(EntityType entityType) {
        if (this.entityType == null) {
            this.entityType = entityType;
        }
        this.selectEntityPropMain = null;
        for (PropertyPlaceholder pp2 : this.rawSelect) {
            Property property = entityType.getProperty(pp2.getName());
            if (property == null) {
                property = this.path.getVersion().syntheticPropertyRegistry.getProperty(pp2.getName());
            }
            if (property == null) {
                throw new IllegalArgumentException("Invalid property '" + pp2.getName() + "' found in select, for entity type " + entityType.entityName);
            }
            if (property instanceof NavigationProperty) {
                this.select.add(property);
                continue;
            }
            if (!(property instanceof EntityPropertyMain)) continue;
            if (pp2.hasSubPath()) {
                this.select.add(new EntityPropertyCustomSelect(property.getName()).addToSubPath(pp2.getSubPath()));
                continue;
            }
            this.select.add(property);
        }
        for (Expand e2 : this.expand) {
            e2.validate(entityType);
        }
        this.reNestExpands();
        if (this.filter != null) {
            this.filter.validate(this.modelRegistry.getParserHelper(), entityType);
        }
        if (this.skipFilter != null) {
            this.skipFilter.validate(this.modelRegistry.getParserHelper(), entityType);
        }
        EntityPropertyMain<Id> primaryKey = entityType.getPrimaryKey();
        String pkName = primaryKey.getName();
        for (OrderBy order : this.orderBy) {
            order.getExpression().validate(this.modelRegistry.getParserHelper(), entityType);
            if (!pkName.equals(order.getExpression().toUrl())) continue;
            this.pkOrder = true;
        }
        if (this.settings.isAlwaysOrder() && !this.pkOrder && !this.selectDistinct) {
            this.orderBy.add(new OrderBy(new Path(primaryKey), OrderBy.OrderType.ASCENDING));
            this.pkOrder = true;
        }
        return this;
    }

    public Version getVersion() {
        return this.path.getVersion();
    }

    public QueryDefaults getSettings() {
        return this.settings;
    }

    public ResourcePath getPath() {
        return this.path;
    }

    public void setPath(ResourcePath path) {
        this.path = path;
    }

    public String getServiceRootUrl() {
        return this.path.getServiceRootUrl();
    }

    public boolean hasParentExpand() {
        return this.parentExpand != null;
    }

    public Expand getParentExpand() {
        return this.parentExpand;
    }

    public void setParentExpand(Expand parentExpand) {
        this.parentExpand = parentExpand;
    }

    public Optional<Integer> getTop() {
        return this.top;
    }

    public int getTopOrDefault() {
        if (this.top.isPresent()) {
            return this.top.get();
        }
        return this.settings.getTopDefault();
    }

    public Optional<Integer> getSkip() {
        return this.skip;
    }

    public int getSkip(int dflt) {
        if (this.skip.isPresent()) {
            return this.skip.get();
        }
        return dflt;
    }

    public Optional<Boolean> getCount() {
        return this.count;
    }

    public boolean isCountOrDefault() {
        if (this.count.isPresent()) {
            return this.count.get();
        }
        return this.settings.isCountDefault();
    }

    public Query clearSelect() {
        this.select.clear();
        return this;
    }

    public Query addSelect(Collection<PropertyPlaceholder> properties) {
        if (!this.select.isEmpty()) {
            throw new IllegalStateException("Either add PropertyPlaceholder or Property instances, not both.");
        }
        this.rawSelect.addAll(properties);
        return this;
    }

    public Query addSelect(Property property) {
        if (!this.rawSelect.isEmpty()) {
            throw new IllegalStateException("Either add PropertyPlaceholder or Property instances, not both.");
        }
        this.select.add(property);
        return this;
    }

    public Query addSelect(Property ... properties) {
        this.select.addAll(Arrays.asList(properties));
        return this;
    }

    public Set<Property> getSelect() {
        return this.select;
    }

    public void setSelectDistinct(boolean selectDistinct) {
        this.selectDistinct = selectDistinct;
    }

    public boolean isSelectDistinct() {
        return this.selectDistinct;
    }

    public Set<EntityPropertyMain> getSelectMainEntityProperties(boolean inExpand) {
        if (this.selectEntityPropMain == null) {
            return this.initSelectedProperties(inExpand);
        }
        return this.selectEntityPropMain;
    }

    public Set<NavigationPropertyMain> getSelectNavProperties(boolean inExpand) {
        if (this.selectNavProp == null) {
            this.initSelectedProperties(inExpand);
        }
        return this.selectNavProp;
    }

    private Set<EntityPropertyMain> initSelectedProperties(boolean inExpand) {
        if (this.path != null && this.path.isRef()) {
            this.selectEntityPropMain = refSelect;
            this.selectNavProp = new HashSet<NavigationPropertyMain>();
            return refSelect;
        }
        LinkedHashSet<EntityPropertyMain> selectedEntityPropMain = new LinkedHashSet<EntityPropertyMain>();
        this.selectNavProp = new LinkedHashSet<NavigationPropertyMain>();
        if (this.select.isEmpty()) {
            if (this.entityType == null) {
                this.validate();
            }
            if (this.getMetadata() == Metadata.FULL) {
                selectedEntityPropMain.add(ModelRegistry.EP_SELFLINK);
            }
            selectedEntityPropMain.addAll(this.entityType.getEntityProperties());
            if (!inExpand) {
                this.selectNavProp.addAll(this.entityType.getNavigationEntities());
                this.selectNavProp.addAll(this.entityType.getNavigationSets());
            }
        } else {
            for (Property s2 : this.select) {
                if (s2 instanceof EntityPropertyMain) {
                    selectedEntityPropMain.add((EntityPropertyMain)s2);
                    continue;
                }
                if (s2 instanceof EntityPropertyCustomSelect) {
                    EntityPropertyCustomSelect epcs = (EntityPropertyCustomSelect)s2;
                    selectedEntityPropMain.add(this.entityType.getEntityProperty(epcs.getMainEntityPropertyName()));
                    continue;
                }
                if (!(s2 instanceof NavigationPropertyMain)) continue;
                this.selectNavProp.add((NavigationPropertyMain)s2);
            }
        }
        this.selectEntityPropMain = selectedEntityPropMain;
        return selectedEntityPropMain;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public Query setFilter(Expression filter) {
        this.filter = filter;
        return this;
    }

    public Expression getSkipFilter() {
        return this.skipFilter;
    }

    public void setSkipFilter(Expression skipFilter) {
        this.skipFilter = skipFilter;
    }

    public String getFormat() {
        return this.format;
    }

    public Metadata getMetadata() {
        if (this.metadata == null) {
            return Metadata.DEFAULT;
        }
        return this.metadata;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public List<Expand> getExpand() {
        return this.expand;
    }

    public List<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public boolean isPkOrder() {
        return this.pkOrder;
    }

    public Query setTop(int top) {
        this.top = top <= this.settings.getTopMax() ? Optional.of(top) : Optional.of(this.settings.getTopMax());
        return this;
    }

    public Query setSkip(int skip) {
        this.skip = Optional.of(skip);
        return this;
    }

    public Query setCount(boolean count) {
        this.count = Optional.of(count);
        return this;
    }

    public Query setFormat(String format) {
        this.format = format;
        return this;
    }

    public Query setMetadata(Metadata metadata) {
        Objects.requireNonNull(metadata);
        this.metadata = metadata;
        return this;
    }

    public Query setExpand(List<Expand> expand) {
        this.expand = expand;
        for (Expand e2 : expand) {
            e2.setParentQuery(this);
        }
        return this;
    }

    public Query addExpand(Expand expand) {
        this.expand.add(expand);
        expand.setParentQuery(this);
        return this;
    }

    private void addExpand(List<Expand> expands) {
        this.expand.addAll(expands);
        for (Expand e2 : expands) {
            e2.setParentQuery(this);
        }
    }

    public void reNestExpands() {
        ArrayList<Expand> newExpands = new ArrayList<Expand>();
        HashMap<String, Expand> expandMap = new HashMap<String, Expand>();
        for (Expand oldExpand : this.expand) {
            List<String> rawPath = oldExpand.getRawPath();
            String first = rawPath.get(0);
            int rawCount = rawPath.size();
            if (rawCount == 1 && expandMap.containsKey(first)) {
                Expand existing = (Expand)expandMap.get(first);
                existing.getSubQuery().addExpand(oldExpand.getSubQuery().getExpand());
                existing.getSubQuery().reNestExpands();
                continue;
            }
            newExpands.add(oldExpand);
            if (rawPath.size() != 1) continue;
            expandMap.put(first, oldExpand);
        }
        this.expand.clear();
        this.expand.addAll(newExpands);
    }

    public Query setOrderBy(List<OrderBy> orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.top, this.skip, this.count, this.select, this.filter, this.skipFilter, this.format, this.expand, this.orderBy, this.path, this.selectDistinct);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Query other = (Query)obj;
        return Objects.equals(this.count, other.count) && Objects.equals(this.top, other.top) && Objects.equals(this.skip, other.skip) && Objects.equals(this.select, other.select) && Objects.equals(this.selectDistinct, other.selectDistinct) && Objects.equals(this.filter, other.filter) && Objects.equals(this.skipFilter, other.skipFilter) && Objects.equals(this.format, other.format) && Objects.equals(this.expand, other.expand) && Objects.equals(this.orderBy, other.orderBy) && Objects.equals(this.path, other.path);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean inExpand) {
        char separator = inExpand ? (char)';' : '&';
        StringBuilder sb = new StringBuilder();
        this.addTopToUrl(sb, separator);
        this.addSkipToUrl(sb, separator);
        this.addSelectToUrl(sb, separator, inExpand);
        this.addFilterToUrl(sb, separator, inExpand);
        this.addFormatToUrl(sb, separator);
        this.addExpandToUrl(sb, separator, inExpand);
        this.addOrderbyToUrl(sb, separator, inExpand);
        this.addCountToUrl(sb, separator);
        if (sb.length() > 0) {
            return sb.substring(1);
        }
        return "";
    }

    private void addCountToUrl(StringBuilder sb, char separator) {
        if (this.count.isPresent()) {
            sb.append(separator).append("$count=").append(this.count.get());
        }
    }

    private void addFormatToUrl(StringBuilder sb, char separator) {
        if (this.format != null) {
            sb.append(separator).append("$resultFormat=").append(StringHelper.urlEncode(this.format));
        }
    }

    private void addSkipToUrl(StringBuilder sb, char separator) {
        if (this.skip.isPresent()) {
            sb.append(separator).append("$skip=").append(this.skip.get());
        }
    }

    private void addTopToUrl(StringBuilder sb, char separator) {
        if (this.top.isPresent()) {
            sb.append(separator).append("$top=").append(this.top.get());
        }
    }

    private void addOrderbyToUrl(StringBuilder sb, char separator, boolean inExpand) {
        if (!this.orderBy.isEmpty()) {
            sb.append(separator).append("$orderby=");
            boolean firstDone = false;
            for (OrderBy ob2 : this.orderBy) {
                if (firstDone) {
                    sb.append(",");
                } else {
                    firstDone = true;
                }
                String orderUrl = ob2.toString();
                if (!inExpand) {
                    orderUrl = StringHelper.urlEncode(orderUrl);
                }
                sb.append(orderUrl);
            }
        }
    }

    private void addExpandToUrl(StringBuilder sb, char separator, boolean inExpand) {
        if (!this.expand.isEmpty()) {
            sb.append(separator).append("$expand=");
            boolean firstDone = false;
            for (Expand e2 : this.expand) {
                if (firstDone) {
                    sb.append(",");
                } else {
                    firstDone = true;
                }
                String expandUrl = e2.toString();
                if (!inExpand) {
                    expandUrl = StringHelper.urlEncode(expandUrl);
                }
                sb.append(expandUrl);
            }
        }
    }

    private void addFilterToUrl(StringBuilder sb, char separator, boolean inExpand) {
        if (this.filter != null) {
            sb.append(separator).append("$filter=");
            String filterUrl = this.filter.toUrl();
            if (inExpand) {
                sb.append(filterUrl);
            } else {
                sb.append(StringHelper.urlEncode(filterUrl));
            }
        }
    }

    private void addSelectToUrl(StringBuilder sb, char separator, boolean inExpand) {
        if (!this.select.isEmpty()) {
            sb.append(separator).append("$select=");
            if (this.isSelectDistinct()) {
                sb.append("distinct:");
            }
            boolean firstDone = false;
            for (Property property : this.select) {
                if (firstDone) {
                    sb.append(",");
                } else {
                    firstDone = true;
                }
                if (inExpand) {
                    sb.append(property.getName());
                    continue;
                }
                sb.append(StringHelper.urlEncode(property.getName()));
            }
        }
    }
}

