/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorBoolean;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.PostgresPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.JsonBinding;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.JsonValue;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.PropertyFieldRegistry;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.Utils;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapperAbstractEp;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import org.jooq.Name;
import org.jooq.Table;

public class FieldMapperJson
extends FieldMapperAbstractEp {
    @ConfigurableField(editor=EditorString.class, label="Field", description="The database field to use.")
    @EditorString.EdOptsString
    private String field;
    @ConfigurableField(editor=EditorBoolean.class, label="Is Map", description="Flag indicating the data type is a Map, not a raw json type.")
    @EditorBoolean.EdOptsBool(dflt=true)
    private boolean isMap = true;
    @JsonIgnore
    private int fieldIdx;

    @Override
    public void registerField(PostgresPersistenceManager ppm, StaMainTable staTable) {
        Name tableName = staTable.getQualifiedName();
        Table<?> dbTable = ppm.getDbTable(tableName);
        this.fieldIdx = FieldMapperJson.getOrRegisterField(this.field, dbTable, staTable, new JsonBinding());
    }

    @Override
    public <T extends StaMainTable<T>> void registerMapping(PostgresPersistenceManager ppm, T table) {
        EntityPropertyMain entityProperty = this.getParent().getEntityProperty();
        PropertyFieldRegistry<StaMainTable> pfReg = table.getPropertyFieldRegistry();
        int idx = this.fieldIdx;
        if (this.isMap) {
            pfReg.addEntryMap(entityProperty, t2 -> t2.field(idx));
        } else {
            pfReg.addEntry((Property)entityProperty, true, t2 -> t2.field(idx), new PropertyFieldRegistry.ConverterRecordDeflt<StaMainTable>((t2, tuple, entity, dataSize) -> {
                JsonValue fieldJsonValue = Utils.getFieldJsonValue(tuple, t2.field(idx));
                dataSize.increase(fieldJsonValue.getStringLength());
                entity.setProperty(entityProperty, fieldJsonValue.getValue(entityProperty.getType().getTypeReference()));
            }, (t2, entity, insertFields) -> insertFields.put(t2.field(idx), new JsonValue(entity.getProperty(entityProperty))), (t2, entity, updateFields, message) -> {
                updateFields.put(t2.field(idx), new JsonValue(entity.getProperty(entityProperty)));
                message.addField(entityProperty);
            }));
        }
    }

    public String getField() {
        return this.field;
    }

    public FieldMapperJson setField(String field) {
        this.field = field;
        return this;
    }

    public boolean getIsMap() {
        return this.isMap;
    }

    public FieldMapperJson setIsMap(boolean isMap) {
        this.isMap = isMap;
        return this;
    }
}

