/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.custom.GeoJsonDeserializier;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeValue;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.JsonValue;
import de.fraunhofer.iosb.ilt.frostserver.query.OrderBy;
import de.fraunhofer.iosb.ilt.frostserver.util.SimpleJsonMapper;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.time4j.Moment;
import net.time4j.TemporalType;
import org.geolatte.common.dataformats.json.jackson.JsonMapper;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String INTERVAL_PARAM = "(?)::interval";
    public static final String TIMESTAMP_PARAM = "(?)::timestamp";
    public static final TypeReference<Object> TYPE_OBJECT = new TypeReference<Object>(){};
    public static final TypeReference<List<String>> TYPE_LIST_STRING = new TypeReference<List<String>>(){};
    public static final TypeReference<List<UnitOfMeasurement>> TYPE_LIST_UOM = new TypeReference<List<UnitOfMeasurement>>(){};
    public static final TypeReference<Map<String, Object>> TYPE_MAP_STRING_OBJECT = new TypeReference<Map<String, Object>>(){};
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final String FAILED_JSON_PARSE = "Failed to parse stored json.";
    private static JsonMapper geoJsonMapper;
    private static final JsonValue NULL_JSON_VALUE;

    private Utils() {
    }

    public static JsonMapper getGeoJsonMapper() {
        if (geoJsonMapper == null) {
            geoJsonMapper = new JsonMapper();
        }
        return geoJsonMapper;
    }

    public static TimeInterval intervalFromTimes(Moment timeStart, Moment timeEnd) {
        if (timeStart == null) {
            timeStart = TemporalType.INSTANT.translate(LocalDateTime.MAX.toInstant(ZoneOffset.UTC));
        }
        if (timeEnd == null) {
            timeEnd = TemporalType.INSTANT.translate(LocalDateTime.MIN.toInstant(ZoneOffset.UTC));
        }
        if (timeEnd.isBefore(timeStart)) {
            return null;
        }
        return TimeInterval.create(timeStart, timeEnd);
    }

    public static TimeInstant instantFromTime(Moment time) {
        if (time == null) {
            return new TimeInstant(null);
        }
        return new TimeInstant(time);
    }

    public static TimeValue valueFromTimes(Moment timeStart, Moment timeEnd) {
        if (timeEnd == null || timeEnd.equals(timeStart)) {
            return new TimeValue(Utils.instantFromTime(timeStart));
        }
        return new TimeValue(Utils.intervalFromTimes(timeStart, timeEnd));
    }

    public static Object locationFromEncoding(String encodingType, String locationString) {
        if (locationString == null || locationString.isEmpty()) {
            return null;
        }
        if (encodingType == null) {
            return Utils.locationUnknownEncoding(locationString);
        }
        if (GeoJsonDeserializier.ENCODINGS.contains(encodingType.toLowerCase())) {
            try {
                return new GeoJsonDeserializier().deserialize(locationString);
            }
            catch (IOException ex2) {
                LOGGER.error("Failed to deserialise geoJson.", ex2);
                return locationString;
            }
        }
        try {
            return Utils.jsonToObject(locationString, Object.class);
        }
        catch (Exception ex3) {
            LOGGER.trace("Not a map.", ex3);
            return locationString;
        }
    }

    public static Object locationUnknownEncoding(String locationString) {
        if (locationString == null) {
            return null;
        }
        try {
            return new GeoJsonDeserializier().deserialize(locationString);
        }
        catch (IOException ex2) {
            LOGGER.trace("Not geoJson.", ex2);
            try {
                return Utils.jsonToObject(locationString, Map.class);
            }
            catch (Exception ex3) {
                LOGGER.trace("Not a map.", ex3);
                return locationString;
            }
        }
    }

    public static JsonNode jsonToTree(String json) {
        if (json == null) {
            return null;
        }
        try {
            return SimpleJsonMapper.getSimpleObjectMapper().readTree(json);
        }
        catch (IOException ex2) {
            throw new IllegalStateException(FAILED_JSON_PARSE, ex2);
        }
    }

    public static <T> T jsonToObject(String json, Class<T> clazz) {
        if (json == null) {
            return null;
        }
        try {
            return SimpleJsonMapper.getSimpleObjectMapper().readValue(json, clazz);
        }
        catch (IOException ex2) {
            throw new IllegalStateException(FAILED_JSON_PARSE, ex2);
        }
    }

    public static <T> T jsonToObject(String json, TypeReference<T> typeReference) {
        if (json == null) {
            return null;
        }
        try {
            return SimpleJsonMapper.getSimpleObjectMapper().readValue(json, typeReference);
        }
        catch (IOException ex2) {
            throw new IllegalStateException(FAILED_JSON_PARSE, ex2);
        }
    }

    public static <T> T getFieldOrNull(Record input, Field<T> field) {
        if (input.field(field) != null) {
            return input.get(field);
        }
        return null;
    }

    public static JsonValue getFieldJsonValue(Record input, Field<JsonValue> field) {
        if (input.field(field) != null) {
            return input.get(field);
        }
        return NULL_JSON_VALUE;
    }

    static {
        NULL_JSON_VALUE = new JsonValue((JsonNode)null);
    }

    public static class SortSelectFields {
        private final List<OrderField> sqlSortFields = new ArrayList<OrderField>();
        private final List<Field> sqlSortSelectFields = new ArrayList<Field>();

        public void add(Field field, OrderBy.OrderType type) {
            if (type == OrderBy.OrderType.ASCENDING) {
                this.sqlSortFields.add(field.asc());
            } else {
                this.sqlSortFields.add(field.desc());
            }
            this.sqlSortSelectFields.add(field);
        }

        public List<OrderField> getSqlSortFields() {
            return this.sqlSortFields;
        }

        public List<Field> getSqlSortSelectFields() {
            return this.sqlSortSelectFields;
        }
    }
}

