/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils;

import java.util.Objects;

public class SortingWrapper<O extends Comparable<O>, T>
implements Comparable<SortingWrapper<O, T>> {
    private final O order;
    private final T object;

    public SortingWrapper(O order, T object) {
        this.order = order;
        this.object = object;
    }

    public O getOrder() {
        return this.order;
    }

    public T getObject() {
        return this.object;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.order);
        hash = 31 * hash + Objects.hashCode(this.object);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SortingWrapper other = (SortingWrapper)obj;
        if (!Objects.equals(this.order, other.order)) {
            return false;
        }
        return Objects.equals(this.object, other.object);
    }

    @Override
    public int compareTo(SortingWrapper<O, T> other) {
        if (this.order.equals(other.order)) {
            return Integer.compare(this.object.hashCode(), other.object.hashCode());
        }
        return this.order.compareTo(other.order);
    }
}

