/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils;

import de.fraunhofer.iosb.ilt.frostserver.model.DefaultEntity;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityChangedMessage;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeValue;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.JsonValue;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.EntityFactories;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.DataSize;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.Utils;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyCustomSelect;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.util.ParserUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.time4j.Moment;
import org.jooq.Field;
import org.jooq.Record;

public class PropertyFieldRegistry<T extends StaMainTable<T>> {
    private final T table;
    private final Map<Property, PropertyFields<T>> epMapSelect;
    private final Map<Property, Map<String, ExpressionFactory<T>>> epMapAll;
    private final List<PropertyFields<T>> allSelectPropertyFields;

    public PropertyFieldRegistry(T table) {
        this.table = table;
        this.epMapSelect = new HashMap<Property, PropertyFields<T>>();
        this.epMapAll = new HashMap<Property, Map<String, ExpressionFactory<T>>>();
        this.allSelectPropertyFields = new ArrayList<PropertyFields<T>>();
    }

    public PropertyFieldRegistry(T table, PropertyFieldRegistry<T> copyFrom) {
        this.table = table;
        this.epMapSelect = copyFrom.epMapSelect;
        this.epMapAll = copyFrom.epMapAll;
        this.allSelectPropertyFields = copyFrom.allSelectPropertyFields;
    }

    public Collection<PropertyFields<T>> getSelectFields(Collection<PropertyFields<T>> target) {
        Collection<PropertyFields<T>> result = target;
        if (result == null) {
            result = new ArrayList<PropertyFields<T>>();
        }
        result.addAll(this.allSelectPropertyFields);
        return result;
    }

    public PropertyFields<T> getSelectFieldsForProperty(Property property) {
        if (property instanceof EntityPropertyCustomSelect) {
            EntityPropertyCustomSelect epCustomSelect = (EntityPropertyCustomSelect)property;
            return this.table.handleEntityPropertyCustomSelect(epCustomSelect);
        }
        return this.epMapSelect.get(property);
    }

    public Map<String, Field> getAllFieldsForProperty(EntityPropertyMain property, Map<String, Field> target) {
        Map<String, ExpressionFactory<T>> coreMap = this.epMapAll.get(property);
        if (coreMap == null) {
            throw new IllegalArgumentException("No property called " + property.toString() + " for " + this.table.getClass());
        }
        Map<String, Field> result = target;
        if (result == null) {
            result = new LinkedHashMap<String, Field>();
        }
        for (Map.Entry<String, ExpressionFactory<T>> es2 : coreMap.entrySet()) {
            result.put(es2.getKey(), es2.getValue().get(this.table));
        }
        return result;
    }

    public Set<PropertyFields<T>> getFieldsForProperties(Set<Property> selectedProperties) {
        LinkedHashSet<PropertyFields<T>> exprSet = new LinkedHashSet<PropertyFields<T>>();
        if (selectedProperties.isEmpty()) {
            this.getSelectFields(exprSet);
        } else {
            for (Property property : selectedProperties) {
                PropertyFields<T> selectFieldsForProperty = this.getSelectFieldsForProperty(property);
                if (selectFieldsForProperty == null) continue;
                exprSet.add(selectFieldsForProperty);
            }
        }
        return exprSet;
    }

    public void addEntry(NavigationPropertyMain property, ExpressionFactory<T> factory) {
        if (property instanceof NavigationPropertyMain.NavigationPropertyEntity) {
            this.addEntry((NavigationPropertyMain.NavigationPropertyEntity)property, factory);
        } else if (property instanceof NavigationPropertyMain.NavigationPropertyEntitySet) {
            this.addEntry((NavigationPropertyMain.NavigationPropertyEntitySet)property, factory);
        } else {
            throw new IllegalArgumentException("Unknown NavigationProperty type: " + property);
        }
    }

    public void addEntry(NavigationPropertyMain.NavigationPropertyEntity property, ExpressionFactory<T> factory) {
        PropertyFields<T> pf2 = new PropertyFields<T>(property, new ConverterEntity<T>(property, factory));
        pf2.addField(null, factory);
        this.epMapSelect.put(property, pf2);
        this.allSelectPropertyFields.add(pf2);
        this.addEntry(this.epMapAll, property, null, factory);
    }

    public void addEntry(NavigationPropertyMain.NavigationPropertyEntity property, ExpressionFactory<T> factory, ConverterRecord<T> ps2) {
        PropertyFields<T> pf2 = new PropertyFields<T>(property, ps2);
        pf2.addField(null, factory);
        this.epMapSelect.put(property, pf2);
        this.allSelectPropertyFields.add(pf2);
        this.addEntry(this.epMapAll, property, null, factory);
    }

    public void addEntry(NavigationPropertyMain.NavigationPropertyEntitySet property, ExpressionFactory<T> factory) {
        PropertyFields<T> pf2 = new PropertyFields<T>(property, new ConverterEntitySet());
        pf2.addField(null, factory);
        this.epMapSelect.put(property, pf2);
        this.allSelectPropertyFields.add(pf2);
        this.addEntry(this.epMapAll, property, null, factory);
    }

    public void addEntryString(EntityProperty<String> property, ExpressionFactory<T> factory) {
        PropertyFields<T> pf2 = new PropertyFields<T>(property, new ConverterString<T>(property, factory));
        pf2.addField(null, factory);
        this.epMapSelect.put(property, pf2);
        this.allSelectPropertyFields.add(pf2);
        this.addEntry(this.epMapAll, property, null, factory);
    }

    public void addEntryNumeric(EntityProperty<BigDecimal> property, ExpressionFactory<T> factory) {
        PropertyFields<T> pf2 = new PropertyFields<T>(property, new ConverterSimple<T>(property, factory));
        pf2.addField(null, factory);
        this.epMapSelect.put(property, pf2);
        this.allSelectPropertyFields.add(pf2);
        this.addEntry(this.epMapAll, property, null, factory);
    }

    public void addEntryId(ExpressionFactory<T> factory) {
        ConverterId<T> converterId = new ConverterId<T>(factory, true);
        this.addEntry(this.table.getEntityType().getPrimaryKey(), factory, converterId);
        this.addEntry(ModelRegistry.EP_SELFLINK, factory, converterId);
    }

    public void addEntryMap(EntityProperty<Map<String, Object>> property, ExpressionFactory<T> factory) {
        PropertyFields<T> pf2 = new PropertyFields<T>(property, true, new ConverterMap<T>(property, factory));
        pf2.addField(null, factory);
        this.epMapSelect.put(property, pf2);
        this.allSelectPropertyFields.add(pf2);
        this.addEntry(this.epMapAll, property, null, factory);
    }

    public void addEntrySimple(EntityProperty property, ExpressionFactory<T> factory) {
        PropertyFields<T> pf2 = new PropertyFields<T>(property, new ConverterSimple<T>(property, factory));
        pf2.addField(null, factory);
        this.epMapSelect.put(property, pf2);
        this.allSelectPropertyFields.add(pf2);
        this.addEntry(this.epMapAll, property, null, factory);
    }

    public void addEntry(Property property, ExpressionFactory<T> factory, ConverterRecord<T> ps2) {
        this.addEntry(property, false, factory, ps2);
    }

    public void addEntry(Property property, boolean isJson, ExpressionFactory<T> factory, ConverterRecord<T> ps2) {
        PropertyFields<T> pf2 = new PropertyFields<T>(property, isJson, ps2);
        if (factory != null) {
            pf2.addField(null, factory);
            this.addEntry(this.epMapAll, property, null, factory);
        }
        this.epMapSelect.put(property, pf2);
        this.allSelectPropertyFields.add(pf2);
    }

    public void addEntry(Property property, ConverterRecord<T> ps2, NFP<T> ... factories) {
        this.addEntry(property, false, ps2, factories);
    }

    public void addEntry(Property property, boolean isJson, ConverterRecord<T> ps2, NFP<T> ... factories) {
        PropertyFields pf2 = new PropertyFields(property, isJson, ps2);
        for (NFP<T> nfp : factories) {
            pf2.addField(nfp.name, nfp.factory);
            this.addEntry(this.epMapAll, property, nfp.name, nfp.factory);
        }
        this.epMapSelect.put(property, pf2);
        this.allSelectPropertyFields.add(pf2);
    }

    public void addEntryNoSelect(Property property, String name, ExpressionFactory<T> factory) {
        this.addEntry(this.epMapAll, property, name, factory);
    }

    private void addEntry(Map<Property, Map<String, ExpressionFactory<T>>> map, Property property, String name, ExpressionFactory<T> factory) {
        Map coreMap = map.computeIfAbsent(property, k2 -> new LinkedHashMap());
        String key = name;
        if (key == null) {
            key = Integer.toString(coreMap.size());
        }
        coreMap.put(key, factory);
    }

    public static class ConverterEntitySet<T>
    implements ConverterRecord<T> {
        @Override
        public void convert(T table, Record input, Entity entity, DataSize dataSize) {
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> insertFields) {
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> updateFields, EntityChangedMessage message) {
        }
    }

    public static class ConverterEntity<T>
    implements ConverterRecord<T> {
        private final NavigationPropertyMain<Entity> property;
        private final ExpressionFactory<T> factory;

        public ConverterEntity(NavigationPropertyMain<Entity> property, ExpressionFactory<T> factory) {
            this.property = property;
            this.factory = factory;
        }

        @Override
        public void convert(T table, Record input, Entity entity, DataSize dataSize) {
            Object rawId = Utils.getFieldOrNull(input, this.factory.get(table));
            if (rawId == null) {
                return;
            }
            DefaultEntity childEntity = new DefaultEntity(this.property.getEntityType(), ParserUtils.idFromObject(rawId));
            entity.setProperty(this.property, childEntity);
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> insertFields) {
            Entity child = entity.getProperty(this.property);
            insertFields.put(this.factory.get(table), child.getId().getValue());
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> updateFields, EntityChangedMessage message) {
            Entity child = entity.getProperty(this.property);
            updateFields.put(this.factory.get(table), child.getId().getValue());
            message.addField(this.property);
        }
    }

    public static class ConverterId<T>
    implements ConverterRecord<T> {
        private final ExpressionFactory<T> factory;
        private final boolean canEdit;

        public ConverterId(ExpressionFactory<T> factory, boolean canEdit) {
            this.factory = factory;
            this.canEdit = canEdit;
        }

        @Override
        public void convert(T table, Record input, Entity entity, DataSize dataSize) {
            Object rawId = Utils.getFieldOrNull(input, this.factory.get(table));
            Id id2 = ParserUtils.idFromObject(rawId);
            entity.setProperty(entity.getEntityType().getPrimaryKey(), id2);
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> insertFields) {
            if (!this.canEdit) {
                return;
            }
            Id id2 = entity.getProperty(entity.getEntityType().getPrimaryKey());
            if (id2 == null) {
                return;
            }
            insertFields.put(this.factory.get(table), id2.getValue());
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> updateFields, EntityChangedMessage message) {
        }
    }

    public static class ConverterMap<T>
    implements ConverterRecord<T> {
        private final Property property;
        private final ExpressionFactory<T> factory;

        public ConverterMap(Property property, ExpressionFactory<T> factory) {
            this.property = property;
            this.factory = factory;
        }

        @Override
        public void convert(T table, Record input, Entity entity, DataSize dataSize) {
            JsonValue data = Utils.getFieldJsonValue(input, this.factory.get(table));
            if (data == null) {
                return;
            }
            dataSize.increase(data.getStringLength());
            entity.setProperty(this.property, data.getMapValue());
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> insertFields) {
            insertFields.put(this.factory.get(table), new JsonValue(entity.getProperty(this.property)));
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> updateFields, EntityChangedMessage message) {
            updateFields.put(this.factory.get(table), new JsonValue(entity.getProperty(this.property)));
            message.addField(this.property);
        }
    }

    public static class ConverterTimeValue<T>
    implements ConverterRecord<T> {
        private final Property<TimeValue> property;
        private final ExpressionFactory<T> factoryStart;
        private final ExpressionFactory<T> factoryEnd;

        public ConverterTimeValue(Property<TimeValue> property, ExpressionFactory<T> factoryStart, ExpressionFactory<T> factoryEnd) {
            this.property = property;
            this.factoryStart = factoryStart;
            this.factoryEnd = factoryEnd;
        }

        @Override
        public void convert(T table, Record input, Entity entity, DataSize dataSize) {
            entity.setProperty(this.property, Utils.valueFromTimes((Moment)input.get(this.factoryStart.get(table)), (Moment)input.get(this.factoryEnd.get(table))));
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> insertFields) {
            TimeValue value = entity.getProperty(this.property);
            EntityFactories.insertTimeValue(insertFields, this.factoryStart.get(table), this.factoryEnd.get(table), value);
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> updateFields, EntityChangedMessage message) {
            TimeValue value = entity.getProperty(this.property);
            EntityFactories.insertTimeValue(updateFields, this.factoryStart.get(table), this.factoryEnd.get(table), value);
            message.addField(this.property);
        }
    }

    public static class ConverterTimeInstant<T>
    implements ConverterRecord<T> {
        private final Property<TimeInstant> property;
        private final ExpressionFactory<T> factory;

        public ConverterTimeInstant(Property<TimeInstant> property, ExpressionFactory<T> factory) {
            this.property = property;
            this.factory = factory;
        }

        @Override
        public void convert(T table, Record input, Entity entity, DataSize dataSize) {
            entity.setProperty(this.property, Utils.instantFromTime((Moment)input.get(this.factory.get(table))));
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> insertFields) {
            TimeInstant instant = entity.getProperty(this.property);
            EntityFactories.insertTimeInstant(insertFields, this.factory.get(table), instant);
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> updateFields, EntityChangedMessage message) {
            TimeInstant instant = entity.getProperty(this.property);
            EntityFactories.insertTimeInstant(updateFields, this.factory.get(table), instant);
            message.addField(this.property);
        }
    }

    public static class ConverterTimeInterval<T>
    implements ConverterRecord<T> {
        private final Property<TimeInterval> property;
        private final ExpressionFactory<T> factoryStart;
        private final ExpressionFactory<T> factoryEnd;

        public ConverterTimeInterval(Property<TimeInterval> property, ExpressionFactory<T> factoryStart, ExpressionFactory<T> factoryEnd) {
            this.property = property;
            this.factoryStart = factoryStart;
            this.factoryEnd = factoryEnd;
        }

        @Override
        public void convert(T table, Record input, Entity entity, DataSize dataSize) {
            entity.setProperty(this.property, Utils.intervalFromTimes((Moment)input.get(this.factoryStart.get(table)), (Moment)input.get(this.factoryEnd.get(table))));
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> insertFields) {
            TimeInterval interval = entity.getProperty(this.property);
            EntityFactories.insertTimeInterval(insertFields, this.factoryStart.get(table), this.factoryEnd.get(table), interval);
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> updateFields, EntityChangedMessage message) {
            TimeInterval interval = entity.getProperty(this.property);
            EntityFactories.insertTimeInterval(updateFields, this.factoryStart.get(table), this.factoryEnd.get(table), interval);
            message.addField(this.property);
        }
    }

    public static class ConverterString<T>
    implements ConverterRecord<T> {
        private final Property property;
        private final ExpressionFactory<T> factory;

        public ConverterString(Property property, ExpressionFactory<T> factory) {
            this.property = property;
            this.factory = factory;
        }

        @Override
        public void convert(T table, Record input, Entity entity, DataSize dataSize) {
            String data = (String)input.get(this.factory.get(table));
            dataSize.increase(data == null ? 0L : (long)data.length());
            entity.setProperty(this.property, data);
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> insertFields) {
            insertFields.put(this.factory.get(table), entity.getProperty(this.property));
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> updateFields, EntityChangedMessage message) {
            updateFields.put(this.factory.get(table), entity.getProperty(this.property));
            message.addField(this.property);
        }
    }

    public static class ConverterSimple<T>
    implements ConverterRecord<T> {
        private final Property property;
        private final ExpressionFactory<T> factory;

        public ConverterSimple(Property property, ExpressionFactory<T> factory) {
            this.property = property;
            this.factory = factory;
        }

        @Override
        public void convert(T table, Record input, Entity entity, DataSize dataSize) {
            entity.setProperty(this.property, input.get(this.factory.get(table)));
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> insertFields) {
            insertFields.put(this.factory.get(table), entity.getProperty(this.property));
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> updateFields, EntityChangedMessage message) {
            updateFields.put(this.factory.get(table), entity.getProperty(this.property));
            message.addField(this.property);
        }
    }

    public static class NFP<T> {
        public final String name;
        public final ExpressionFactory<T> factory;

        public NFP(String name, ExpressionFactory<T> factory) {
            this.name = name;
            this.factory = factory;
        }
    }

    public static class PropertyFactoryCombo<T> {
        public final Property property;
        public final ExpressionFactory<T> factory;

        public PropertyFactoryCombo(Property property, ExpressionFactory<T> factory) {
            this.property = property;
            this.factory = factory;
        }
    }

    public static class PropertyFields<T> {
        public final Property property;
        public final boolean jsonType;
        public final Map<String, ExpressionFactory<T>> fields = new LinkedHashMap<String, ExpressionFactory<T>>();
        public final ConverterRecord<T> converter;

        public PropertyFields(Property property, ConverterRecord<T> converter) {
            this(property, false, converter);
        }

        public PropertyFields(Property property, boolean jsonType, ConverterRecord<T> converter) {
            this.property = property;
            this.converter = converter;
            this.jsonType = jsonType;
        }

        public PropertyFields<T> addField(String name, ExpressionFactory<T> field) {
            String key = name;
            if (key == null) {
                key = Integer.toString(this.fields.size());
            }
            this.fields.put(key, field);
            return this;
        }
    }

    public static class ConverterRecordDeflt<T>
    implements ConverterRecord<T> {
        private static final ConverterRecordInsert NULL_INSERT = (table, entity, insertFields) -> {};
        private static final ConverterRecordUpdate NULL_UPDATE = (table, entity, updateFields, message) -> {};
        private final ConverterRecordRead<T> read;
        private final ConverterRecordInsert<T> insert;
        private final ConverterRecordUpdate<T> update;

        public ConverterRecordDeflt(ConverterRecordRead<T> read, ConverterRecordInsert<T> insert, ConverterRecordUpdate<T> update) {
            this.read = read;
            this.insert = insert == null ? NULL_INSERT : insert;
            this.update = update == null ? NULL_UPDATE : update;
        }

        @Override
        public void convert(T table, Record input, Entity entity, DataSize dataSize) {
            this.read.convert(table, input, entity, dataSize);
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> insertFields) {
            this.insert.convert(table, entity, insertFields);
        }

        @Override
        public void convert(T table, Entity entity, Map<Field, Object> updateFields, EntityChangedMessage message) {
            this.update.convert(table, entity, updateFields, message);
        }
    }

    public static interface ConverterRecord<T>
    extends ConverterRecordRead<T>,
    ConverterRecordInsert<T>,
    ConverterRecordUpdate<T> {
    }

    public static interface ConverterRecordUpdate<T> {
        public void convert(T var1, Entity var2, Map<Field, Object> var3, EntityChangedMessage var4);
    }

    public static interface ConverterRecordInsert<T> {
        public void convert(T var1, Entity var2, Map<Field, Object> var3);
    }

    public static interface ConverterRecordRead<T> {
        public void convert(T var1, Record var2, Entity var3, DataSize var4);
    }

    public static interface ExpressionFactory<T> {
        public Field get(T var1);
    }
}

