/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefModel;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.EntityFactories;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaLinkTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTableAbstract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TableCollection {
    private ModelRegistry modelRegistry;
    private boolean initialised = false;
    private List<DefModel> modelDefinitions;
    private final Map<EntityType, StaMainTable<?>> tablesByType = new LinkedHashMap();
    private final Map<Class<?>, StaTable<?>> tablesByClass = new LinkedHashMap();
    private final Map<String, StaTable<?>> tablesByName = new LinkedHashMap();

    public TableCollection setModelRegistry(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
        return this;
    }

    public StaMainTable<?> getTableForType(EntityType type) {
        return this.tablesByType.get(type);
    }

    public <T extends StaTable<T>> T getTableForClass(Class<T> clazz) {
        return (T)this.tablesByClass.get(clazz);
    }

    public StaTable<?> getTableForName(String name) {
        return this.tablesByName.get(name);
    }

    public Collection<StaMainTable<?>> getAllTables() {
        return this.tablesByType.values();
    }

    public void registerTable(EntityType type, StaTableAbstract<?> table) {
        this.tablesByType.put(type, table);
        this.tablesByClass.put(table.getClass(), table);
        this.tablesByName.put(table.getName(), table);
        table.init(this.modelRegistry, this);
    }

    public void registerTable(StaLinkTable<?> table) {
        this.tablesByClass.put(table.getClass(), table);
        this.tablesByName.put(table.getName(), table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(EntityFactories entityFactories) {
        if (this.initialised) {
            return;
        }
        TableCollection tableCollection = this;
        synchronized (tableCollection) {
            if (!this.initialised) {
                this.initialised = true;
                for (StaMainTable<?> table : this.getAllTables()) {
                    table.initProperties(entityFactories);
                    table.initRelations();
                }
            }
        }
    }

    public Map<EntityType, StaMainTable<?>> getTablesByType() {
        return this.tablesByType;
    }

    public List<DefModel> getModelDefinitions() {
        if (this.modelDefinitions == null) {
            this.modelDefinitions = new ArrayList<DefModel>();
        }
        return this.modelDefinitions;
    }

    public void clearModelDefinitions() {
        this.modelDefinitions = Collections.emptyList();
    }
}

