/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.JsonReader;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.JsonWriter;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityChangedMessage;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefEntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefEntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefModel;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefNavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.PropertyPersistenceMapper;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.persistence.AbstractPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.IdGenerationType;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.QueryBuilder;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.ResultBuilder;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.EntityFactories;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaLinkTableDynamic;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTableDynamic;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.TableCollection;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.ConnectionUtils;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.DataSize;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.LiquibaseHelper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.PropertyFieldRegistry;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapper;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.util.LiquibaseUser;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.NoSuchEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.UpgradeFailedException;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.time4j.Moment;
import net.time4j.format.expert.Iso8601Format;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Delete;
import org.jooq.Meta;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.ResultQuery;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresPersistenceManager
extends AbstractPersistenceManager
implements LiquibaseUser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresPersistenceManager.class.getName());
    private static final String LIQUIBASE_CHANGELOG_FILENAME = "liquibase/core.xml";
    public static final String DATETIME_MAX_INSTANT = "9999-12-30T23:59:59.999Z";
    public static final String DATETIME_MIN_INSTANT = "0001-01-02T00:00:00.000Z";
    public static final Moment DATETIME_MAX = PostgresPersistenceManager.parseMoment("9999-12-30T23:59:59.999Z");
    public static final Moment DATETIME_MIN = PostgresPersistenceManager.parseMoment("0001-01-02T00:00:00.000Z");
    private static final String SOURCE_NAME_FROST = "FROST-Source";
    private static final String ID_TYPE = "idType-";
    private static final Map<CoreSettings, TableCollection> tableCollections = new HashMap<CoreSettings, TableCollection>();
    private boolean initialised = false;
    private TableCollection tableCollection;
    private EntityFactories entityFactories;
    private CoreSettings settings;
    private IdGenerationType idGenerationMode;
    private ConnectionUtils.ConnectionWrapper connectionProvider;
    private DSLContext dslContext;
    private DataSize dataSize;

    static final Moment parseMoment(String value) {
        try {
            return Iso8601Format.EXTENDED_DATE_TIME_OFFSET.parse(value);
        }
        catch (ParseException ex2) {
            LOGGER.error("Failed to parse Moment: {}", (Object)value);
            return null;
        }
    }

    private static TableCollection getTableCollection(CoreSettings settings) {
        return tableCollections.computeIfAbsent(settings, t2 -> new TableCollection().setModelRegistry(t2.getModelRegistry()));
    }

    @Override
    public void init(CoreSettings settings) {
        this.settings = settings;
        this.tableCollection = PostgresPersistenceManager.getTableCollection(settings);
        this.getTableCollection().setModelRegistry(settings.getModelRegistry());
        Settings customSettings = settings.getPersistenceSettings().getCustomSettings();
        this.connectionProvider = new ConnectionUtils.ConnectionWrapper(customSettings, SOURCE_NAME_FROST);
        this.entityFactories = new EntityFactories(settings.getModelRegistry(), this.tableCollection);
        this.dataSize = new DataSize(settings.getDataSizeMax());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.initialised) {
            return;
        }
        TableCollection tableCollection = this.tableCollection;
        synchronized (tableCollection) {
            if (!this.initialised) {
                this.idGenerationMode = IdGenerationType.findType(this.settings.getPersistenceSettings().getIdGenerationMode());
                this.tableCollection.init(this.entityFactories);
                this.loadMapping();
                this.initialised = true;
            }
        }
    }

    @Override
    public CoreSettings getCoreSettings() {
        return this.settings;
    }

    public TableCollection getTableCollection() {
        return this.tableCollection;
    }

    public EntityFactories getEntityFactories() {
        return this.entityFactories;
    }

    public DSLContext getDslContext() {
        if (this.dslContext == null) {
            this.dslContext = DSL.using(this.connectionProvider.get(), SQLDialect.POSTGRES);
        }
        return this.dslContext;
    }

    public ConnectionUtils.ConnectionWrapper getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public boolean validatePath(ResourcePath path) {
        PathElement element;
        this.init();
        if (element == null) {
            return true;
        }
        ResourcePath tempPath = new ResourcePath();
        int idCount = 0;
        for (element = path.getIdentifiedElement(); element != null; element = element.getParent()) {
            PathElementEntity entityPathElement;
            Id id2;
            if (element instanceof PathElementEntity && (id2 = (entityPathElement = element).getId()) != null) {
                ++idCount;
                if (!this.getEntityFactories().entityExists(this, entityPathElement.getEntityType(), id2)) {
                    return false;
                }
            }
            tempPath.addPathElement(0, element);
        }
        if (idCount < 2) {
            return true;
        }
        QueryBuilder psb = new QueryBuilder(this, this.settings, this.getTableCollection());
        ResultQuery<Record1<Integer>> query = psb.forPath(tempPath).buildCount();
        Integer count = query.fetchOne().component1();
        return count == 1;
    }

    @Override
    public Entity get(EntityType entityType, Id id2) {
        return this.get(entityType, id2, false, null);
    }

    public Entity get(EntityType entityType, Id id2, Query query) {
        return this.get(entityType, id2, false, query);
    }

    private Entity get(EntityType entityType, Id id2, boolean forUpdate, Query query) {
        this.init();
        QueryBuilder psb = new QueryBuilder(this, this.settings, this.getTableCollection());
        ResultQuery<Record> sqlQuery = psb.forTypeAndId(entityType, id2).usingQuery(query).forUpdate(forUpdate).buildSelect();
        Record result = sqlQuery.fetchAny();
        if (result == null) {
            return null;
        }
        return psb.getQueryState().entityFromQuery(result, this.dataSize).setQuery(query);
    }

    @Override
    public Object get(ResourcePath path, Query query) {
        Map map;
        this.init();
        PathElement lastElement = path.getLastElement();
        if (!(lastElement instanceof PathElementEntity) && !(lastElement instanceof PathElementEntitySet)) {
            if (!query.getExpand().isEmpty()) {
                LOGGER.warn("Expand only allowed on Entities or EntitySets. Not on {}!", (Object)lastElement.getClass());
                query.getExpand().clear();
            }
            if (!query.getSelect().isEmpty()) {
                LOGGER.warn("Select only allowed on Entities or EntitySets. Not on {}!", (Object)lastElement.getClass());
                query.getSelect().clear();
            }
        }
        QueryBuilder psb = new QueryBuilder(this, this.settings, this.getTableCollection()).forPath(path).usingQuery(query);
        ResultBuilder entityCreator = new ResultBuilder(this, path, query, psb, this.dataSize);
        lastElement.visit(entityCreator);
        Object entity = entityCreator.getEntity();
        if (path.isEntityProperty() && entity instanceof Map && (map = (Map)entity).get(entityCreator.getEntityName()) == null) {
            return null;
        }
        if (path.isValue() && entity instanceof Map) {
            map = (Map)entity;
            entity = map.get(entityCreator.getEntityName());
        }
        return entity;
    }

    @Override
    public boolean doInsert(Entity entity) throws NoSuchEntityException, IncompleteEntityException {
        this.init();
        StaMainTable<?> table = this.getTableCollection().getTableForType(entity.getEntityType());
        return table.insertIntoDatabase(this, entity);
    }

    @Override
    public EntityChangedMessage doUpdate(PathElementEntity pathElement, Entity entity) throws NoSuchEntityException, IncompleteEntityException {
        this.init();
        EntityFactories ef2 = this.getEntityFactories();
        entity.setId(pathElement.getId());
        Object id2 = pathElement.getId().getValue();
        if (!ef2.entityExists(this, entity)) {
            throw new NoSuchEntityException("No entity of type " + pathElement.getEntityType() + " with id " + id2);
        }
        StaMainTable<?> table = this.getTableCollection().getTableForType(entity.getEntityType());
        return table.updateInDatabase(this, entity, id2);
    }

    @Override
    public EntityChangedMessage doUpdate(PathElementEntity pathElement, JsonPatch patch) throws NoSuchEntityException, IncompleteEntityException {
        Entity newEntity;
        JsonNode newNode;
        this.init();
        EntityType entityType = pathElement.getEntityType();
        Id id2 = pathElement.getId();
        Entity original = this.get(entityType, id2, true, null);
        if (original == null) {
            throw new IllegalArgumentException("No Entity of type " + entityType.entityName + " with id " + id2);
        }
        original.setEntityPropertiesSet(false, false);
        original.setQuery(this.settings.getModelRegistry().getMessageQueryGenerator().getQueryFor(entityType));
        Object originalNode = JsonWriter.getObjectMapper().valueToTree(original);
        LOGGER.trace("Old {}", originalNode);
        try {
            newNode = patch.apply((JsonNode)originalNode);
        }
        catch (JsonPatchException ex2) {
            throw new IllegalArgumentException("Failed to apply patch.", ex2);
        }
        LOGGER.trace("New {}", (Object)newNode);
        ModelRegistry modelRegistry = this.settings.getModelRegistry();
        try {
            JsonReader entityParser = new JsonReader(modelRegistry);
            newEntity = entityParser.parseEntity(original.getEntityType(), newNode.toString());
            newEntity.setId(id2);
        }
        catch (IOException ex3) {
            LOGGER.error("Failed to parse JSON after patch.");
            throw new IllegalArgumentException("Exception", ex3);
        }
        EntityChangedMessage message = new EntityChangedMessage();
        newEntity.setEntityPropertiesSet(original, message);
        if (message.getEpFields().isEmpty() && message.getNpFields().isEmpty()) {
            LOGGER.warn("Patch did not change anything.");
            throw new IllegalArgumentException("Patch did not change anything.");
        }
        StaMainTable<?> table = this.getTableCollection().getTableForType(entityType);
        table.updateInDatabase(this, newEntity, id2.getValue());
        message.setEntity(newEntity);
        message.setEventType(EntityChangedMessage.Type.UPDATE);
        return message;
    }

    @Override
    public boolean doDelete(PathElementEntity pathElement) throws NoSuchEntityException {
        this.init();
        EntityType type = pathElement.getEntityType();
        StaMainTable<?> table = this.getTableCollection().getTableForType(type);
        table.delete(this, pathElement.getId().getValue());
        return true;
    }

    @Override
    public void doDelete(ResourcePath path, Query query) {
        this.init();
        query.clearSelect();
        query.addSelect((Property)path.getMainElementType().getEntityProperty("id"));
        QueryBuilder psb = new QueryBuilder(this, this.settings, this.getTableCollection()).forPath(path).usingQuery(query);
        Delete sqlDelete = psb.buildDelete((PathElementEntitySet)path.getLastElement());
        long rowCount = sqlDelete.execute();
        LOGGER.debug("Deleted {} rows using query {}", (Object)rowCount, (Object)sqlDelete);
    }

    @Override
    protected boolean doCommit() {
        return this.connectionProvider.commit();
    }

    @Override
    protected boolean doRollback() {
        return this.connectionProvider.rollback();
    }

    @Override
    protected boolean doClose() {
        try {
            this.connectionProvider.close();
            return true;
        }
        catch (SQLException ex2) {
            LOGGER.error("Failed to close connection.", ex2);
            return false;
        }
    }

    public IdGenerationType getIdGenerationMode() {
        return this.idGenerationMode;
    }

    protected boolean validateClientSuppliedId(Id entityId) {
        return entityId != null && entityId.getValue() != null;
    }

    public void modifyClientSuppliedId(Entity entity) {
    }

    public boolean useClientSuppliedId(Entity entity) throws IncompleteEntityException {
        Id entityId = entity.getId();
        switch (this.idGenerationMode) {
            case SERVER_GENERATED_ONLY: {
                if (entityId == null || entityId.getValue() == null) {
                    LOGGER.trace("Using server generated id.");
                    return false;
                }
                LOGGER.warn("idGenerationMode is '{}' but @iot.id '{}' is present. Ignoring @iot.id.", (Object)this.idGenerationMode, (Object)entityId);
                return false;
            }
            case SERVER_AND_CLIENT_GENERATED: {
                if (this.validateClientSuppliedId(entityId)) break;
                LOGGER.debug("No valid @iot.id. Using server generated id.");
                return false;
            }
            case CLIENT_GENERATED_ONLY: {
                if (this.validateClientSuppliedId(entityId)) break;
                LOGGER.error("No @iot.id and idGenerationMode is '{}'", (Object)this.idGenerationMode);
                throw new IncompleteEntityException("Error: no @iot.id");
            }
            default: {
                LOGGER.error("idGenerationMode '{}' is not implemented.", (Object)this.idGenerationMode);
                throw new IllegalArgumentException("idGenerationMode '" + this.idGenerationMode.toString() + "' is not implemented.");
            }
        }
        LOGGER.info("Using client generated id.");
        return true;
    }

    public String checkForUpgrades(String liquibaseChangelogFilename, Map<String, Object> params) {
        try {
            Settings customSettings = this.settings.getPersistenceSettings().getCustomSettings();
            Connection connection = ConnectionUtils.getConnection(SOURCE_NAME_FROST, customSettings);
            return LiquibaseHelper.checkForUpgrades(connection, liquibaseChangelogFilename, params);
        }
        catch (SQLException ex2) {
            LOGGER.error("Could not initialise database.", ex2);
            return "Failed to initialise database:\n" + ex2.getLocalizedMessage() + "\n";
        }
    }

    public boolean doUpgrades(String liquibaseChangelogFilename, Map<String, Object> params, Writer out) throws UpgradeFailedException, IOException {
        Connection connection;
        Settings customSettings = this.settings.getPersistenceSettings().getCustomSettings();
        try {
            connection = ConnectionUtils.getConnection(SOURCE_NAME_FROST, customSettings);
        }
        catch (SQLException ex2) {
            LOGGER.error("Could not initialise database.", ex2);
            out.append("Failed to initialise database:\n");
            out.append(ex2.getLocalizedMessage());
            out.append("\n");
            return false;
        }
        return LiquibaseHelper.doUpgrades(connection, liquibaseChangelogFilename, params, out);
    }

    @Override
    public void addModelMapping(DefModel modelDefinition) {
        this.tableCollection.getModelDefinitions().add(modelDefinition);
    }

    private void loadMapping() {
        List<DefModel> modelDefinitions = this.tableCollection.getModelDefinitions();
        if (modelDefinitions.isEmpty()) {
            return;
        }
        this.getDslContext();
        for (DefModel modelDefinition : modelDefinitions) {
            LOGGER.info("Reading Database Tables.");
            for (DefEntityType entityTypeDef : modelDefinition.getEntityTypes()) {
                String tableName = entityTypeDef.getTable();
                LOGGER.info("  Table: {}.", (Object)tableName);
                this.getDbTable(tableName);
                this.getOrCreateMainTable(entityTypeDef.getEntityType(this.settings.getModelRegistry()), entityTypeDef.getTable());
            }
        }
        for (DefModel modelDefinition : modelDefinitions) {
            this.registerModelFields(modelDefinition);
        }
        for (DefModel modelDefinition : modelDefinitions) {
            this.registerModelMappings(modelDefinition);
        }
        this.tableCollection.clearModelDefinitions();
        for (EntityType entityType : this.settings.getModelRegistry().getEntityTypes()) {
            StaMainTable<?> tableForType = this.tableCollection.getTableForType(entityType);
            PropertyFieldRegistry<?> pfReg = tableForType.getPropertyFieldRegistry();
            for (Property property : entityType.getPropertySet()) {
                PropertyFieldRegistry.PropertyFields<?> pf2 = pfReg.getSelectFieldsForProperty(property);
                if (pf2 != null && pf2.converter != null) continue;
                LOGGER.error("Property {} is not backed by table {}.", (Object)property.getName(), (Object)tableForType.getName());
            }
        }
    }

    private void registerModelFields(DefModel modelDefinition) {
        for (DefEntityType entityTypeDef : modelDefinition.getEntityTypes()) {
            EntityType entityType = entityTypeDef.getEntityType(this.settings.getModelRegistry());
            StaMainTable typeStaTable = this.getOrCreateMainTable(entityType, entityTypeDef.getTable());
            for (DefEntityProperty defEntityProperty : entityTypeDef.getEntityProperties()) {
                this.registerFieldsForEntityProperty(defEntityProperty, typeStaTable);
            }
            for (DefNavigationProperty defNavigationProperty : entityTypeDef.getNavigationProperties()) {
                this.registerFieldsForNavProperty(defNavigationProperty, typeStaTable);
            }
        }
    }

    private void registerFieldsForEntityProperty(DefEntityProperty propertyDef, StaMainTable typeStaTable) {
        for (PropertyPersistenceMapper handler : propertyDef.getHandlers()) {
            this.maybeRegisterField(handler, typeStaTable);
        }
    }

    private void registerFieldsForNavProperty(DefNavigationProperty propertyDef, StaMainTable typeStaTable) {
        for (PropertyPersistenceMapper handler : propertyDef.getHandlers()) {
            this.maybeRegisterField(handler, typeStaTable);
        }
    }

    private void maybeRegisterField(PropertyPersistenceMapper handler, StaMainTable typeStaTable) {
        if (handler instanceof FieldMapper) {
            ((FieldMapper)handler).registerField(this, typeStaTable);
        }
    }

    private void registerModelMappings(DefModel modelDefinition) {
        for (DefEntityType entityTypeDef : modelDefinition.getEntityTypes()) {
            EntityType entityType = entityTypeDef.getEntityType(this.settings.getModelRegistry());
            StaMainTable table = this.getOrCreateMainTable(entityType, entityTypeDef.getTable());
            for (DefEntityProperty defEntityProperty : entityTypeDef.getEntityProperties()) {
                this.registerMappingForEntityProperties(defEntityProperty, table);
            }
            for (DefNavigationProperty defNavigationProperty : entityTypeDef.getNavigationProperties()) {
                this.registerMappingForNavProperties(defNavigationProperty, table);
            }
        }
    }

    private void registerMappingForEntityProperties(DefEntityProperty propertyDef, StaMainTable orCreateTable) {
        for (PropertyPersistenceMapper handler : propertyDef.getHandlers()) {
            this.maybeRegisterMapping(handler, orCreateTable);
        }
    }

    private void registerMappingForNavProperties(DefNavigationProperty propertyDef, StaMainTable orCreateTable) {
        for (PropertyPersistenceMapper handler : propertyDef.getHandlers()) {
            this.maybeRegisterMapping(handler, orCreateTable);
        }
    }

    private void maybeRegisterMapping(PropertyPersistenceMapper handler, StaMainTable orCreateTable) {
        if (handler instanceof FieldMapper) {
            ((FieldMapper)handler).registerMapping(this, orCreateTable);
        }
    }

    public Table<?> getDbTable(String tableName) {
        return this.getDbTable(DSL.name(tableName));
    }

    public Table<?> getDbTable(Name tableName) {
        Meta meta = this.dslContext.meta();
        List<Table<?>> tables = meta.getTables(tableName);
        if (tables.isEmpty()) {
            LOGGER.error("Table {} not found. Please initialise the database!", (Object)tableName);
            throw new IllegalArgumentException("Table " + tableName + " not found.");
        }
        if (tables.size() != 1) {
            LOGGER.error("Table name {} found {} times.", (Object)tableName, (Object)tables.size());
            throw new IllegalArgumentException("Failed to initialise: Table name " + tableName + " found " + tables.size() + " times.");
        }
        return tables.get(0);
    }

    private StaMainTable getOrCreateMainTable(EntityType entityType, String tableName) {
        if (entityType == null) {
            throw new IllegalArgumentException("Not implemented yet");
        }
        StaTableDynamic table = this.tableCollection.getTableForType(entityType);
        if (table == null) {
            LOGGER.info("  Registering StaTable {} ({})", (Object)tableName, (Object)entityType);
            StaTableDynamic newTable = new StaTableDynamic(DSL.name(tableName), entityType, this.getDataTypeFor(entityType.getPrimaryKey().getType().getName()));
            this.tableCollection.registerTable(entityType, newTable);
            table = newTable;
        }
        return table;
    }

    public StaLinkTableDynamic getOrCreateLinkTable(String tableName) {
        StaLinkTableDynamic table = this.tableCollection.getTableForName(tableName);
        if (table == null) {
            LOGGER.info("  Registering StaLinkTable {}", (Object)tableName);
            StaLinkTableDynamic newTable = new StaLinkTableDynamic(DSL.name(tableName));
            this.tableCollection.registerTable(newTable);
            table = newTable;
        }
        if (table instanceof StaLinkTableDynamic) {
            return table;
        }
        throw new IllegalStateException("Table already exists, but is not of type StaLinkTableDynamic.");
    }

    public DataType<?> getDataTypeFor(String type) {
        switch (type.toUpperCase()) {
            case "EDM.INT64": 
            case "LONG": {
                return SQLDataType.BIGINT;
            }
            case "EDM.STRING": 
            case "STRING": {
                return SQLDataType.VARCHAR;
            }
            case "EDM.GUID": 
            case "UUID": {
                return SQLDataType.UUID;
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + type);
    }

    public void generateLiquibaseVariables(Map<String, Object> target, String entity, String type) {
        target.put("id-" + entity, type);
        target.put("idTypeLong", "BIGINT");
        switch (type) {
            case "LONG": {
                target.put(ID_TYPE + entity, "BIGINT");
                break;
            }
            case "STRING": {
                target.put(ID_TYPE + entity, "VARCHAR(36)");
                target.put("defaultValueComputed-" + entity, "uuid_generate_v1mc()");
                break;
            }
            case "UUID": {
                target.put(ID_TYPE + entity, "uuid");
                target.put("defaultValueComputed-" + entity, "uuid_generate_v1mc()");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ID type: " + type);
            }
        }
    }

    @Override
    public String checkForUpgrades() {
        return this.checkForUpgrades(LIQUIBASE_CHANGELOG_FILENAME, Collections.emptyMap());
    }

    @Override
    public boolean doUpgrades(Writer out) throws UpgradeFailedException, IOException {
        return this.doUpgrades(LIQUIBASE_CHANGELOG_FILENAME, Collections.emptyMap(), out);
    }
}

