/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.ResultBuilder;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.DataSize;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.QueryState;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jooq.Cursor;
import org.jooq.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySetJooqCurser
implements EntitySet {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntitySetJooqCurser.class.getName());
    private final Query staQuery;
    private final QueryState queryState;
    private final Cursor<Record> results;
    private final DataSize size;
    private final ResultBuilder resultBuilder;
    private String nextLink;
    private long count = -1L;
    private int maxFetch;
    private final EntityType type;
    private NavigationPropertyMain.NavigationPropertyEntitySet navigationProperty;
    private CursorIterator iterator;

    public EntitySetJooqCurser(EntityType type, Cursor<Record> results, QueryState queryState, ResultBuilder resultBuilder) {
        this.type = type;
        this.staQuery = resultBuilder.getStaQuery();
        this.results = results;
        this.size = resultBuilder.getDataSize();
        this.queryState = queryState;
        this.resultBuilder = resultBuilder;
        this.maxFetch = this.staQuery.getTopOrDefault();
    }

    @Override
    public void add(Entity entity) {
        throw new UnsupportedOperationException("Not supported on this implementation.");
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("Not supported on this implementation.");
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public void setCount(long count) {
        this.count = count;
    }

    @Override
    public String getNextLink() {
        if (this.nextLink == null && this.results.hasNext() && this.maxFetch > 0) {
            this.generateNextLink();
        }
        return this.nextLink;
    }

    private void generateNextLink() {
        this.nextLink = UrlHelper.generateNextLink(this.resultBuilder.getPath(), this.staQuery, this.maxFetch);
    }

    @Override
    public void setNextLink(String nextLink) {
        this.nextLink = nextLink;
    }

    @Override
    public EntityType getEntityType() {
        return this.type;
    }

    @Override
    public NavigationPropertyMain.NavigationPropertyEntitySet getNavigationProperty() {
        return this.navigationProperty;
    }

    @Override
    public boolean isEmpty() {
        return !this.results.hasNext();
    }

    @Override
    public Iterator<Entity> iterator() {
        if (this.iterator == null) {
            this.iterator = new CursorIterator(this);
            return this.iterator;
        }
        throw new IllegalStateException("EntitySetJooqCurser can only be iterated once.");
    }

    private static class CursorIterator
    implements Iterator<Entity> {
        private final EntitySetJooqCurser parent;
        private int fetchedCount = 0;

        public CursorIterator(EntitySetJooqCurser parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasNext() {
            return this.parent.results.hasNext() && this.parent.maxFetch > this.fetchedCount;
        }

        @Override
        public Entity next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Cursor is closed or empty.");
            }
            ++this.fetchedCount;
            Entity entity = this.fetchNext();
            if (this.parent.size.isExceeded()) {
                LOGGER.debug("Size limit reached: {} > {}.", (Object)this.parent.size.getDataSize(), (Object)this.parent.size.getMaxSize());
                this.parent.maxFetch = this.fetchedCount;
                this.generateNextAndClose(entity);
            } else if (this.fetchedCount >= this.parent.maxFetch) {
                this.generateNextAndClose(entity);
            }
            entity.setQuery(this.parent.staQuery);
            this.parent.resultBuilder.expandEntity(entity, this.parent.staQuery);
            return entity;
        }

        private Entity fetchNext() {
            Record tuple = this.parent.results.fetchNext();
            return this.parent.queryState.entityFromQuery(tuple, this.parent.size);
        }

        private void generateNextLink(Entity last, Entity next) {
            this.parent.nextLink = UrlHelper.generateNextLink(this.parent.resultBuilder.getPath(), this.parent.staQuery, this.parent.maxFetch, last, next);
        }

        private void generateNextAndClose(Entity entity) {
            if (this.parent.results.hasNext()) {
                Entity next = this.fetchNext();
                this.generateNextLink(entity, next);
            }
            this.parent.results.close();
        }
    }
}

