/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence;

import com.github.fge.jsonpatch.JsonPatch;
import de.fraunhofer.iosb.ilt.frostserver.messagebus.MessageBus;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityChangedMessage;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.NoSuchEntityException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPersistenceManager
implements PersistenceManager {
    private final List<EntityChangedMessage> changedEntities = new ArrayList<EntityChangedMessage>();

    protected AbstractPersistenceManager() {
    }

    @Override
    public List<EntityChangedMessage> getEntityChangedMessages() {
        return this.changedEntities;
    }

    private Entity fetchEntity(EntityType entityType, Id id2) {
        return this.get(entityType, id2);
    }

    @Override
    public boolean insert(Entity entity) throws NoSuchEntityException, IncompleteEntityException {
        boolean result = this.doInsert(entity);
        if (result) {
            Entity newEntity = this.fetchEntity(entity.getEntityType(), entity.getId());
            newEntity.setQuery(this.getCoreSettings().getModelRegistry().getMessageQueryGenerator().getQueryFor(entity.getEntityType()));
            this.changedEntities.add(new EntityChangedMessage().setEventType(EntityChangedMessage.Type.CREATE).setEntity(newEntity));
        }
        return result;
    }

    public abstract boolean doInsert(Entity var1) throws NoSuchEntityException, IncompleteEntityException;

    @Override
    public boolean delete(PathElementEntity pathElement) throws NoSuchEntityException {
        Entity entity = this.getEntityByEntityPath(pathElement);
        boolean result = this.doDelete(pathElement);
        if (result) {
            entity.setQuery(this.getCoreSettings().getModelRegistry().getMessageQueryGenerator().getQueryFor(entity.getEntityType()));
            this.changedEntities.add(new EntityChangedMessage().setEventType(EntityChangedMessage.Type.DELETE).setEntity(entity));
        }
        return result;
    }

    @Override
    public void delete(ResourcePath path, Query query) throws NoSuchEntityException {
        this.doDelete(path, query);
    }

    private Entity getEntityByEntityPath(PathElementEntity pathElement) {
        ResourcePath path = new ResourcePath();
        path.addPathElement(new PathElementEntitySet(pathElement.getEntityType()), false, false);
        pathElement.setParent(path.getLastElement());
        path.addPathElement(pathElement, true, true);
        return (Entity)this.get(path, null);
    }

    public abstract boolean doDelete(PathElementEntity var1) throws NoSuchEntityException;

    public abstract void doDelete(ResourcePath var1, Query var2);

    @Override
    public boolean update(PathElementEntity pathElement, Entity entity) throws NoSuchEntityException, IncompleteEntityException {
        EntityChangedMessage result = this.doUpdate(pathElement, entity);
        if (result != null) {
            result.setEventType(EntityChangedMessage.Type.UPDATE);
            EntityType entityType = entity.getEntityType();
            Entity newEntity = this.fetchEntity(entityType, entity.getId());
            newEntity.setQuery(this.getCoreSettings().getModelRegistry().getMessageQueryGenerator().getQueryFor(entityType));
            result.setEntity(newEntity);
            this.changedEntities.add(result);
        }
        return result != null;
    }

    public abstract EntityChangedMessage doUpdate(PathElementEntity var1, Entity var2) throws NoSuchEntityException, IncompleteEntityException;

    @Override
    public boolean update(PathElementEntity pathElement, JsonPatch patch) throws NoSuchEntityException, IncompleteEntityException {
        EntityChangedMessage result = this.doUpdate(pathElement, patch);
        if (result != null) {
            result.setEventType(EntityChangedMessage.Type.UPDATE);
            Entity entity = result.getEntity();
            EntityType entityType = entity.getEntityType();
            Entity newEntity = this.fetchEntity(entityType, entity.getId());
            newEntity.setQuery(this.getCoreSettings().getModelRegistry().getMessageQueryGenerator().getQueryFor(entityType));
            result.setEntity(newEntity);
            this.changedEntities.add(result);
        }
        return result != null;
    }

    public abstract EntityChangedMessage doUpdate(PathElementEntity var1, JsonPatch var2) throws NoSuchEntityException, IncompleteEntityException;

    private void fireEntityChangeEvents() {
        MessageBus messageBus = this.getCoreSettings().getMessageBus();
        this.changedEntities.forEach(messageBus::sendMessage);
        this.clearEntityChangedEvents();
    }

    private void clearEntityChangedEvents() {
        this.changedEntities.clear();
    }

    @Override
    public void commit() {
        if (this.doCommit()) {
            this.fireEntityChangeEvents();
        }
    }

    protected abstract boolean doCommit();

    @Override
    public void rollback() {
        if (this.doRollback()) {
            this.clearEntityChangedEvents();
        }
    }

    protected abstract boolean doRollback();

    @Override
    public void close() {
        if (this.doClose()) {
            this.clearEntityChangedEvents();
        }
    }

    protected abstract boolean doClose();
}

