/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.parser.query;

import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTBool;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTFilteredPath;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTFilteredPaths;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTFormat;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTMetadata;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTOption;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTOptions;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTOrderBy;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTOrderBys;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTPathElement;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTPlainPath;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTPlainPaths;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTStart;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTValueNode;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.AbstractParserVisitor;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ExpressionParser;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.Node;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ParseException;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.Parser;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.SimpleNode;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.TokenMgrError;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.query.Expand;
import de.fraunhofer.iosb.ilt.frostserver.query.Metadata;
import de.fraunhofer.iosb.ilt.frostserver.query.OrderBy;
import de.fraunhofer.iosb.ilt.frostserver.query.PropertyPlaceholder;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.QueryDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParser
extends AbstractParserVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryParser.class);
    private static final String OP_TOP = "top";
    private static final String OP_SKIP = "skip";
    private static final String OP_COUNT = "count";
    private static final String OP_SELECT = "select";
    private static final String OP_SELECT_DISTINCT = "selectdistinct";
    private static final String OP_EXPAND = "expand";
    private static final String OP_FILTER = "filter";
    private static final String OP_SKIPFILTER = "skipfilter";
    private static final String OP_FORMAT = "resultformat";
    private static final String OP_METADATA = "resultmetadata";
    private static final String OP_ORDER_BY = "orderby";
    private final QueryDefaults queryDefaults;
    private final ModelRegistry modelRegistry;
    private final ExpressionParser expressionParser;
    private final ResourcePath path;

    public QueryParser(QueryDefaults queryDefaults, ModelRegistry modelRegistry, ResourcePath path) {
        this.queryDefaults = queryDefaults;
        this.modelRegistry = modelRegistry;
        this.expressionParser = new ExpressionParser();
        this.path = path;
    }

    public static Query parseQuery(String query, CoreSettings settings, ResourcePath path) {
        return QueryParser.parseQuery(query, StringHelper.UTF8, settings.getQueryDefaults(), settings.getModelRegistry(), path);
    }

    public static Query parseQuery(String query, QueryDefaults queryDefaults, ModelRegistry modelRegistry, ResourcePath path) {
        return QueryParser.parseQuery(query, StringHelper.UTF8, queryDefaults, modelRegistry, path);
    }

    public static Query parseQuery(String query, Charset encoding, QueryDefaults queryDefaults, ModelRegistry modelRegistry, ResourcePath path) {
        if (query == null || query.isEmpty()) {
            return new Query(modelRegistry, queryDefaults, path);
        }
        ByteArrayInputStream is2 = new ByteArrayInputStream(query.getBytes(encoding));
        Parser t2 = new Parser(is2, StringHelper.UTF8.name());
        try {
            ASTStart n2 = t2.Start();
            QueryParser v2 = new QueryParser(queryDefaults, modelRegistry, path);
            return v2.visit(n2, null);
        }
        catch (ParseException | TokenMgrError | IllegalArgumentException ex2) {
            LOGGER.error("Exception parsing: {}", (Object)StringHelper.cleanForLogging(query));
            throw new IllegalArgumentException("Query is not valid: " + ex2.getMessage(), ex2);
        }
    }

    @Override
    public Query visit(ASTStart node, Object data) {
        if (node.jjtGetNumChildren() != 1) {
            throw new IllegalArgumentException("query start node must have exactly one child of type Options");
        }
        ASTOptions options = QueryParser.getChildOfType(node, 0, ASTOptions.class);
        return this.visit(options, data);
    }

    @Override
    public Query visit(ASTOptions node, Object data) {
        Query result = new Query(this.modelRegistry, this.queryDefaults, this.path);
        node.childrenAccept(this, result);
        return result;
    }

    @Override
    public Object visit(ASTOption node, Object data) {
        String operator;
        if (node.jjtGetNumChildren() != 1) {
            throw new IllegalArgumentException("Query options must have exactly one child node.");
        }
        Query query = (Query)data;
        switch (operator = node.getType().toLowerCase().trim()) {
            case "top": {
                this.handleTop(node, query);
                break;
            }
            case "skip": {
                this.handleSkip(node, query);
                break;
            }
            case "count": {
                this.handleCount(node, query);
                break;
            }
            case "selectdistinct": {
                query.setSelectDistinct(true);
                this.handleSelect(node, query);
                break;
            }
            case "select": {
                this.handleSelect(node, query);
                break;
            }
            case "expand": {
                this.handleExpand(node, query, data);
                break;
            }
            case "filter": {
                query.setFilter(this.expressionParser.parseExpression(node.jjtGetChild(0)));
                break;
            }
            case "skipfilter": {
                query.setSkipFilter(this.expressionParser.parseExpression(node.jjtGetChild(0)));
                break;
            }
            case "resultformat": {
                this.handleFormat(node, query);
                break;
            }
            case "resultmetadata": {
                this.handleMetadata(node, query);
                break;
            }
            case "orderby": {
                this.handleOrderBy(node, query, data);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknow query option '" + operator + "'");
            }
        }
        return data;
    }

    private void handleOrderBy(ASTOption node, Query query, Object data) {
        ASTOrderBys child = QueryParser.getChildOfType(node, 0, ASTOrderBys.class);
        query.setOrderBy((List<OrderBy>)this.visit(child, data));
    }

    private void handleFormat(ASTOption node, Query query) {
        ASTFormat child = QueryParser.getChildOfType(node, 0, ASTFormat.class);
        query.setFormat(child.getValue());
    }

    private void handleMetadata(ASTOption node, Query query) {
        ASTMetadata child = QueryParser.getChildOfType(node, 0, ASTMetadata.class);
        query.setMetadata(Metadata.lookup(child.getValue()));
    }

    private void handleExpand(ASTOption node, Query query, Object data) {
        ASTFilteredPaths child = QueryParser.getChildOfType(node, 0, ASTFilteredPaths.class);
        query.setExpand((List<Expand>)this.visit(child, data));
    }

    private void handleSelect(ASTOption node, Query query) {
        ASTPlainPaths child = QueryParser.getChildOfType(node, 0, ASTPlainPaths.class);
        query.addSelect(this.visit(child, query));
    }

    private void handleCount(ASTOption node, Query query) {
        ASTBool child = QueryParser.getChildOfType(node, 0, ASTBool.class);
        query.setCount(child.getValue());
    }

    private void handleSkip(ASTOption node, Query query) {
        ASTValueNode child = QueryParser.getChildOfType(node, 0, ASTValueNode.class);
        query.setSkip(Math.toIntExact((Long)child.jjtGetValue()));
    }

    private void handleTop(ASTOption node, Query query) {
        ASTValueNode child = QueryParser.getChildOfType(node, 0, ASTValueNode.class);
        int top = Math.toIntExact((Long)child.jjtGetValue());
        query.setTop(top);
    }

    @Override
    public List<Expand> visit(ASTFilteredPaths node, Object data) {
        ArrayList<Expand> result = new ArrayList<Expand>();
        for (int i2 = 0; i2 < node.jjtGetNumChildren(); ++i2) {
            ASTFilteredPath childNode = QueryParser.getChildOfType(node, i2, ASTFilteredPath.class);
            result.add(this.visit(childNode, data));
        }
        return result;
    }

    @Override
    public Expand visit(ASTFilteredPath node, Object data) {
        Expand resultExpand = new Expand(this.modelRegistry);
        this.handleChild(node, 0, resultExpand, data);
        return resultExpand;
    }

    private void handleChild(ASTFilteredPath node, int start, Expand currentExpand, Object data) {
        int idx = start;
        ASTPathElement childNode = QueryParser.getChildOfType(node, idx, ASTPathElement.class);
        String name = childNode.getName();
        currentExpand.addToRawPath(name);
        int numChildren = node.jjtGetNumChildren();
        while (++idx < numChildren) {
            childNode = QueryParser.getChildOfType(node, idx, ASTPathElement.class);
            currentExpand.addToRawPath(childNode.getName());
        }
        if (childNode.jjtGetNumChildren() > 1) {
            throw new IllegalArgumentException("ASTFilteredPath can at most have one child");
        }
        if (childNode.jjtGetNumChildren() == 1) {
            if (currentExpand.hasSubQuery()) {
                throw new IllegalArgumentException("there is only one subquery allowed per expand path");
            }
            ASTOptions subChildNode = QueryParser.getChildOfType(childNode, 0, ASTOptions.class);
            currentExpand.setSubQuery(this.visit(subChildNode, data));
        }
    }

    public List<PropertyPlaceholder> visit(ASTPlainPaths node, Query data) {
        ArrayList<PropertyPlaceholder> result = new ArrayList<PropertyPlaceholder>();
        for (int i2 = 0; i2 < node.jjtGetNumChildren(); ++i2) {
            ASTPlainPath child = QueryParser.getChildOfType(node, i2, ASTPlainPath.class);
            result.add(this.visit(child, (Object)data));
        }
        return result;
    }

    @Override
    public PropertyPlaceholder visit(ASTPlainPath node, Object data) {
        int childCount = node.jjtGetNumChildren();
        if (childCount == 1) {
            ASTPathElement child = QueryParser.getChildOfType(node, 0, ASTPathElement.class);
            return this.visit(child, data);
        }
        ASTPathElement child = QueryParser.getChildOfType(node, 0, ASTPathElement.class);
        PropertyPlaceholder property = new PropertyPlaceholder(StringHelper.urlDecode(child.getName()));
        for (int idx = 1; idx < childCount; ++idx) {
            child = QueryParser.getChildOfType(node, idx, ASTPathElement.class);
            property.addToSubPath(child.getName());
        }
        return property;
    }

    @Override
    public PropertyPlaceholder visit(ASTPathElement node, Object data) {
        if (node.getIdentifier() != null && !node.getIdentifier().isEmpty()) {
            throw new IllegalArgumentException("no identified paths are allowed inside select");
        }
        return new PropertyPlaceholder(node.getName());
    }

    @Override
    public List<OrderBy> visit(ASTOrderBys node, Object data) {
        ArrayList<OrderBy> result = new ArrayList<OrderBy>();
        for (int i2 = 0; i2 < node.jjtGetNumChildren(); ++i2) {
            ASTOrderBy child = QueryParser.getChildOfType(node, i2, ASTOrderBy.class);
            result.add(this.visit(child, data));
        }
        return result;
    }

    @Override
    public OrderBy visit(ASTOrderBy node, Object data) {
        if (node.jjtGetNumChildren() != 1) {
            throw new IllegalArgumentException("ASTOrderBy node must have exactly one child");
        }
        return new OrderBy(this.expressionParser.parseExpression(node.jjtGetChild(0)), node.isAscending() ? OrderBy.OrderType.ASCENDING : OrderBy.OrderType.DESCENDING);
    }

    private static <T extends Node> T getChildOfType(SimpleNode parent, int index, Class<T> expectedType) {
        Node childNode = parent.jjtGetChild(index);
        if (!expectedType.isAssignableFrom(childNode.getClass())) {
            throw new IllegalArgumentException(parent.getClass().getName() + " expected to have child of type " + expectedType.getName());
        }
        return (T)childNode;
    }
}

