/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription;

import de.fraunhofer.iosb.ilt.frostserver.mqtt.MqttManager;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.EntitySetSubscription;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.EntitySubscription;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.PropertySubscription;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.Subscription;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.PathParser;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.UnknownVersionException;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionFactory.class);
    private static final String URI_PATH_SEP = "/";
    private final CoreSettings settings;

    private static String getPathFromTopic(String topic) {
        Object pathString;
        Object object = pathString = topic.contains("?") ? topic.substring(0, topic.indexOf(63)) : topic;
        if (!((String)pathString).startsWith(URI_PATH_SEP)) {
            pathString = URI_PATH_SEP + (String)pathString;
        }
        return pathString;
    }

    public static String getQueryFromTopic(String topic) {
        return topic.contains("?") ? topic.substring(topic.indexOf(63) + 1) : "";
    }

    public SubscriptionFactory(CoreSettings settings) {
        this.settings = settings;
    }

    public Subscription get(String topic) {
        Version version;
        String errorMsg = "Subscription to topic '" + topic + "' is invalid. Reason: ";
        if (topic == null || topic.isEmpty()) {
            throw new IllegalArgumentException(errorMsg + "topic must be non-empty.");
        }
        if (topic.startsWith(URI_PATH_SEP)) {
            throw new IllegalArgumentException(errorMsg + "topic must not start with '/'.");
        }
        try {
            version = MqttManager.getVersionFromTopic(this.settings, topic);
        }
        catch (UnknownVersionException ex2) {
            throw new IllegalArgumentException(errorMsg + "topic must start with a version number.");
        }
        String internalTopic = topic.substring(version.urlPart.length() + 1);
        ResourcePath path = this.parsePath(this.settings.getQueryDefaults().getServiceRootUrl(), version, SubscriptionFactory.getPathFromTopic(internalTopic));
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException(errorMsg + "invalid path.");
        }
        path.compress();
        int size = path.size();
        if (path.getLastElement() instanceof PathElementEntitySet) {
            return new EntitySetSubscription(this.settings, topic, path);
        }
        if (path.getLastElement() instanceof PathElementEntity) {
            return new EntitySubscription(this.settings, topic, path);
        }
        if (size >= 2 && path.get(size - 2) instanceof PathElementEntity && path.get(size - 1) instanceof PathElementProperty) {
            return new PropertySubscription(topic, path, this.settings);
        }
        throw new IllegalArgumentException(errorMsg + "topic does not match any allowed pattern (RESOURCE_PATH/COLLECTION_NAME, RESOURCE_PATH_TO_AN_ENTITY, RESOURCE_PATH_TO_AN_ENTITY/PROPERTY_NAME, RESOURCE_PATH/COLLECTION_NAME?$select=PROPERTY_1,PROPERTY_2,\u2026)");
    }

    private ResourcePath parsePath(String serviceRootUrl, Version version, String topic) {
        ResourcePath result = null;
        try {
            String pathString = URLDecoder.decode(topic, StringHelper.UTF8.name());
            result = PathParser.parsePath(this.settings.getModelRegistry(), serviceRootUrl, version, pathString);
        }
        catch (UnsupportedEncodingException ex2) {
            LOGGER.error("Encoding not supported.", ex2);
        }
        catch (NumberFormatException e2) {
            LOGGER.error("Not a valid id.");
        }
        catch (IllegalStateException e3) {
            LOGGER.error("Not a valid path: {}", (Object)e3.getMessage());
        }
        return result;
    }
}

