/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.Subscription;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.QueryDefaults;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Expression;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Path;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.IntegerConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.StringConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.comparison.Equal;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public abstract class AbstractSubscription
implements Subscription {
    protected final String topic;
    protected EntityType entityType;
    private Expression matchExpression = null;
    private Query query;
    private Predicate<? super Entity> matcher;
    private NavigationPropertyMain parentRelation;
    private Id parentId;
    protected ResourcePath path;
    protected CoreSettings settings;
    protected QueryDefaults queryDefaults;
    protected ModelRegistry modelRegistry;

    protected AbstractSubscription(String topic, ResourcePath path, CoreSettings settings) {
        this.topic = topic;
        this.path = path;
        this.settings = settings;
        this.queryDefaults = settings.getQueryDefaults().setAlwaysOrder(false);
        this.modelRegistry = settings.getModelRegistry();
    }

    @Override
    public boolean matches(PersistenceManager persistenceManager, Entity newEntity, Set<Property> fields2) {
        if (!newEntity.getEntityType().equals(this.entityType)) {
            return false;
        }
        if (this.matcher != null && !this.matcher.test(newEntity)) {
            return false;
        }
        if (this.matchExpression != null) {
            Object result = persistenceManager.get(newEntity.getPath(), this.query);
            return result != null;
        }
        return true;
    }

    protected void generateFilter(int pathElementOffset) {
        EntityType lastType = this.getEntityType();
        ArrayList<Property> properties = new ArrayList<Property>();
        boolean direct = true;
        for (int i2 = this.path.size() - 1 - pathElementOffset; i2 >= 0; --i2) {
            NavigationPropertyMain navProp;
            PathElement element = this.path.get(i2);
            if (element instanceof PathElementEntitySet) {
                PathElementEntitySet pees = (PathElementEntitySet)element;
                navProp = lastType.getNavigationProperty(pees.getEntityType());
                properties.add(navProp);
                lastType = pees.getEntityType();
                direct = false;
                continue;
            }
            if (!(element instanceof PathElementEntity)) continue;
            PathElementEntity epe = (PathElementEntity)element;
            navProp = lastType.getNavigationProperty(epe.getEntityType());
            Id id2 = epe.getId();
            if (direct && navProp != null && !navProp.isEntitySet() && id2 != null) {
                this.createMatcher(navProp, id2);
                assert (i2 <= 1);
                return;
            }
            properties.add(navProp);
            lastType = epe.getEntityType();
            if (id2 == null) continue;
            this.createMatchExpression(properties, epe);
            assert (i2 <= 1);
            return;
        }
    }

    private void createMatcher(NavigationPropertyMain navProp, Id id2) {
        this.parentRelation = navProp;
        this.parentId = id2;
        this.matcher = t2 -> {
            Entity parent = (Entity)t2.getProperty(navProp);
            if (parent == null) {
                return false;
            }
            return id2.equals(parent.getId());
        };
    }

    private void createMatchExpression(List<Property> properties, PathElementEntity epe) {
        properties.add(this.entityType.getPrimaryKey());
        String epeId = epe.getId().getUrl();
        this.matchExpression = epeId.startsWith("'") ? new Equal(new Path(properties), new StringConstant(epeId.substring(1, epeId.length() - 1))) : new Equal(new Path(properties), new IntegerConstant(epeId));
        this.query = new Query(this.modelRegistry, this.queryDefaults, this.path);
        this.query.setFilter(this.matchExpression);
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String formatMessage(Entity entity) throws IOException {
        return this.doFormatMessage(entity);
    }

    @Override
    public NavigationPropertyMain getParentRelation() {
        return this.parentRelation;
    }

    @Override
    public Id getParentId() {
        return this.parentId;
    }

    public abstract String doFormatMessage(Entity var1) throws IOException;

    public int hashCode() {
        return Objects.hash(this.topic, this.entityType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSubscription other = (AbstractSubscription)obj;
        if (!Objects.equals(this.topic, other.topic)) {
            return false;
        }
        return this.entityType == other.entityType;
    }
}

