/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.mqtt;

import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.Subscription;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubscriptionSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionSet.class.getName());
    private final Map<Subscription, AtomicInteger> subscriptions = new ConcurrentHashMap<Subscription, AtomicInteger>();
    private final AtomicInteger topicCount;

    public SubscriptionSet(AtomicInteger topicCount) {
        this.topicCount = topicCount;
    }

    public Map<Subscription, AtomicInteger> getSubscriptions() {
        return this.subscriptions;
    }

    public void addSubscription(Subscription subscription) {
        AtomicInteger clientCount = this.subscriptions.get(subscription);
        if (clientCount == null) {
            clientCount = new AtomicInteger(1);
            this.subscriptions.put(subscription, clientCount);
            this.topicCount.incrementAndGet();
            LOGGER.debug("Created new subscription for topic {}.", (Object)subscription.getTopic());
        } else {
            int newCount = clientCount.incrementAndGet();
            LOGGER.debug("Now {} subscriptions for topic {}.", (Object)newCount, (Object)subscription.getTopic());
        }
    }

    public void removeSubscription(Subscription subscription) {
        AtomicInteger clientCount = this.subscriptions.get(subscription);
        if (clientCount == null) {
            return;
        }
        int newCount = clientCount.decrementAndGet();
        LOGGER.debug("Now {} subscriptions for topic {}.", (Object)newCount, (Object)subscription.getTopic());
        if (newCount <= 0) {
            this.subscriptions.remove(subscription);
            this.topicCount.decrementAndGet();
            LOGGER.debug("Removed last subscription for topic {}.", (Object)subscription.getTopic());
        }
    }
}

