/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.ext;

import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeObject;
import de.fraunhofer.iosb.ilt.frostserver.property.ComplexValue;
import java.util.Objects;
import net.time4j.Moment;

public class TimeValue
implements TimeObject,
ComplexValue {
    private final TimeInstant instant;
    private final TimeInterval interval;

    public TimeValue(TimeInstant timeInstant) {
        this.instant = timeInstant;
        this.interval = null;
    }

    public TimeValue(TimeInterval timeInterval) {
        this.instant = null;
        this.interval = timeInterval;
    }

    public static TimeValue create(Moment start, Moment end) {
        return new TimeValue(TimeInterval.create(start, end));
    }

    public boolean isInstant() {
        return this.instant != null;
    }

    public TimeInstant getInstant() {
        return this.instant;
    }

    public boolean isInterval() {
        return this.interval != null;
    }

    public TimeInterval getInterval() {
        return this.interval;
    }

    @Override
    public String asISO8601() {
        return this.instant == null ? this.interval.asISO8601() : this.instant.asISO8601();
    }

    @Override
    public boolean isEmpty() {
        if (this.instant != null) {
            return this.instant.isEmpty();
        }
        if (this.interval != null) {
            return this.interval.isEmpty();
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeValue other = (TimeValue)obj;
        if (!Objects.equals(this.instant, other.instant)) {
            return false;
        }
        return Objects.equals(this.interval, other.interval);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.instant);
        hash = 67 * hash + Objects.hashCode(this.interval);
        return hash;
    }

    @Override
    public Object get(String name) {
        if (this.isInterval()) {
            return this.interval.get(name);
        }
        return this.instant;
    }
}

