/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.ItemInteger;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.RootSchema;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.SchemaItem;
import de.fraunhofer.iosb.ilt.configurable.annotations.AnnotationHelper;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDefault;
import de.fraunhofer.iosb.ilt.configurable.editor.fx.FactoryIntFx;
import de.fraunhofer.iosb.ilt.configurable.editor.swing.FactoryIntSwing;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EditorInt
extends EditorDefault<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditorInt.class.getName());
    private int min;
    private int max;
    private int step;
    private Integer dflt;
    private Integer value;
    public Set<String> profilesEdit = AnnotationHelper.csvToReadOnlySet("");
    private String profile = "default";
    private FactoryIntSwing factorySwing;
    private FactoryIntFx factoryFx;

    public EditorInt() {
    }

    public EditorInt(int min2, int max, int step, int dflt, String label, String description) {
        this.dflt = dflt;
        this.value = dflt;
        this.min = min2;
        this.max = max;
        this.step = step;
        this.setLabel(label);
        this.setDescription(description);
    }

    @Override
    public void initFor(Field field) {
        EdOptsInt annotation = field.getAnnotation(EdOptsInt.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Field must have an EdIntOpts annotation to use this editor: " + field.getName());
        }
        this.min = annotation.min();
        this.max = annotation.max();
        this.step = annotation.step();
        boolean isPrimitive = field.getType().isPrimitive();
        boolean dfltIsNull = annotation.dfltIsNull();
        if (dfltIsNull) {
            if (isPrimitive) {
                LOGGER.error("Flag dfltIsNull set to true on a primitive field: {}", (Object)field);
                this.dflt = 0;
            }
        } else {
            this.dflt = annotation.dflt();
        }
        this.value = this.dflt;
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(annotation.profilesEdit());
    }

    @Override
    public void setConfig(JsonElement config) {
        this.value = config != null && config.isJsonPrimitive() && config.getAsJsonPrimitive().isNumber() ? Integer.valueOf(config.getAsInt()) : this.dflt;
        this.fillComponent();
    }

    @Override
    public JsonElement getConfig() {
        Integer val = this.getValue();
        if (val == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(val);
    }

    @Override
    public SchemaItem getJsonSchema(RootSchema rootSchema) {
        ItemInteger item = (ItemInteger)((ItemInteger)((ItemInteger)new ItemInteger().setDeflt(this.dflt)).setTitle(this.getLabel())).setDescription(this.getDescription());
        if (this.min > Integer.MIN_VALUE) {
            item.setMinimum(Long.valueOf(this.min));
        }
        if (this.max < Integer.MAX_VALUE) {
            item.setMaximum(Long.valueOf(this.max));
        }
        if (rootSchema == null) {
            return new RootSchema(item);
        }
        return item;
    }

    @Override
    public GuiFactorySwing getGuiFactorySwing() {
        if (this.factoryFx != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factorySwing == null) {
            this.factorySwing = new FactoryIntSwing(this);
        }
        return this.factorySwing;
    }

    @Override
    public GuiFactoryFx getGuiFactoryFx() {
        if (this.factorySwing != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factoryFx == null) {
            this.factoryFx = new FactoryIntFx(this);
        }
        return this.factoryFx;
    }

    private void fillComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.fillComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.fillComponent();
        }
    }

    private void readComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.readComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.readComponent();
        }
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public Integer getDflt() {
        return this.dflt;
    }

    public int getStep() {
        return this.step;
    }

    public Integer getRawValue() {
        return this.value;
    }

    public void setRawValue(int value) {
        this.value = value;
    }

    @Override
    public Integer getValue() {
        this.readComponent();
        if (this.value == null) {
            return null;
        }
        if (this.value > this.max) {
            this.value = this.max;
        }
        if (this.value < this.min) {
            this.value = this.min;
        }
        return this.value;
    }

    @Override
    public void setValue(Integer value) {
        this.value = value;
        this.fillComponent();
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile;
        this.fillComponent();
    }

    public void setProfilesEdit(String csv) {
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(csv);
    }

    @Override
    public boolean canEdit() {
        return this.profilesEdit.contains(this.profile);
    }

    @Override
    public boolean isDefault() {
        this.readComponent();
        return Objects.equals(this.dflt, this.value);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface EdOptsInt {
        public int min() default -2147483648;

        public int max() default 0x7FFFFFFF;

        public int step() default 1;

        public int dflt() default 0;

        public boolean dfltIsNull() default false;

        public String profilesEdit() default "";
    }
}

