/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate;

import com.vividsolutions.jts.triangulate.quadedge.QuadEdge;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeSubdivision;
import com.vividsolutions.jts.triangulate.quadedge.Vertex;
import java.util.Collection;

public class IncrementalDelaunayTriangulator {
    private QuadEdgeSubdivision subdiv;
    private boolean isUsingTolerance = false;

    public IncrementalDelaunayTriangulator(QuadEdgeSubdivision subdiv) {
        this.subdiv = subdiv;
        this.isUsingTolerance = subdiv.getTolerance() > 0.0;
    }

    public void insertSites(Collection vertices) {
        for (Vertex v2 : vertices) {
            this.insertSite(v2);
        }
    }

    public QuadEdge insertSite(Vertex v2) {
        QuadEdge e2 = this.subdiv.locate(v2);
        if (this.subdiv.isVertexOfEdge(e2, v2)) {
            return e2;
        }
        if (this.subdiv.isOnEdge(e2, v2.getCoordinate())) {
            e2 = e2.oPrev();
            this.subdiv.delete(e2.oNext());
        }
        QuadEdge base = this.subdiv.makeEdge(e2.orig(), v2);
        QuadEdge.splice(base, e2);
        QuadEdge startEdge = base;
        while ((e2 = (base = this.subdiv.connect(e2, base.sym())).oPrev()).lNext() != startEdge) {
        }
        while (true) {
            QuadEdge t2;
            if ((t2 = e2.oPrev()).dest().rightOf(e2) && v2.isInCircle(e2.orig(), t2.dest(), e2.dest())) {
                QuadEdge.swap(e2);
                e2 = e2.oPrev();
                continue;
            }
            if (e2.oNext() == startEdge) {
                return base;
            }
            e2 = e2.oNext().lPrev();
        }
    }
}

