/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.operation.overlay.MaximalEdgeRing;
import com.vividsolutions.jts.operation.overlay.OverlayNodeFactory;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConnectedInteriorTester {
    private GeometryFactory geometryFactory = new GeometryFactory();
    private GeometryGraph geomGraph;
    private Coordinate disconnectedRingcoord;

    public static Coordinate findDifferentPoint(Coordinate[] coord, Coordinate pt2) {
        for (int i2 = 0; i2 < coord.length; ++i2) {
            if (coord[i2].equals(pt2)) continue;
            return coord[i2];
        }
        return null;
    }

    public ConnectedInteriorTester(GeometryGraph geomGraph) {
        this.geomGraph = geomGraph;
    }

    public Coordinate getCoordinate() {
        return this.disconnectedRingcoord;
    }

    public boolean isInteriorsConnected() {
        ArrayList splitEdges = new ArrayList();
        this.geomGraph.computeSplitEdges(splitEdges);
        PlanarGraph graph = new PlanarGraph(new OverlayNodeFactory());
        graph.addEdges(splitEdges);
        this.setInteriorEdgesInResult(graph);
        graph.linkResultDirectedEdges();
        List edgeRings = this.buildEdgeRings(graph.getEdgeEnds());
        this.visitShellInteriors(this.geomGraph.getGeometry(), graph);
        return !this.hasUnvisitedShellEdge(edgeRings);
    }

    private void setInteriorEdgesInResult(PlanarGraph graph) {
        for (DirectedEdge de2 : graph.getEdgeEnds()) {
            if (de2.getLabel().getLocation(0, 2) != 0) continue;
            de2.setInResult(true);
        }
    }

    private List buildEdgeRings(Collection dirEdges) {
        ArrayList edgeRings = new ArrayList();
        for (DirectedEdge de2 : dirEdges) {
            if (!de2.isInResult() || de2.getEdgeRing() != null) continue;
            MaximalEdgeRing er2 = new MaximalEdgeRing(de2, this.geometryFactory);
            er2.linkDirectedEdgesForMinimalEdgeRings();
            List minEdgeRings = er2.buildMinimalRings();
            edgeRings.addAll(minEdgeRings);
        }
        return edgeRings;
    }

    private void visitShellInteriors(Geometry g2, PlanarGraph graph) {
        if (g2 instanceof Polygon) {
            Polygon p2 = (Polygon)g2;
            this.visitInteriorRing(p2.getExteriorRing(), graph);
        }
        if (g2 instanceof MultiPolygon) {
            MultiPolygon mp2 = (MultiPolygon)g2;
            for (int i2 = 0; i2 < mp2.getNumGeometries(); ++i2) {
                Polygon p3 = (Polygon)mp2.getGeometryN(i2);
                this.visitInteriorRing(p3.getExteriorRing(), graph);
            }
        }
    }

    private void visitInteriorRing(LineString ring, PlanarGraph graph) {
        Coordinate[] pts = ring.getCoordinates();
        Coordinate pt0 = pts[0];
        Coordinate pt1 = ConnectedInteriorTester.findDifferentPoint(pts, pt0);
        Edge e2 = graph.findEdgeInSameDirection(pt0, pt1);
        DirectedEdge de2 = (DirectedEdge)graph.findEdgeEnd(e2);
        DirectedEdge intDe = null;
        if (de2.getLabel().getLocation(0, 2) == 0) {
            intDe = de2;
        } else if (de2.getSym().getLabel().getLocation(0, 2) == 0) {
            intDe = de2.getSym();
        }
        Assert.isTrue(intDe != null, "unable to find dirEdge with Interior on RHS");
        this.visitLinkedDirectedEdges(intDe);
    }

    protected void visitLinkedDirectedEdges(DirectedEdge start) {
        DirectedEdge startDe = start;
        DirectedEdge de2 = start;
        do {
            Assert.isTrue(de2 != null, "found null Directed Edge");
            de2.setVisited(true);
        } while ((de2 = de2.getNext()) != startDe);
    }

    private boolean hasUnvisitedShellEdge(List edgeRings) {
        for (int i2 = 0; i2 < edgeRings.size(); ++i2) {
            List edges;
            DirectedEdge de2;
            EdgeRing er2 = (EdgeRing)edgeRings.get(i2);
            if (er2.isHole() || (de2 = (DirectedEdge)(edges = er2.getEdges()).get(0)).getLabel().getLocation(0, 2) != 0) continue;
            for (int j2 = 0; j2 < edges.size(); ++j2) {
                de2 = (DirectedEdge)edges.get(j2);
                if (de2.isVisited()) continue;
                this.disconnectedRingcoord = de2.getCoordinate();
                return true;
            }
        }
        return false;
    }
}

