/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay.snap;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.operation.overlay.snap.SnapTransformer;
import java.util.TreeSet;

public class GeometrySnapper {
    private static final double SNAP_PRECISION_FACTOR = 1.0E-9;
    private Geometry srcGeom;

    public static double computeOverlaySnapTolerance(Geometry g2) {
        double fixedSnapTol;
        double snapTolerance = GeometrySnapper.computeSizeBasedSnapTolerance(g2);
        PrecisionModel pm2 = g2.getPrecisionModel();
        if (pm2.getType() == PrecisionModel.FIXED && (fixedSnapTol = 1.0 / pm2.getScale() * 2.0 / 1.415) > snapTolerance) {
            snapTolerance = fixedSnapTol;
        }
        return snapTolerance;
    }

    public static double computeSizeBasedSnapTolerance(Geometry g2) {
        Envelope env = g2.getEnvelopeInternal();
        double minDimension = Math.min(env.getHeight(), env.getWidth());
        double snapTol = minDimension * 1.0E-9;
        return snapTol;
    }

    public static double computeOverlaySnapTolerance(Geometry g0, Geometry g1) {
        return Math.min(GeometrySnapper.computeOverlaySnapTolerance(g0), GeometrySnapper.computeOverlaySnapTolerance(g1));
    }

    public static Geometry[] snap(Geometry g0, Geometry g1, double snapTolerance) {
        Geometry[] snapGeom = new Geometry[2];
        GeometrySnapper snapper0 = new GeometrySnapper(g0);
        snapGeom[0] = snapper0.snapTo(g1, snapTolerance);
        GeometrySnapper snapper1 = new GeometrySnapper(g1);
        snapGeom[1] = snapper1.snapTo(snapGeom[0], snapTolerance);
        return snapGeom;
    }

    public static Geometry snapToSelf(Geometry g0, double snapTolerance, boolean cleanResult) {
        GeometrySnapper snapper0 = new GeometrySnapper(g0);
        return snapper0.snapToSelf(snapTolerance, cleanResult);
    }

    public GeometrySnapper(Geometry srcGeom) {
        this.srcGeom = srcGeom;
    }

    public Geometry snapTo(Geometry snapGeom, double snapTolerance) {
        Coordinate[] snapPts = this.extractTargetCoordinates(snapGeom);
        SnapTransformer snapTrans = new SnapTransformer(snapTolerance, snapPts);
        return snapTrans.transform(this.srcGeom);
    }

    public Geometry snapToSelf(double snapTolerance, boolean cleanResult) {
        Geometry snappedGeom;
        Coordinate[] snapPts = this.extractTargetCoordinates(this.srcGeom);
        SnapTransformer snapTrans = new SnapTransformer(snapTolerance, snapPts, true);
        Geometry result = snappedGeom = snapTrans.transform(this.srcGeom);
        if (cleanResult && result instanceof Polygonal) {
            result = snappedGeom.buffer(0.0);
        }
        return result;
    }

    public Coordinate[] extractTargetCoordinates(Geometry g2) {
        TreeSet<Coordinate> ptSet = new TreeSet<Coordinate>();
        Coordinate[] pts = g2.getCoordinates();
        for (int i2 = 0; i2 < pts.length; ++i2) {
            ptSet.add(pts[i2]);
        }
        return ptSet.toArray(new Coordinate[0]);
    }

    private double computeSnapTolerance(Coordinate[] ringPts) {
        double minSegLen = this.computeMinimumSegmentLength(ringPts);
        double snapTol = minSegLen / 10.0;
        return snapTol;
    }

    private double computeMinimumSegmentLength(Coordinate[] pts) {
        double minSegLen = Double.MAX_VALUE;
        for (int i2 = 0; i2 < pts.length - 1; ++i2) {
            double segLen = pts[i2].distance(pts[i2 + 1]);
            if (!(segLen < minSegLen)) continue;
            minSegLen = segLen;
        }
        return minSegLen;
    }
}

