/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer.validate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.buffer.validate.PointPairDistance;

public class DistanceToPointFinder {
    private static LineSegment tempSegment = new LineSegment();

    public static void computeDistance(Geometry geom, Coordinate pt2, PointPairDistance ptDist) {
        if (geom instanceof LineString) {
            DistanceToPointFinder.computeDistance((LineString)geom, pt2, ptDist);
        } else if (geom instanceof Polygon) {
            DistanceToPointFinder.computeDistance((Polygon)geom, pt2, ptDist);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc2 = (GeometryCollection)geom;
            for (int i2 = 0; i2 < gc2.getNumGeometries(); ++i2) {
                Geometry g2 = gc2.getGeometryN(i2);
                DistanceToPointFinder.computeDistance(g2, pt2, ptDist);
            }
        } else {
            ptDist.setMinimum(geom.getCoordinate(), pt2);
        }
    }

    public static void computeDistance(LineString line, Coordinate pt2, PointPairDistance ptDist) {
        Coordinate[] coords = line.getCoordinates();
        for (int i2 = 0; i2 < coords.length - 1; ++i2) {
            tempSegment.setCoordinates(coords[i2], coords[i2 + 1]);
            Coordinate closestPt = tempSegment.closestPoint(pt2);
            ptDist.setMinimum(closestPt, pt2);
        }
    }

    public static void computeDistance(LineSegment segment, Coordinate pt2, PointPairDistance ptDist) {
        Coordinate closestPt = segment.closestPoint(pt2);
        ptDist.setMinimum(closestPt, pt2);
    }

    public static void computeDistance(Polygon poly, Coordinate pt2, PointPairDistance ptDist) {
        DistanceToPointFinder.computeDistance(poly.getExteriorRing(), pt2, ptDist);
        for (int i2 = 0; i2 < poly.getNumInteriorRing(); ++i2) {
            DistanceToPointFinder.computeDistance(poly.getInteriorRingN(i2), pt2, ptDist);
        }
    }
}

