/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.math;

public class Matrix {
    private static void swapRows(double[][] m3, int i2, int j2) {
        if (i2 == j2) {
            return;
        }
        for (int col = 0; col < m3[0].length; ++col) {
            double temp = m3[i2][col];
            m3[i2][col] = m3[j2][col];
            m3[j2][col] = temp;
        }
    }

    private static void swapRows(double[] m3, int i2, int j2) {
        if (i2 == j2) {
            return;
        }
        double temp = m3[i2];
        m3[i2] = m3[j2];
        m3[j2] = temp;
    }

    public static double[] solve(double[][] a2, double[] b2) {
        int n2 = b2.length;
        if (a2.length != n2 || a2[0].length != n2) {
            throw new IllegalArgumentException("Matrix A is incorrectly sized");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int j2;
            int maxElementRow = i2;
            for (j2 = i2 + 1; j2 < n2; ++j2) {
                if (!(Math.abs(a2[j2][i2]) > Math.abs(a2[maxElementRow][i2]))) continue;
                maxElementRow = j2;
            }
            if (a2[maxElementRow][i2] == 0.0) {
                return null;
            }
            Matrix.swapRows(a2, i2, maxElementRow);
            Matrix.swapRows(b2, i2, maxElementRow);
            j2 = i2 + 1;
            while (j2 < n2) {
                double rowFactor = a2[j2][i2] / a2[i2][i2];
                for (int k2 = n2 - 1; k2 >= i2; --k2) {
                    double[] dArray = a2[j2];
                    int n3 = k2;
                    dArray[n3] = dArray[n3] - a2[i2][k2] * rowFactor;
                }
                int n4 = j2++;
                b2[n4] = b2[n4] - b2[i2] * rowFactor;
            }
        }
        double[] solution = new double[n2];
        for (int j3 = n2 - 1; j3 >= 0; --j3) {
            double t2 = 0.0;
            for (int k3 = j3 + 1; k3 < n2; ++k3) {
                t2 += a2[j3][k3] * solution[k3];
            }
            solution[j3] = (b2[j3] - t2) / a2[j3][j3];
        }
        return solution;
    }
}

