/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.math;

import java.io.Serializable;

public strictfp final class DD
implements Serializable,
Comparable,
Cloneable {
    public static final DD PI = new DD(Math.PI, 1.2246467991473532E-16);
    public static final DD TWO_PI = new DD(Math.PI * 2, 2.4492935982947064E-16);
    public static final DD PI_2 = new DD(1.5707963267948966, 6.123233995736766E-17);
    public static final DD E = new DD(Math.E, 1.4456468917292502E-16);
    public static final DD NaN = new DD(Double.NaN, Double.NaN);
    public static final double EPS = 1.23259516440783E-32;
    private static final double SPLIT = 1.34217729E8;
    private double hi = 0.0;
    private double lo = 0.0;
    private static final int MAX_PRINT_DIGITS = 32;
    private static final DD TEN = DD.valueOf(10.0);
    private static final DD ONE = DD.valueOf(1.0);
    private static final String SCI_NOT_EXPONENT_CHAR = "E";
    private static final String SCI_NOT_ZERO = "0.0E0";

    private static DD createNaN() {
        return new DD(Double.NaN, Double.NaN);
    }

    public static DD valueOf(String str) throws NumberFormatException {
        return DD.parse(str);
    }

    public static DD valueOf(double x2) {
        return new DD(x2);
    }

    public DD() {
        this.init(0.0);
    }

    public DD(double x2) {
        this.init(x2);
    }

    public DD(double hi2, double lo2) {
        this.init(hi2, lo2);
    }

    public DD(DD dd2) {
        this.init(dd2);
    }

    public DD(String str) throws NumberFormatException {
        this(DD.parse(str));
    }

    public static DD copy(DD dd2) {
        return new DD(dd2);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex2) {
            return null;
        }
    }

    private final void init(double x2) {
        this.hi = x2;
        this.lo = 0.0;
    }

    private final void init(double hi2, double lo2) {
        this.hi = hi2;
        this.lo = lo2;
    }

    private final void init(DD dd2) {
        this.hi = dd2.hi;
        this.lo = dd2.lo;
    }

    public final DD add(DD y2) {
        return DD.copy(this).selfAdd(y2);
    }

    public final DD add(double y2) {
        return DD.copy(this).selfAdd(y2);
    }

    public final DD selfAdd(DD y2) {
        return this.selfAdd(y2.hi, y2.lo);
    }

    public final DD selfAdd(double y2) {
        double S2 = this.hi + y2;
        double e2 = S2 - this.hi;
        double s2 = S2 - e2;
        s2 = y2 - e2 + (this.hi - s2);
        double f2 = s2 + this.lo;
        double H2 = S2 + f2;
        double h2 = f2 + (S2 - H2);
        this.hi = H2 + h2;
        this.lo = h2 + (H2 - this.hi);
        return this;
    }

    private final DD selfAdd(double yhi, double ylo) {
        double S2 = this.hi + yhi;
        double T2 = this.lo + ylo;
        double e2 = S2 - this.hi;
        double f2 = T2 - this.lo;
        double s2 = S2 - e2;
        double t2 = T2 - f2;
        s2 = yhi - e2 + (this.hi - s2);
        t2 = ylo - f2 + (this.lo - t2);
        e2 = s2 + T2;
        double H2 = S2 + e2;
        double h2 = e2 + (S2 - H2);
        e2 = t2 + h2;
        double zhi = H2 + e2;
        double zlo = e2 + (H2 - zhi);
        this.hi = zhi;
        this.lo = zlo;
        return this;
    }

    public final DD subtract(DD y2) {
        return this.add(y2.negate());
    }

    public final DD subtract(double y2) {
        return this.add(-y2);
    }

    public final DD selfSubtract(DD y2) {
        if (this.isNaN()) {
            return this;
        }
        return this.selfAdd(-y2.hi, -y2.lo);
    }

    public final DD selfSubtract(double y2) {
        if (this.isNaN()) {
            return this;
        }
        return this.selfAdd(-y2, 0.0);
    }

    public final DD negate() {
        if (this.isNaN()) {
            return this;
        }
        return new DD(-this.hi, -this.lo);
    }

    public final DD multiply(DD y2) {
        if (y2.isNaN()) {
            return DD.createNaN();
        }
        return DD.copy(this).selfMultiply(y2);
    }

    public final DD multiply(double y2) {
        if (Double.isNaN(y2)) {
            return DD.createNaN();
        }
        return DD.copy(this).selfMultiply(y2, 0.0);
    }

    public final DD selfMultiply(DD y2) {
        return this.selfMultiply(y2.hi, y2.lo);
    }

    public final DD selfMultiply(double y2) {
        return this.selfMultiply(y2, 0.0);
    }

    private final DD selfMultiply(double yhi, double ylo) {
        double C2 = 1.34217729E8 * this.hi;
        double hx2 = C2 - this.hi;
        double c2 = 1.34217729E8 * yhi;
        hx2 = C2 - hx2;
        double tx = this.hi - hx2;
        double hy2 = c2 - yhi;
        C2 = this.hi * yhi;
        hy2 = c2 - hy2;
        double ty = yhi - hy2;
        c2 = hx2 * hy2 - C2 + hx2 * ty + tx * hy2 + tx * ty + (this.hi * ylo + this.lo * yhi);
        double zhi = C2 + c2;
        hx2 = C2 - zhi;
        double zlo = c2 + hx2;
        this.hi = zhi;
        this.lo = zlo;
        return this;
    }

    public final DD divide(DD y2) {
        double C2 = this.hi / y2.hi;
        double c2 = 1.34217729E8 * C2;
        double hc2 = c2 - C2;
        double u2 = 1.34217729E8 * y2.hi;
        hc2 = c2 - hc2;
        double tc = C2 - hc2;
        double hy2 = u2 - y2.hi;
        double U2 = C2 * y2.hi;
        hy2 = u2 - hy2;
        double ty = y2.hi - hy2;
        u2 = hc2 * hy2 - U2 + hc2 * ty + tc * hy2 + tc * ty;
        c2 = (this.hi - U2 - u2 + this.lo - C2 * y2.lo) / y2.hi;
        double zhi = u2 = C2 + c2;
        double zlo = C2 - u2 + c2;
        return new DD(zhi, zlo);
    }

    public final DD divide(double y2) {
        if (Double.isNaN(y2)) {
            return DD.createNaN();
        }
        return DD.copy(this).selfDivide(y2, 0.0);
    }

    public final DD selfDivide(DD y2) {
        return this.selfDivide(y2.hi, y2.lo);
    }

    public final DD selfDivide(double y2) {
        return this.selfDivide(y2, 0.0);
    }

    private final DD selfDivide(double yhi, double ylo) {
        double C2 = this.hi / yhi;
        double c2 = 1.34217729E8 * C2;
        double hc2 = c2 - C2;
        double u2 = 1.34217729E8 * yhi;
        hc2 = c2 - hc2;
        double tc = C2 - hc2;
        double hy2 = u2 - yhi;
        double U2 = C2 * yhi;
        hy2 = u2 - hy2;
        double ty = yhi - hy2;
        u2 = hc2 * hy2 - U2 + hc2 * ty + tc * hy2 + tc * ty;
        c2 = (this.hi - U2 - u2 + this.lo - C2 * ylo) / yhi;
        this.hi = u2 = C2 + c2;
        this.lo = C2 - u2 + c2;
        return this;
    }

    public final DD reciprocal() {
        double C2 = 1.0 / this.hi;
        double c2 = 1.34217729E8 * C2;
        double hc2 = c2 - C2;
        double u2 = 1.34217729E8 * this.hi;
        hc2 = c2 - hc2;
        double tc = C2 - hc2;
        double hy2 = u2 - this.hi;
        double U2 = C2 * this.hi;
        hy2 = u2 - hy2;
        double ty = this.hi - hy2;
        u2 = hc2 * hy2 - U2 + hc2 * ty + tc * hy2 + tc * ty;
        c2 = (1.0 - U2 - u2 - C2 * this.lo) / this.hi;
        double zhi = C2 + c2;
        double zlo = C2 - zhi + c2;
        return new DD(zhi, zlo);
    }

    public DD floor() {
        if (this.isNaN()) {
            return NaN;
        }
        double fhi = Math.floor(this.hi);
        double flo = 0.0;
        if (fhi == this.hi) {
            flo = Math.floor(this.lo);
        }
        return new DD(fhi, flo);
    }

    public DD ceil() {
        if (this.isNaN()) {
            return NaN;
        }
        double fhi = Math.ceil(this.hi);
        double flo = 0.0;
        if (fhi == this.hi) {
            flo = Math.ceil(this.lo);
        }
        return new DD(fhi, flo);
    }

    public int signum() {
        if (this.hi > 0.0) {
            return 1;
        }
        if (this.hi < 0.0) {
            return -1;
        }
        if (this.lo > 0.0) {
            return 1;
        }
        if (this.lo < 0.0) {
            return -1;
        }
        return 0;
    }

    public DD rint() {
        if (this.isNaN()) {
            return this;
        }
        DD plus5 = this.add(0.5);
        return plus5.floor();
    }

    public DD trunc() {
        if (this.isNaN()) {
            return NaN;
        }
        if (this.isPositive()) {
            return this.floor();
        }
        return this.ceil();
    }

    public DD abs() {
        if (this.isNaN()) {
            return NaN;
        }
        if (this.isNegative()) {
            return this.negate();
        }
        return new DD(this);
    }

    public DD sqr() {
        return this.multiply(this);
    }

    public static DD sqr(double x2) {
        return DD.valueOf(x2).selfMultiply(x2);
    }

    public DD sqrt() {
        if (this.isZero()) {
            return DD.valueOf(0.0);
        }
        if (this.isNegative()) {
            return NaN;
        }
        double x2 = 1.0 / Math.sqrt(this.hi);
        double ax2 = this.hi * x2;
        DD axdd = DD.valueOf(ax2);
        DD diffSq = this.subtract(axdd.sqr());
        double d2 = diffSq.hi * (x2 * 0.5);
        return axdd.add(d2);
    }

    public static DD sqrt(double x2) {
        return DD.valueOf(x2).sqrt();
    }

    public DD pow(int exp) {
        if ((double)exp == 0.0) {
            return DD.valueOf(1.0);
        }
        DD r2 = new DD(this);
        DD s2 = DD.valueOf(1.0);
        int n2 = Math.abs(exp);
        if (n2 > 1) {
            while (n2 > 0) {
                if (n2 % 2 == 1) {
                    s2.selfMultiply(r2);
                }
                if ((n2 /= 2) <= 0) continue;
                r2 = r2.sqr();
            }
        } else {
            s2 = r2;
        }
        if (exp < 0) {
            return s2.reciprocal();
        }
        return s2;
    }

    public DD min(DD x2) {
        if (this.le(x2)) {
            return this;
        }
        return x2;
    }

    public DD max(DD x2) {
        if (this.ge(x2)) {
            return this;
        }
        return x2;
    }

    public double doubleValue() {
        return this.hi + this.lo;
    }

    public int intValue() {
        return (int)this.hi;
    }

    public boolean isZero() {
        return this.hi == 0.0 && this.lo == 0.0;
    }

    public boolean isNegative() {
        return this.hi < 0.0 || this.hi == 0.0 && this.lo < 0.0;
    }

    public boolean isPositive() {
        return this.hi > 0.0 || this.hi == 0.0 && this.lo > 0.0;
    }

    public boolean isNaN() {
        return Double.isNaN(this.hi);
    }

    public boolean equals(DD y2) {
        return this.hi == y2.hi && this.lo == y2.lo;
    }

    public boolean gt(DD y2) {
        return this.hi > y2.hi || this.hi == y2.hi && this.lo > y2.lo;
    }

    public boolean ge(DD y2) {
        return this.hi > y2.hi || this.hi == y2.hi && this.lo >= y2.lo;
    }

    public boolean lt(DD y2) {
        return this.hi < y2.hi || this.hi == y2.hi && this.lo < y2.lo;
    }

    public boolean le(DD y2) {
        return this.hi < y2.hi || this.hi == y2.hi && this.lo <= y2.lo;
    }

    public int compareTo(Object o2) {
        DD other = (DD)o2;
        if (this.hi < other.hi) {
            return -1;
        }
        if (this.hi > other.hi) {
            return 1;
        }
        if (this.lo < other.lo) {
            return -1;
        }
        if (this.lo > other.lo) {
            return 1;
        }
        return 0;
    }

    public String dump() {
        return "DD<" + this.hi + ", " + this.lo + ">";
    }

    public String toString() {
        int mag = DD.magnitude(this.hi);
        if (mag >= -3 && mag <= 20) {
            return this.toStandardNotation();
        }
        return this.toSciNotation();
    }

    public String toStandardNotation() {
        String specialStr = this.getSpecialNumberString();
        if (specialStr != null) {
            return specialStr;
        }
        int[] magnitude = new int[1];
        String sigDigits = this.extractSignificantDigits(true, magnitude);
        int decimalPointPos = magnitude[0] + 1;
        String num = sigDigits;
        if (sigDigits.charAt(0) == '.') {
            num = "0" + sigDigits;
        } else if (decimalPointPos < 0) {
            num = "0." + DD.stringOfChar('0', -decimalPointPos) + sigDigits;
        } else if (sigDigits.indexOf(46) == -1) {
            int numZeroes = decimalPointPos - sigDigits.length();
            String zeroes = DD.stringOfChar('0', numZeroes);
            num = sigDigits + zeroes + ".0";
        }
        if (this.isNegative()) {
            return "-" + num;
        }
        return num;
    }

    public String toSciNotation() {
        if (this.isZero()) {
            return SCI_NOT_ZERO;
        }
        String specialStr = this.getSpecialNumberString();
        if (specialStr != null) {
            return specialStr;
        }
        int[] magnitude = new int[1];
        String digits = this.extractSignificantDigits(false, magnitude);
        String expStr = SCI_NOT_EXPONENT_CHAR + magnitude[0];
        if (digits.charAt(0) == '0') {
            throw new IllegalStateException("Found leading zero: " + digits);
        }
        String trailingDigits = "";
        if (digits.length() > 1) {
            trailingDigits = digits.substring(1);
        }
        String digitsWithDecimal = digits.charAt(0) + "." + trailingDigits;
        if (this.isNegative()) {
            return "-" + digitsWithDecimal + expStr;
        }
        return digitsWithDecimal + expStr;
    }

    private String extractSignificantDigits(boolean insertDecimalPoint, int[] magnitude) {
        DD y2 = this.abs();
        int mag = DD.magnitude(y2.hi);
        DD scale = TEN.pow(mag);
        if ((y2 = y2.divide(scale)).gt(TEN)) {
            y2 = y2.divide(TEN);
            ++mag;
        } else if (y2.lt(ONE)) {
            y2 = y2.multiply(TEN);
            --mag;
        }
        int decimalPointPos = mag + 1;
        StringBuffer buf = new StringBuffer();
        int numDigits = 31;
        for (int i2 = 0; i2 <= numDigits; ++i2) {
            int digit;
            if (insertDecimalPoint && i2 == decimalPointPos) {
                buf.append('.');
            }
            if ((digit = (int)y2.hi) < 0 || digit > 9) {
                // empty if block
            }
            if (digit < 0) break;
            boolean rebiasBy10 = false;
            char digitChar = '\u0000';
            if (digit > 9) {
                rebiasBy10 = true;
                digitChar = '9';
            } else {
                digitChar = (char)(48 + digit);
            }
            buf.append(digitChar);
            y2 = y2.subtract(DD.valueOf(digit)).multiply(TEN);
            if (rebiasBy10) {
                y2.selfAdd(TEN);
            }
            boolean continueExtractingDigits = true;
            int remMag = DD.magnitude(y2.hi);
            if (remMag < 0 && Math.abs(remMag) >= numDigits - i2) {
                continueExtractingDigits = false;
            }
            if (!continueExtractingDigits) break;
        }
        magnitude[0] = mag;
        return buf.toString();
    }

    private static String stringOfChar(char ch2, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < len; ++i2) {
            buf.append(ch2);
        }
        return buf.toString();
    }

    private String getSpecialNumberString() {
        if (this.isZero()) {
            return "0.0";
        }
        if (this.isNaN()) {
            return "NaN ";
        }
        return null;
    }

    private static int magnitude(double x2) {
        double xAbs = Math.abs(x2);
        double xLog10 = Math.log(xAbs) / Math.log(10.0);
        int xMag = (int)Math.floor(xLog10);
        double xApprox = Math.pow(10.0, xMag);
        if (xApprox * 10.0 <= xAbs) {
            ++xMag;
        }
        return xMag;
    }

    public static DD parse(String str) throws NumberFormatException {
        char signCh;
        int i2 = 0;
        int strlen = str.length();
        while (Character.isWhitespace(str.charAt(i2))) {
            ++i2;
        }
        boolean isNegative = false;
        if (i2 < strlen && ((signCh = str.charAt(i2)) == '-' || signCh == '+')) {
            ++i2;
            if (signCh == '-') {
                isNegative = true;
            }
        }
        DD val = new DD();
        int numDigits = 0;
        int numBeforeDec = 0;
        int exp = 0;
        while (i2 < strlen) {
            char ch2 = str.charAt(i2);
            ++i2;
            if (Character.isDigit(ch2)) {
                double d2 = ch2 - 48;
                val.selfMultiply(TEN);
                val.selfAdd(d2);
                ++numDigits;
                continue;
            }
            if (ch2 == '.') {
                numBeforeDec = numDigits;
                continue;
            }
            if (ch2 == 'e' || ch2 == 'E') {
                String expStr = str.substring(i2);
                try {
                    exp = Integer.parseInt(expStr);
                    break;
                }
                catch (NumberFormatException ex2) {
                    throw new NumberFormatException("Invalid exponent " + expStr + " in string " + str);
                }
            }
            throw new NumberFormatException("Unexpected character '" + ch2 + "' at position " + i2 + " in string " + str);
        }
        DD val2 = val;
        int numDecPlaces = numDigits - numBeforeDec - exp;
        if (numDecPlaces == 0) {
            val2 = val;
        } else if (numDecPlaces > 0) {
            DD scale = TEN.pow(numDecPlaces);
            val2 = val.divide(scale);
        } else if (numDecPlaces < 0) {
            DD scale = TEN.pow(-numDecPlaces);
            val2 = val.multiply(scale);
        }
        if (isNegative) {
            return val2.negate();
        }
        return val2;
    }
}

