/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.intervalrtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.intervalrtree.IntervalRTreeBranchNode;
import com.vividsolutions.jts.index.intervalrtree.IntervalRTreeLeafNode;
import com.vividsolutions.jts.index.intervalrtree.IntervalRTreeNode;
import com.vividsolutions.jts.io.WKTWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SortedPackedIntervalRTree {
    private List leaves = new ArrayList();
    private IntervalRTreeNode root = null;
    private int level = 0;

    public void insert(double min2, double max, Object item) {
        if (this.root != null) {
            throw new IllegalStateException("Index cannot be added to once it has been queried");
        }
        this.leaves.add(new IntervalRTreeLeafNode(min2, max, item));
    }

    private void init() {
        if (this.root != null) {
            return;
        }
        this.buildRoot();
    }

    private synchronized void buildRoot() {
        if (this.root != null) {
            return;
        }
        this.root = this.buildTree();
    }

    private IntervalRTreeNode buildTree() {
        Collections.sort(this.leaves, new IntervalRTreeNode.NodeComparator());
        ArrayList src = this.leaves;
        ArrayList temp = null;
        ArrayList dest = new ArrayList();
        while (true) {
            this.buildLevel(src, dest);
            if (dest.size() == 1) {
                return (IntervalRTreeNode)dest.get(0);
            }
            temp = src;
            src = dest;
            dest = temp;
        }
    }

    private void buildLevel(List src, List dest) {
        ++this.level;
        dest.clear();
        for (int i2 = 0; i2 < src.size(); i2 += 2) {
            IntervalRTreeNode n2;
            IntervalRTreeNode n1 = (IntervalRTreeNode)src.get(i2);
            IntervalRTreeNode intervalRTreeNode = n2 = i2 + 1 < src.size() ? (IntervalRTreeNode)src.get(i2) : null;
            if (n2 == null) {
                dest.add(n1);
                continue;
            }
            IntervalRTreeBranchNode node = new IntervalRTreeBranchNode((IntervalRTreeNode)src.get(i2), (IntervalRTreeNode)src.get(i2 + 1));
            dest.add(node);
        }
    }

    private void printNode(IntervalRTreeNode node) {
        System.out.println(WKTWriter.toLineString(new Coordinate(node.min, this.level), new Coordinate(node.max, this.level)));
    }

    public void query(double min2, double max, ItemVisitor visitor) {
        this.init();
        this.root.query(min2, max, visitor);
    }
}

