/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.bintree;

public class Interval {
    public double min;
    public double max;

    public Interval() {
        this.min = 0.0;
        this.max = 0.0;
    }

    public Interval(double min2, double max) {
        this.init(min2, max);
    }

    public Interval(Interval interval) {
        this.init(interval.min, interval.max);
    }

    public void init(double min2, double max) {
        this.min = min2;
        this.max = max;
        if (min2 > max) {
            this.min = max;
            this.max = min2;
        }
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getWidth() {
        return this.max - this.min;
    }

    public void expandToInclude(Interval interval) {
        if (interval.max > this.max) {
            this.max = interval.max;
        }
        if (interval.min < this.min) {
            this.min = interval.min;
        }
    }

    public boolean overlaps(Interval interval) {
        return this.overlaps(interval.min, interval.max);
    }

    public boolean overlaps(double min2, double max) {
        return !(this.min > max) && !(this.max < min2);
    }

    public boolean contains(Interval interval) {
        return this.contains(interval.min, interval.max);
    }

    public boolean contains(double min2, double max) {
        return min2 >= this.min && max <= this.max;
    }

    public boolean contains(double p2) {
        return p2 >= this.min && p2 <= this.max;
    }

    public String toString() {
        return "[" + this.min + ", " + this.max + "]";
    }
}

