/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.util.Assert;
import java.util.Arrays;
import java.util.TreeSet;

public class GeometryCollection
extends Geometry {
    private static final long serialVersionUID = -5694727726395021467L;
    protected Geometry[] geometries;

    public GeometryCollection(Geometry[] geometries, PrecisionModel precisionModel, int SRID) {
        this(geometries, new GeometryFactory(precisionModel, SRID));
    }

    public GeometryCollection(Geometry[] geometries, GeometryFactory factory) {
        super(factory);
        if (geometries == null) {
            geometries = new Geometry[]{};
        }
        if (GeometryCollection.hasNullElements(geometries)) {
            throw new IllegalArgumentException("geometries must not contain null elements");
        }
        this.geometries = geometries;
    }

    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.geometries[0].getCoordinate();
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] coordinates = new Coordinate[this.getNumPoints()];
        int k2 = -1;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            Coordinate[] childCoordinates = this.geometries[i2].getCoordinates();
            for (int j2 = 0; j2 < childCoordinates.length; ++j2) {
                coordinates[++k2] = childCoordinates[j2];
            }
        }
        return coordinates;
    }

    public boolean isEmpty() {
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            if (this.geometries[i2].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getDimension() {
        int dimension = -1;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            dimension = Math.max(dimension, this.geometries[i2].getDimension());
        }
        return dimension;
    }

    public int getBoundaryDimension() {
        int dimension = -1;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            dimension = Math.max(dimension, this.geometries[i2].getBoundaryDimension());
        }
        return dimension;
    }

    public int getNumGeometries() {
        return this.geometries.length;
    }

    public Geometry getGeometryN(int n2) {
        return this.geometries[n2];
    }

    public int getNumPoints() {
        int numPoints = 0;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            numPoints += this.geometries[i2].getNumPoints();
        }
        return numPoints;
    }

    public String getGeometryType() {
        return "GeometryCollection";
    }

    public Geometry getBoundary() {
        this.checkNotGeometryCollection(this);
        Assert.shouldNeverReachHere();
        return null;
    }

    public double getArea() {
        double area = 0.0;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            area += this.geometries[i2].getArea();
        }
        return area;
    }

    public double getLength() {
        double sum = 0.0;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            sum += this.geometries[i2].getLength();
        }
        return sum;
    }

    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        GeometryCollection otherCollection = (GeometryCollection)other;
        if (this.geometries.length != otherCollection.geometries.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            if (this.geometries[i2].equalsExact(otherCollection.geometries[i2], tolerance)) continue;
            return false;
        }
        return true;
    }

    public void apply(CoordinateFilter filter) {
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            this.geometries[i2].apply(filter);
        }
    }

    public void apply(CoordinateSequenceFilter filter) {
        if (this.geometries.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            this.geometries[i2].apply(filter);
            if (filter.isDone()) break;
        }
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    public void apply(GeometryFilter filter) {
        filter.filter(this);
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            this.geometries[i2].apply(filter);
        }
    }

    public void apply(GeometryComponentFilter filter) {
        filter.filter(this);
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            this.geometries[i2].apply(filter);
        }
    }

    public Object clone() {
        GeometryCollection gc2 = (GeometryCollection)super.clone();
        gc2.geometries = new Geometry[this.geometries.length];
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            gc2.geometries[i2] = (Geometry)this.geometries[i2].clone();
        }
        return gc2;
    }

    public void normalize() {
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            this.geometries[i2].normalize();
        }
        Arrays.sort(this.geometries);
    }

    protected Envelope computeEnvelopeInternal() {
        Envelope envelope = new Envelope();
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            envelope.expandToInclude(this.geometries[i2].getEnvelopeInternal());
        }
        return envelope;
    }

    protected int compareToSameClass(Object o2) {
        TreeSet<Geometry> theseElements = new TreeSet<Geometry>(Arrays.asList(this.geometries));
        TreeSet<Geometry> otherElements = new TreeSet<Geometry>(Arrays.asList(((GeometryCollection)o2).geometries));
        return this.compare(theseElements, otherElements);
    }

    protected int compareToSameClass(Object o2, CoordinateSequenceComparator comp) {
        int i2;
        GeometryCollection gc2 = (GeometryCollection)o2;
        int n1 = this.getNumGeometries();
        int n2 = gc2.getNumGeometries();
        for (i2 = 0; i2 < n1 && i2 < n2; ++i2) {
            Geometry otherGeom;
            Geometry thisGeom = this.getGeometryN(i2);
            int holeComp = thisGeom.compareToSameClass(otherGeom = gc2.getGeometryN(i2), comp);
            if (holeComp == 0) continue;
            return holeComp;
        }
        if (i2 < n1) {
            return 1;
        }
        if (i2 < n2) {
            return -1;
        }
        return 0;
    }

    public Geometry reverse() {
        int n2 = this.geometries.length;
        Geometry[] revGeoms = new Geometry[n2];
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            revGeoms[i2] = this.geometries[i2].reverse();
        }
        return this.getFactory().createGeometryCollection(revGeoms);
    }
}

