/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.awt;

import com.vividsolutions.jts.awt.GeometryCollectionShape;
import com.vividsolutions.jts.awt.IdentityPointTransformation;
import com.vividsolutions.jts.awt.PointShapeFactory;
import com.vividsolutions.jts.awt.PointTransformation;
import com.vividsolutions.jts.awt.PolygonShape;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class ShapeWriter {
    public static final PointTransformation DEFAULT_POINT_TRANSFORMATION = new IdentityPointTransformation();
    public static final PointShapeFactory DEFAULT_POINT_FACTORY = new PointShapeFactory.Square(3.0);
    private PointTransformation pointTransformer = DEFAULT_POINT_TRANSFORMATION;
    private PointShapeFactory pointFactory = DEFAULT_POINT_FACTORY;
    private Point2D transPoint = new Point2D.Double();
    private boolean doRemoveDuplicatePoints = false;
    private double decimationDistance = 0.0;

    public ShapeWriter(PointTransformation pointTransformer, PointShapeFactory pointFactory) {
        if (pointTransformer != null) {
            this.pointTransformer = pointTransformer;
        }
        if (pointFactory != null) {
            this.pointFactory = pointFactory;
        }
    }

    public ShapeWriter(PointTransformation pointTransformer) {
        this(pointTransformer, null);
    }

    public ShapeWriter() {
    }

    public void setRemoveDuplicatePoints(boolean doRemoveDuplicatePoints) {
        this.doRemoveDuplicatePoints = doRemoveDuplicatePoints;
    }

    public void setDecimation(double decimationDistance) {
        this.decimationDistance = decimationDistance;
    }

    public Shape toShape(Geometry geometry) {
        if (geometry.isEmpty()) {
            return new GeneralPath();
        }
        if (geometry instanceof Polygon) {
            return this.toShape((Polygon)geometry);
        }
        if (geometry instanceof LineString) {
            return this.toShape((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.toShape((MultiLineString)geometry);
        }
        if (geometry instanceof Point) {
            return this.toShape((Point)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.toShape((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unrecognized Geometry class: " + geometry.getClass());
    }

    private Shape toShape(Polygon p2) {
        PolygonShape poly = new PolygonShape();
        this.appendRing(poly, p2.getExteriorRing().getCoordinates());
        for (int j2 = 0; j2 < p2.getNumInteriorRing(); ++j2) {
            this.appendRing(poly, p2.getInteriorRingN(j2).getCoordinates());
        }
        return poly;
    }

    private void appendRing(PolygonShape poly, Coordinate[] coords) {
        double prevx = Double.NaN;
        double prevy = Double.NaN;
        Coordinate prev = null;
        int n2 = coords.length - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.decimationDistance > 0.0) {
                boolean isDecimated;
                boolean bl2 = isDecimated = prev != null && Math.abs(coords[i2].x - prev.x) < this.decimationDistance && Math.abs(coords[i2].y - prev.y) < this.decimationDistance;
                if (i2 < n2 && isDecimated) continue;
                prev = coords[i2];
            }
            this.transformPoint(coords[i2], this.transPoint);
            if (this.doRemoveDuplicatePoints) {
                boolean isDup;
                boolean bl3 = isDup = this.transPoint.getX() == prevx && this.transPoint.getY() == prevy;
                if (i2 < n2 && isDup) continue;
                prevx = this.transPoint.getX();
                prevy = this.transPoint.getY();
            }
            poly.addToRing(this.transPoint);
        }
        poly.endRing();
    }

    private Shape toShape(GeometryCollection gc2) {
        GeometryCollectionShape shape = new GeometryCollectionShape();
        for (int i2 = 0; i2 < gc2.getNumGeometries(); ++i2) {
            Geometry g2 = gc2.getGeometryN(i2);
            shape.add(this.toShape(g2));
        }
        return shape;
    }

    private GeneralPath toShape(MultiLineString mls) {
        GeneralPath path = new GeneralPath();
        for (int i2 = 0; i2 < mls.getNumGeometries(); ++i2) {
            LineString lineString = (LineString)mls.getGeometryN(i2);
            path.append(this.toShape(lineString), false);
        }
        return path;
    }

    private GeneralPath toShape(LineString lineString) {
        GeneralPath shape = new GeneralPath();
        Coordinate prev = lineString.getCoordinateN(0);
        this.transformPoint(prev, this.transPoint);
        shape.moveTo((float)this.transPoint.getX(), (float)this.transPoint.getY());
        double prevx = this.transPoint.getX();
        double prevy = this.transPoint.getY();
        int n2 = lineString.getNumPoints() - 1;
        for (int i2 = 1; i2 <= n2; ++i2) {
            Coordinate currentCoord = lineString.getCoordinateN(i2);
            if (this.decimationDistance > 0.0) {
                boolean isDecimated;
                boolean bl2 = isDecimated = prev != null && Math.abs(currentCoord.x - prev.x) < this.decimationDistance && Math.abs(currentCoord.y - prev.y) < this.decimationDistance;
                if (i2 < n2 && isDecimated) continue;
                prev = currentCoord;
            }
            this.transformPoint(currentCoord, this.transPoint);
            if (this.doRemoveDuplicatePoints) {
                boolean isDup;
                boolean bl3 = isDup = this.transPoint.getX() == prevx && this.transPoint.getY() == prevy;
                if (i2 < n2 && isDup) continue;
                prevx = this.transPoint.getX();
                prevy = this.transPoint.getY();
            }
            shape.lineTo((float)this.transPoint.getX(), (float)this.transPoint.getY());
        }
        return shape;
    }

    private Shape toShape(Point point) {
        Point2D viewPoint = this.transformPoint(point.getCoordinate());
        return this.pointFactory.createPoint(viewPoint);
    }

    private Point2D transformPoint(Coordinate model) {
        return this.transformPoint(model, new Point2D.Double());
    }

    private Point2D transformPoint(Coordinate model, Point2D view) {
        this.pointTransformer.transform(model, view);
        return view;
    }
}

