/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm.locate;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.locate.PointOnGeometryLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryCollectionIterator;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;

public class SimplePointInAreaLocator
implements PointOnGeometryLocator {
    private Geometry geom;

    public static int locate(Coordinate p2, Geometry geom) {
        if (geom.isEmpty()) {
            return 2;
        }
        if (SimplePointInAreaLocator.containsPoint(p2, geom)) {
            return 0;
        }
        return 2;
    }

    private static boolean containsPoint(Coordinate p2, Geometry geom) {
        if (geom instanceof Polygon) {
            return SimplePointInAreaLocator.containsPointInPolygon(p2, (Polygon)geom);
        }
        if (geom instanceof GeometryCollection) {
            GeometryCollectionIterator geomi = new GeometryCollectionIterator((GeometryCollection)geom);
            while (geomi.hasNext()) {
                Geometry g2 = (Geometry)geomi.next();
                if (g2 == geom || !SimplePointInAreaLocator.containsPoint(p2, g2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsPointInPolygon(Coordinate p2, Polygon poly) {
        if (poly.isEmpty()) {
            return false;
        }
        LinearRing shell = (LinearRing)poly.getExteriorRing();
        if (!SimplePointInAreaLocator.isPointInRing(p2, shell)) {
            return false;
        }
        for (int i2 = 0; i2 < poly.getNumInteriorRing(); ++i2) {
            LinearRing hole = (LinearRing)poly.getInteriorRingN(i2);
            if (!SimplePointInAreaLocator.isPointInRing(p2, hole)) continue;
            return false;
        }
        return true;
    }

    private static boolean isPointInRing(Coordinate p2, LinearRing ring) {
        if (!ring.getEnvelopeInternal().intersects(p2)) {
            return false;
        }
        return CGAlgorithms.isPointInRing(p2, ring.getCoordinates());
    }

    public SimplePointInAreaLocator(Geometry geom) {
        this.geom = geom;
    }

    public int locate(Coordinate p2) {
        return SimplePointInAreaLocator.locate(p2, this.geom);
    }
}

