/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin.stats;

import com.sun.marlin.stats.StatLong;

public final class Histogram
extends StatLong {
    static final int BUCKET = 2;
    static final int MAX = 20;
    static final int LAST = 19;
    static final int[] STEPS = new int[20];
    private final StatLong[] stats = new StatLong[20];

    static int bucket(int n2) {
        for (int i2 = 1; i2 < 20; ++i2) {
            if (n2 >= STEPS[i2]) continue;
            return i2 - 1;
        }
        return 19;
    }

    public Histogram(String string) {
        super(string);
        for (int i2 = 0; i2 < 20; ++i2) {
            this.stats[i2] = new StatLong(String.format("%5s .. %5s", STEPS[i2], i2 + 1 < 20 ? Integer.valueOf(STEPS[i2 + 1]) : "~"));
        }
    }

    @Override
    public void reset() {
        super.reset();
        for (int i2 = 0; i2 < 20; ++i2) {
            this.stats[i2].reset();
        }
    }

    @Override
    public void add(int n2) {
        super.add(n2);
        this.stats[Histogram.bucket(n2)].add(n2);
    }

    @Override
    public void add(long l2) {
        this.add((int)l2);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(2048);
        super.toString(stringBuilder).append(" { ");
        for (int i2 = 0; i2 < 20; ++i2) {
            if (this.stats[i2].count == 0L) continue;
            stringBuilder.append("\n        ").append(this.stats[i2].toString());
        }
        return stringBuilder.append(" }").toString();
    }

    static {
        Histogram.STEPS[0] = 0;
        Histogram.STEPS[1] = 1;
        for (int i2 = 2; i2 < 20; ++i2) {
            Histogram.STEPS[i2] = STEPS[i2 - 1] * 2;
        }
    }
}

