/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.DPathConsumer2D;
import com.sun.marlin.MarlinProperties;

public final class PathSimplifier
implements DPathConsumer2D {
    private static final double PIX_THRESHOLD = MarlinProperties.getPathSimplifierPixelTolerance();
    private static final double SQUARE_TOLERANCE = PIX_THRESHOLD * PIX_THRESHOLD;
    private DPathConsumer2D delegate;
    private double cx;
    private double cy;
    private boolean skipped;
    private double sx;
    private double sy;

    PathSimplifier() {
    }

    public PathSimplifier init(DPathConsumer2D dPathConsumer2D) {
        this.delegate = dPathConsumer2D;
        this.skipped = false;
        return this;
    }

    private void finishPath() {
        if (this.skipped) {
            this._lineTo(this.sx, this.sy);
        }
    }

    @Override
    public void pathDone() {
        this.finishPath();
        this.delegate.pathDone();
    }

    @Override
    public void closePath() {
        this.finishPath();
        this.delegate.closePath();
    }

    @Override
    public void moveTo(double d2, double d3) {
        this.finishPath();
        this.delegate.moveTo(d2, d3);
        this.cx = d2;
        this.cy = d3;
    }

    @Override
    public void lineTo(double d2, double d3) {
        double d4 = d2 - this.cx;
        double d5 = d3 - this.cy;
        if (d4 * d4 + d5 * d5 <= SQUARE_TOLERANCE) {
            this.skipped = true;
            this.sx = d2;
            this.sy = d3;
            return;
        }
        this._lineTo(d2, d3);
    }

    private void _lineTo(double d2, double d3) {
        this.delegate.lineTo(d2, d3);
        this.cx = d2;
        this.cy = d3;
        this.skipped = false;
    }

    @Override
    public void quadTo(double d2, double d3, double d4, double d5) {
        double d6 = d4 - this.cx;
        double d7 = d5 - this.cy;
        if (d6 * d6 + d7 * d7 <= SQUARE_TOLERANCE && (d6 = d2 - this.cx) * d6 + (d7 = d3 - this.cy) * d7 <= SQUARE_TOLERANCE) {
            this.skipped = true;
            this.sx = d4;
            this.sy = d5;
            return;
        }
        this.delegate.quadTo(d2, d3, d4, d5);
        this.cx = d4;
        this.cy = d5;
        this.skipped = false;
    }

    @Override
    public void curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d6 - this.cx;
        double d9 = d7 - this.cy;
        if (d8 * d8 + d9 * d9 <= SQUARE_TOLERANCE && (d8 = d2 - this.cx) * d8 + (d9 = d3 - this.cy) * d9 <= SQUARE_TOLERANCE && (d8 = d4 - this.cx) * d8 + (d9 = d5 - this.cy) * d9 <= SQUARE_TOLERANCE) {
            this.skipped = true;
            this.sx = d6;
            this.sy = d7;
            return;
        }
        this.delegate.curveTo(d2, d3, d4, d5, d6, d7);
        this.cx = d6;
        this.cy = d7;
        this.skipped = false;
    }
}

