/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.DPathConsumer2D;
import com.sun.marlin.DoubleArrayCache;
import com.sun.marlin.FloatMath;
import com.sun.marlin.Helpers;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinProperties;
import com.sun.marlin.RendererContext;
import com.sun.marlin.TransformingPathConsumer2D;

public final class Dasher
implements DPathConsumer2D,
MarlinConst {
    static final int REC_LIMIT = 16;
    static final double CURVE_LEN_ERR = MarlinProperties.getCurveLengthError();
    static final double MIN_T_INC = 1.52587890625E-5;
    static final double EPS = 1.0E-6;
    static final double MAX_CYCLES = 1.6E7;
    private DPathConsumer2D out;
    private double[] dash;
    private int dashLen;
    private double startPhase;
    private boolean startDashOn;
    private int startIdx;
    private boolean starting;
    private boolean needsMoveTo;
    private int idx;
    private boolean dashOn;
    private double phase;
    private double sx0;
    private double sy0;
    private double cx0;
    private double cy0;
    private final double[] curCurvepts;
    final RendererContext rdrCtx;
    boolean recycleDashes;
    private double[] firstSegmentsBuffer;
    private int firstSegidx;
    final DoubleArrayCache.Reference dashes_ref;
    final DoubleArrayCache.Reference firstSegmentsBuffer_ref;
    private double[] clipRect;
    private int cOutCode = 0;
    private boolean subdivide = DO_CLIP_SUBDIVIDER;
    private final LengthIterator li = new LengthIterator();
    private final TransformingPathConsumer2D.CurveClipSplitter curveSplitter;
    private double cycleLen;
    private boolean outside;
    private double totalSkipLen;

    Dasher(RendererContext rendererContext) {
        this.rdrCtx = rendererContext;
        this.dashes_ref = rendererContext.newDirtyDoubleArrayRef(256);
        this.firstSegmentsBuffer_ref = rendererContext.newDirtyDoubleArrayRef(256);
        this.firstSegmentsBuffer = this.firstSegmentsBuffer_ref.initial;
        this.curCurvepts = new double[16];
        this.curveSplitter = rendererContext.curveClipSplitter;
    }

    public Dasher init(DPathConsumer2D dPathConsumer2D, double[] dArray, int n2, double d2, boolean bl2) {
        this.out = dPathConsumer2D;
        int n3 = 0;
        this.dashOn = true;
        double d3 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d3 += dArray[i2];
        }
        this.cycleLen = d3;
        double d4 = d2 / d3;
        if (d2 < 0.0) {
            if (-d4 >= 1.6E7) {
                d2 = 0.0;
            } else {
                int n4 = FloatMath.floor_int(-d4);
                if ((n4 & n2 & 1) != 0) {
                    this.dashOn = !this.dashOn;
                }
                d2 += (double)n4 * d3;
                while (d2 < 0.0) {
                    if (--n3 < 0) {
                        n3 = n2 - 1;
                    }
                    d2 += dArray[n3];
                    this.dashOn = !this.dashOn;
                }
            }
        } else if (d2 > 0.0) {
            if (d4 >= 1.6E7) {
                d2 = 0.0;
            } else {
                int n5 = FloatMath.floor_int(d4);
                if ((n5 & n2 & 1) != 0) {
                    this.dashOn = !this.dashOn;
                }
                d2 -= (double)n5 * d3;
                while (true) {
                    double d5;
                    double d6 = dArray[n3];
                    if (!(d2 >= d5)) break;
                    d2 -= d6;
                    n3 = (n3 + 1) % n2;
                    this.dashOn = !this.dashOn;
                }
            }
        }
        this.dash = dArray;
        this.dashLen = n2;
        this.phase = d2;
        this.startPhase = d2;
        this.startDashOn = this.dashOn;
        this.startIdx = n3;
        this.starting = true;
        this.needsMoveTo = false;
        this.firstSegidx = 0;
        this.recycleDashes = bl2;
        if (this.rdrCtx.doClip) {
            this.clipRect = this.rdrCtx.clipRect;
        } else {
            this.clipRect = null;
            this.cOutCode = 0;
        }
        return this;
    }

    void dispose() {
        if (this.recycleDashes) {
            this.dash = this.dashes_ref.putArray(this.dash);
        }
        this.firstSegmentsBuffer = this.firstSegmentsBuffer_ref.putArray(this.firstSegmentsBuffer);
    }

    public double[] copyDashArray(float[] fArray) {
        double[] dArray;
        int n2 = fArray.length;
        if (n2 <= 256) {
            dArray = this.dashes_ref.initial;
        } else {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_array_dasher_dasher.add(n2);
            }
            dArray = this.dashes_ref.getArray(n2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = fArray[i2];
        }
        return dArray;
    }

    @Override
    public void moveTo(double d2, double d3) {
        if (this.firstSegidx != 0) {
            this.out.moveTo(this.sx0, this.sy0);
            this.emitFirstSegments();
        }
        this.needsMoveTo = true;
        this.idx = this.startIdx;
        this.dashOn = this.startDashOn;
        this.phase = this.startPhase;
        this.cx0 = d2;
        this.cy0 = d3;
        this.sx0 = d2;
        this.sy0 = d3;
        this.starting = true;
        if (this.clipRect != null) {
            int n2;
            this.cOutCode = n2 = Helpers.outcode(d2, d3, this.clipRect);
            this.outside = false;
            this.totalSkipLen = 0.0;
        }
    }

    private void emitSeg(double[] dArray, int n2, int n3) {
        switch (n3) {
            case 4: {
                this.out.lineTo(dArray[n2], dArray[n2 + 1]);
                return;
            }
            case 8: {
                this.out.curveTo(dArray[n2], dArray[n2 + 1], dArray[n2 + 2], dArray[n2 + 3], dArray[n2 + 4], dArray[n2 + 5]);
                return;
            }
            case 6: {
                this.out.quadTo(dArray[n2], dArray[n2 + 1], dArray[n2 + 2], dArray[n2 + 3]);
                return;
            }
        }
    }

    private void emitFirstSegments() {
        int n2;
        double[] dArray = this.firstSegmentsBuffer;
        int n3 = this.firstSegidx;
        for (int i2 = 0; i2 < n3; i2 += n2 - 1) {
            n2 = (int)dArray[i2];
            this.emitSeg(dArray, i2 + 1, n2);
        }
        this.firstSegidx = 0;
    }

    private void goTo(double[] dArray, int n2, int n3, boolean bl2) {
        int n4 = n2 + n3;
        double d2 = dArray[n4 - 4];
        double d3 = dArray[n4 - 3];
        if (bl2) {
            if (this.starting) {
                this.goTo_starting(dArray, n2, n3);
            } else {
                if (this.needsMoveTo) {
                    this.needsMoveTo = false;
                    this.out.moveTo(this.cx0, this.cy0);
                }
                this.emitSeg(dArray, n2, n3);
            }
        } else {
            if (this.starting) {
                this.starting = false;
            }
            this.needsMoveTo = true;
        }
        this.cx0 = d2;
        this.cy0 = d3;
    }

    private void goTo_starting(double[] dArray, int n2, int n3) {
        int n4 = this.firstSegidx;
        int n5 = n3 - 1;
        double[] dArray2 = this.firstSegmentsBuffer;
        if (n4 + n5 > dArray2.length) {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_array_dasher_firstSegmentsBuffer.add(n4 + n5);
            }
            this.firstSegmentsBuffer = dArray2 = this.firstSegmentsBuffer_ref.widenArray(dArray2, n4, n4 + n5);
        }
        dArray2[n4++] = n3;
        System.arraycopy(dArray, n2, dArray2, n4, --n5);
        this.firstSegidx = n4 + n5;
    }

    @Override
    public void lineTo(double d2, double d3) {
        int n2 = this.cOutCode;
        if (this.clipRect != null) {
            int n3 = Helpers.outcode(d2, d3, this.clipRect);
            int n4 = n2 | n3;
            if (n4 != 0) {
                int n5 = n2 & n3;
                if (n5 == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean bl2 = this.curveSplitter.splitLine(this.cx0, this.cy0, d2, d3, n4, this);
                        this.subdivide = true;
                        if (bl2) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n3;
                    this.skipLineTo(d2, d3);
                    return;
                }
            }
            this.cOutCode = n3;
            if (this.outside) {
                this.outside = false;
                this.skipLen();
            }
        }
        this._lineTo(d2, d3);
    }

    private void _lineTo(double d2, double d3) {
        double d4 = d2 - this.cx0;
        double d5 = d3 - this.cy0;
        double d6 = d4 * d4 + d5 * d5;
        if (d6 == 0.0) {
            return;
        }
        d6 = Math.sqrt(d6);
        double d7 = d4 / d6;
        double d8 = d5 / d6;
        double[] dArray = this.curCurvepts;
        double[] dArray2 = this.dash;
        int n2 = this.dashLen;
        int n3 = this.idx;
        boolean bl2 = this.dashOn;
        double d9 = this.phase;
        while (true) {
            double d10;
            double d11;
            if ((d11 = d6 - (d10 = dArray2[n3] - d9)) <= 1.0E-6) {
                dArray[0] = d2;
                dArray[1] = d3;
                this.goTo(dArray, 0, 4, bl2);
                d9 += d6;
                if (!(Math.abs(d11) <= 1.0E-6)) break;
                d9 = 0.0;
                n3 = (n3 + 1) % n2;
                bl2 = !bl2;
                break;
            }
            dArray[0] = this.cx0 + d10 * d7;
            dArray[1] = this.cy0 + d10 * d8;
            this.goTo(dArray, 0, 4, bl2);
            d6 = d11;
            n3 = (n3 + 1) % n2;
            bl2 = !bl2;
            d9 = 0.0;
        }
        this.idx = n3;
        this.dashOn = bl2;
        this.phase = d9;
    }

    private void skipLineTo(double d2, double d3) {
        double d4 = d2 - this.cx0;
        double d5 = d3 - this.cy0;
        double d6 = d4 * d4 + d5 * d5;
        if (d6 != 0.0) {
            d6 = Math.sqrt(d6);
        }
        this.outside = true;
        this.totalSkipLen += d6;
        this.needsMoveTo = true;
        this.starting = false;
        this.cx0 = d2;
        this.cy0 = d3;
    }

    public void skipLen() {
        double d2 = this.totalSkipLen;
        this.totalSkipLen = 0.0;
        double[] dArray = this.dash;
        int n2 = this.dashLen;
        int n3 = this.idx;
        boolean bl2 = this.dashOn;
        double d3 = this.phase;
        long l2 = (long)Math.floor(d2 / this.cycleLen) - 2L;
        if (l2 > 0L) {
            d2 -= this.cycleLen * (double)l2;
            long l3 = l2 * (long)n2;
            n3 = (int)(l3 + (long)n3) % n2;
            boolean bl3 = bl2 = (l3 + (bl2 ? 1L : 0L) & 1L) == 1L;
        }
        while (true) {
            double d4;
            double d5;
            if ((d5 = d2 - (d4 = dArray[n3] - d3)) <= 1.0E-6) {
                d3 += d2;
                if (!(Math.abs(d5) <= 1.0E-6)) break;
                d3 = 0.0;
                n3 = (n3 + 1) % n2;
                bl2 = !bl2;
                break;
            }
            d2 = d5;
            n3 = (n3 + 1) % n2;
            bl2 = !bl2;
            d3 = 0.0;
        }
        this.idx = n3;
        this.dashOn = bl2;
        this.phase = d3;
    }

    private void somethingTo(int n2) {
        double[] dArray = this.curCurvepts;
        if (Dasher.pointCurve(dArray, n2)) {
            return;
        }
        LengthIterator lengthIterator = this.li;
        double[] dArray2 = this.dash;
        int n3 = this.dashLen;
        lengthIterator.initializeIterationOnCurve(dArray, n2);
        int n4 = this.idx;
        boolean bl2 = this.dashOn;
        double d2 = this.phase;
        int n5 = 0;
        double d3 = 0.0;
        double d4 = dArray2[n4] - d2;
        while (true) {
            double d5;
            double d6 = lengthIterator.next(d4);
            if (!(d5 < 1.0)) break;
            if (d6 != 0.0) {
                Helpers.subdivideAt((d6 - d3) / (1.0 - d3), dArray, n5, dArray, 0, n2);
                d3 = d6;
                this.goTo(dArray, 2, n2, bl2);
                n5 = n2;
            }
            n4 = (n4 + 1) % n3;
            bl2 = !bl2;
            d2 = 0.0;
            d4 = dArray2[n4];
        }
        this.goTo(dArray, n5 + 2, n2, bl2);
        d2 += lengthIterator.lastSegLen();
        if (d2 + 1.0E-6 >= dArray2[n4]) {
            d2 = 0.0;
            n4 = (n4 + 1) % n3;
            bl2 = !bl2;
        }
        this.idx = n4;
        this.dashOn = bl2;
        this.phase = d2;
        lengthIterator.reset();
    }

    private void skipSomethingTo(int n2) {
        double[] dArray = this.curCurvepts;
        if (Dasher.pointCurve(dArray, n2)) {
            return;
        }
        LengthIterator lengthIterator = this.li;
        lengthIterator.initializeIterationOnCurve(dArray, n2);
        double d2 = lengthIterator.totalLength();
        this.outside = true;
        this.totalSkipLen += d2;
        this.needsMoveTo = true;
        this.starting = false;
    }

    private static boolean pointCurve(double[] dArray, int n2) {
        for (int i2 = 2; i2 < n2; ++i2) {
            if (dArray[i2] == dArray[i2 - 2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        int n2 = this.cOutCode;
        if (this.clipRect != null) {
            int n3;
            int n4;
            int n5 = Helpers.outcode(d2, d3, this.clipRect);
            int n6 = n2 | n5 | (n4 = Helpers.outcode(d4, d5, this.clipRect)) | (n3 = Helpers.outcode(d6, d7, this.clipRect));
            if (n6 != 0) {
                int n7 = n2 & n5 & n4 & n3;
                if (n7 == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean bl2 = this.curveSplitter.splitCurve(this.cx0, this.cy0, d2, d3, d4, d5, d6, d7, n6, this);
                        this.subdivide = true;
                        if (bl2) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n3;
                    this.skipCurveTo(d2, d3, d4, d5, d6, d7);
                    return;
                }
            }
            this.cOutCode = n3;
            if (this.outside) {
                this.outside = false;
                this.skipLen();
            }
        }
        this._curveTo(d2, d3, d4, d5, d6, d7);
    }

    private void _curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        double[] dArray = this.curCurvepts;
        TransformingPathConsumer2D.CurveBasicMonotonizer curveBasicMonotonizer = this.rdrCtx.monotonizer.curve(this.cx0, this.cy0, d2, d3, d4, d5, d6, d7);
        int n2 = curveBasicMonotonizer.nbSplits;
        double[] dArray2 = curveBasicMonotonizer.middle;
        int n3 = 0;
        int n4 = 0;
        while (n3 <= n2) {
            System.arraycopy(dArray2, n4, dArray, 0, 8);
            this.somethingTo(8);
            ++n3;
            n4 += 6;
        }
    }

    private void skipCurveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        double[] dArray = this.curCurvepts;
        dArray[0] = this.cx0;
        dArray[1] = this.cy0;
        dArray[2] = d2;
        dArray[3] = d3;
        dArray[4] = d4;
        dArray[5] = d5;
        dArray[6] = d6;
        dArray[7] = d7;
        this.skipSomethingTo(8);
        this.cx0 = d6;
        this.cy0 = d7;
    }

    @Override
    public void quadTo(double d2, double d3, double d4, double d5) {
        int n2 = this.cOutCode;
        if (this.clipRect != null) {
            int n3;
            int n4 = Helpers.outcode(d2, d3, this.clipRect);
            int n5 = n2 | n4 | (n3 = Helpers.outcode(d4, d5, this.clipRect));
            if (n5 != 0) {
                int n6 = n2 & n4 & n3;
                if (n6 == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean bl2 = this.curveSplitter.splitQuad(this.cx0, this.cy0, d2, d3, d4, d5, n5, this);
                        this.subdivide = true;
                        if (bl2) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n3;
                    this.skipQuadTo(d2, d3, d4, d5);
                    return;
                }
            }
            this.cOutCode = n3;
            if (this.outside) {
                this.outside = false;
                this.skipLen();
            }
        }
        this._quadTo(d2, d3, d4, d5);
    }

    private void _quadTo(double d2, double d3, double d4, double d5) {
        double[] dArray = this.curCurvepts;
        TransformingPathConsumer2D.CurveBasicMonotonizer curveBasicMonotonizer = this.rdrCtx.monotonizer.quad(this.cx0, this.cy0, d2, d3, d4, d5);
        int n2 = curveBasicMonotonizer.nbSplits;
        double[] dArray2 = curveBasicMonotonizer.middle;
        int n3 = 0;
        int n4 = 0;
        while (n3 <= n2) {
            System.arraycopy(dArray2, n4, dArray, 0, 8);
            this.somethingTo(6);
            ++n3;
            n4 += 4;
        }
    }

    private void skipQuadTo(double d2, double d3, double d4, double d5) {
        double[] dArray = this.curCurvepts;
        dArray[0] = this.cx0;
        dArray[1] = this.cy0;
        dArray[2] = d2;
        dArray[3] = d3;
        dArray[4] = d4;
        dArray[5] = d5;
        this.skipSomethingTo(6);
        this.cx0 = d4;
        this.cy0 = d5;
    }

    @Override
    public void closePath() {
        if (this.cx0 != this.sx0 || this.cy0 != this.sy0) {
            this.lineTo(this.sx0, this.sy0);
        }
        if (this.firstSegidx != 0) {
            if (!this.dashOn || this.needsMoveTo) {
                this.out.moveTo(this.sx0, this.sy0);
            }
            this.emitFirstSegments();
        }
        this.moveTo(this.sx0, this.sy0);
    }

    @Override
    public void pathDone() {
        if (this.firstSegidx != 0) {
            this.out.moveTo(this.sx0, this.sy0);
            this.emitFirstSegments();
        }
        this.out.pathDone();
        this.dispose();
    }

    static final class LengthIterator {
        private final double[][] recCurveStack;
        private final boolean[] sidesRight;
        private int curveType;
        private double nextT;
        private double lenAtNextT;
        private double lastT;
        private double lenAtLastT;
        private double lenAtLastSplit;
        private double lastSegLen;
        private int recLevel;
        private boolean done = true;
        private final double[] curLeafCtrlPolyLengths = new double[3];
        private int cachedHaveLowAcceleration = -1;
        private final double[] nextRoots = new double[4];
        private final double[] flatLeafCoefCache = new double[]{0.0, 0.0, -1.0, 0.0};

        LengthIterator() {
            this.recCurveStack = new double[17][8];
            this.sidesRight = new boolean[16];
            this.nextT = Double.MAX_VALUE;
            this.lenAtNextT = Double.MAX_VALUE;
            this.lenAtLastSplit = Double.MIN_VALUE;
            this.recLevel = Integer.MIN_VALUE;
            this.lastSegLen = Double.MAX_VALUE;
        }

        void reset() {
        }

        void initializeIterationOnCurve(double[] dArray, int n2) {
            System.arraycopy(dArray, 0, this.recCurveStack[0], 0, 8);
            this.curveType = n2;
            this.recLevel = 0;
            this.lastT = 0.0;
            this.lenAtLastT = 0.0;
            this.nextT = 0.0;
            this.lenAtNextT = 0.0;
            this.goLeft();
            this.lenAtLastSplit = 0.0;
            if (this.recLevel > 0) {
                this.sidesRight[0] = false;
                this.done = false;
            } else {
                this.sidesRight[0] = true;
                this.done = true;
            }
            this.lastSegLen = 0.0;
        }

        private boolean haveLowAcceleration(double d2) {
            if (this.cachedHaveLowAcceleration == -1) {
                double d3;
                double d4;
                double d5 = this.curLeafCtrlPolyLengths[0];
                double d6 = this.curLeafCtrlPolyLengths[1];
                if (!Helpers.within(d5, d6, d2 * d6)) {
                    this.cachedHaveLowAcceleration = 0;
                    return false;
                }
                if (!(this.curveType != 8 || Helpers.within(d6, d4 = this.curLeafCtrlPolyLengths[2], d3 = d2 * d4) && Helpers.within(d5, d4, d3))) {
                    this.cachedHaveLowAcceleration = 0;
                    return false;
                }
                this.cachedHaveLowAcceleration = 1;
                return true;
            }
            return this.cachedHaveLowAcceleration == 1;
        }

        double next(double d2) {
            double d3 = this.lenAtLastSplit + d2;
            while (this.lenAtNextT < d3) {
                if (this.done) {
                    this.lastSegLen = this.lenAtNextT - this.lenAtLastSplit;
                    return 1.0;
                }
                this.goToNextLeaf();
            }
            this.lenAtLastSplit = d3;
            double d4 = this.lenAtNextT - this.lenAtLastT;
            double d5 = (d3 - this.lenAtLastT) / d4;
            if (!this.haveLowAcceleration(0.05)) {
                double d6;
                int n2;
                double d7;
                double d8;
                double d9;
                double[] dArray = this.flatLeafCoefCache;
                if (dArray[2] < 0.0) {
                    d9 = this.curLeafCtrlPolyLengths[0];
                    d8 = d9 + this.curLeafCtrlPolyLengths[1];
                    if (this.curveType == 8) {
                        d7 = d8 + this.curLeafCtrlPolyLengths[2];
                        dArray[0] = 3.0 * (d9 - d8) + d7;
                        dArray[1] = 3.0 * (d8 - 2.0 * d9);
                        dArray[2] = 3.0 * d9;
                        dArray[3] = -d7;
                    } else if (this.curveType == 6) {
                        dArray[0] = 0.0;
                        dArray[1] = d8 - 2.0 * d9;
                        dArray[2] = 2.0 * d9;
                        dArray[3] = -d8;
                    }
                }
                if ((n2 = Helpers.cubicRootsInAB(d9 = dArray[0], d8 = dArray[1], d7 = dArray[2], d6 = d5 * dArray[3], this.nextRoots, 0, 0.0, 1.0)) == 1 && !Double.isNaN(this.nextRoots[0])) {
                    d5 = this.nextRoots[0];
                }
            }
            if ((d5 = d5 * (this.nextT - this.lastT) + this.lastT) >= 1.0) {
                d5 = 1.0;
                this.done = true;
            }
            this.lastSegLen = d2;
            return d5;
        }

        double totalLength() {
            while (!this.done) {
                this.goToNextLeaf();
            }
            this.reset();
            return this.lenAtNextT;
        }

        double lastSegLen() {
            return this.lastSegLen;
        }

        private void goToNextLeaf() {
            boolean[] blArray = this.sidesRight;
            int n2 = this.recLevel;
            --n2;
            while (blArray[n2]) {
                if (n2 == 0) {
                    this.recLevel = 0;
                    this.done = true;
                    return;
                }
                --n2;
            }
            blArray[n2] = true;
            System.arraycopy(this.recCurveStack[n2++], 0, this.recCurveStack[n2], 0, 8);
            this.recLevel = n2;
            this.goLeft();
        }

        private void goLeft() {
            double d2 = this.onLeaf();
            if (d2 >= 0.0) {
                this.lastT = this.nextT;
                this.lenAtLastT = this.lenAtNextT;
                this.nextT += (double)(1 << 16 - this.recLevel) * 1.52587890625E-5;
                this.lenAtNextT += d2;
                this.flatLeafCoefCache[2] = -1.0;
                this.cachedHaveLowAcceleration = -1;
            } else {
                Helpers.subdivide(this.recCurveStack[this.recLevel], this.recCurveStack[this.recLevel + 1], this.recCurveStack[this.recLevel], this.curveType);
                this.sidesRight[this.recLevel] = false;
                ++this.recLevel;
                this.goLeft();
            }
        }

        private double onLeaf() {
            double[] dArray = this.recCurveStack[this.recLevel];
            int n2 = this.curveType;
            double d2 = 0.0;
            double d3 = dArray[0];
            double d4 = dArray[1];
            for (int i2 = 2; i2 < n2; i2 += 2) {
                double d5 = dArray[i2];
                double d6 = dArray[i2 + 1];
                double d7 = Helpers.linelen(d3, d4, d5, d6);
                d2 += d7;
                this.curLeafCtrlPolyLengths[(i2 >> 1) - 1] = d7;
                d3 = d5;
                d4 = d6;
            }
            double d8 = Helpers.linelen(dArray[0], dArray[1], d3, d4);
            if (d2 - d8 < CURVE_LEN_ERR || this.recLevel == 16) {
                return (d2 + d8) / 2.0;
            }
            return -1.0;
        }
    }
}

