/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageLoader;
import com.sun.javafx.iio.ImageLoaderFactory;
import com.sun.javafx.iio.ImageStorageException;
import com.sun.javafx.iio.bmp.BMPImageLoaderFactory;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.gif.GIFImageLoaderFactory;
import com.sun.javafx.iio.ios.IosImageLoaderFactory;
import com.sun.javafx.iio.jpeg.JPEGImageLoaderFactory;
import com.sun.javafx.iio.png.PNGImageLoaderFactory;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.DataURI;
import com.sun.javafx.util.Logging;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ImageStorage {
    private final HashMap<ImageFormatDescription.Signature, ImageLoaderFactory> loaderFactoriesBySignature;
    private final HashMap<String, ImageLoaderFactory> loaderFactoriesByMimeSubtype;
    private final ImageLoaderFactory[] loaderFactories = isIOS ? new ImageLoaderFactory[]{IosImageLoaderFactory.getInstance()} : new ImageLoaderFactory[]{GIFImageLoaderFactory.getInstance(), JPEGImageLoaderFactory.getInstance(), PNGImageLoaderFactory.getInstance(), BMPImageLoaderFactory.getInstance()};
    private int maxSignatureLength;
    private static final boolean isIOS = PlatformUtil.isIOS();

    public static ImageStorage getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public ImageStorage() {
        this.loaderFactoriesBySignature = new HashMap(this.loaderFactories.length);
        this.loaderFactoriesByMimeSubtype = new HashMap(this.loaderFactories.length);
        for (int i2 = 0; i2 < this.loaderFactories.length; ++i2) {
            this.addImageLoaderFactory(this.loaderFactories[i2]);
        }
    }

    public ImageFormatDescription[] getSupportedDescriptions() {
        ImageFormatDescription[] imageFormatDescriptionArray = new ImageFormatDescription[this.loaderFactories.length];
        for (int i2 = 0; i2 < this.loaderFactories.length; ++i2) {
            imageFormatDescriptionArray[i2] = this.loaderFactories[i2].getFormatDescription();
        }
        return imageFormatDescriptionArray;
    }

    public int getNumBands(ImageType imageType) {
        int n2 = -1;
        switch (imageType) {
            case GRAY: 
            case PALETTE: 
            case PALETTE_ALPHA: 
            case PALETTE_ALPHA_PRE: 
            case PALETTE_TRANS: {
                n2 = 1;
                break;
            }
            case GRAY_ALPHA: 
            case GRAY_ALPHA_PRE: {
                n2 = 2;
                break;
            }
            case RGB: {
                n2 = 3;
                break;
            }
            case RGBA: 
            case RGBA_PRE: {
                n2 = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ImageType " + imageType);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageLoaderFactory(ImageLoaderFactory imageLoaderFactory) {
        ImageFormatDescription imageFormatDescription = imageLoaderFactory.getFormatDescription();
        for (ImageFormatDescription.Signature object : imageFormatDescription.getSignatures()) {
            this.loaderFactoriesBySignature.put(object, imageLoaderFactory);
        }
        for (String string : imageFormatDescription.getMIMESubtypes()) {
            this.loaderFactoriesByMimeSubtype.put(string.toLowerCase(), imageLoaderFactory);
        }
        Class<ImageStorage> clazz = ImageStorage.class;
        synchronized (ImageStorage.class) {
            this.maxSignatureLength = -1;
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    public ImageFrame[] loadAll(InputStream inputStream, ImageLoadListener imageLoadListener, double d2, double d3, boolean bl2, float f2, boolean bl3) throws ImageStorageException {
        ImageFrame[] imageFrameArray;
        block8: {
            ImageLoader imageLoader = null;
            imageFrameArray = null;
            try {
                imageLoader = isIOS ? IosImageLoaderFactory.getInstance().createImageLoader(inputStream) : this.getLoaderBySignature(inputStream, imageLoadListener);
                if (imageLoader != null) {
                    imageFrameArray = this.loadAll(imageLoader, d2, d3, bl2, f2, bl3);
                    break block8;
                }
                throw new ImageStorageException("No loader for image data");
            }
            catch (ImageStorageException imageStorageException) {
                throw imageStorageException;
            }
            catch (IOException iOException) {
                throw new ImageStorageException(iOException.getMessage(), iOException);
            }
            finally {
                if (imageLoader != null) {
                    imageLoader.dispose();
                }
            }
        }
        return imageFrameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageFrame[] loadAll(String string, ImageLoadListener imageLoadListener, double d2, double d3, boolean bl2, float f2, boolean bl3) throws ImageStorageException {
        ImageFrame[] imageFrameArray;
        block24: {
            if (string == null || string.isEmpty()) {
                throw new ImageStorageException("URL can't be null or empty");
            }
            imageFrameArray = null;
            InputStream inputStream = null;
            ImageLoader imageLoader = null;
            try {
                float f3;
                block23: {
                    f3 = 1.0f;
                    try {
                        DataURI dataURI = DataURI.tryParse(string);
                        if (dataURI != null) {
                            if (!"image".equalsIgnoreCase(dataURI.getMimeType())) {
                                throw new IllegalArgumentException("Unexpected MIME type: " + dataURI.getMimeType());
                            }
                            ImageLoaderFactory imageLoaderFactory = this.loaderFactoriesByMimeSubtype.get(dataURI.getMimeSubtype().toLowerCase());
                            if (imageLoaderFactory == null) {
                                throw new IllegalArgumentException("Unsupported MIME subtype: image/" + dataURI.getMimeSubtype());
                            }
                            inputStream = new ByteArrayInputStream(dataURI.getData());
                            ImageLoader imageLoader2 = this.getLoaderBySignature(inputStream, imageLoadListener);
                            if (imageLoader2 != null) {
                                PlatformLogger platformLogger;
                                boolean bl4;
                                boolean bl5 = bl4 = !imageLoaderFactory.getFormatDescription().getFormatName().equals(imageLoader2.getFormatDescription().getFormatName());
                                if (bl4 && (platformLogger = Logging.getJavaFXLogger()).isLoggable(PlatformLogger.Level.WARNING)) {
                                    platformLogger.warning(String.format("Image format '%s' does not match MIME type '%s/%s' in URI '%s'", imageLoader2.getFormatDescription().getFormatName(), dataURI.getMimeType(), dataURI.getMimeSubtype(), dataURI));
                                }
                                imageLoader = imageLoader2;
                            } else {
                                inputStream.close();
                                inputStream = new ByteArrayInputStream(dataURI.getData());
                                imageLoader = imageLoaderFactory.createImageLoader(inputStream);
                            }
                            break block23;
                        }
                        if (f2 >= 1.5f) {
                            try {
                                String string2 = ImageTools.getScaledImageName(string);
                                inputStream = ImageTools.createInputStream(string2);
                                f3 = 2.0f;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (inputStream == null) {
                            inputStream = ImageTools.createInputStream(string);
                        }
                        imageLoader = isIOS ? IosImageLoaderFactory.getInstance().createImageLoader(inputStream) : this.getLoaderBySignature(inputStream, imageLoadListener);
                    }
                    catch (Exception exception) {
                        throw new ImageStorageException(exception.getMessage(), exception);
                    }
                }
                if (imageLoader != null) {
                    imageFrameArray = this.loadAll(imageLoader, d2, d3, bl2, f3, bl3);
                    break block24;
                }
                throw new ImageStorageException("No loader for image data");
            }
            finally {
                if (imageLoader != null) {
                    imageLoader.dispose();
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return imageFrameArray;
    }

    private synchronized int getMaxSignatureLength() {
        if (this.maxSignatureLength < 0) {
            this.maxSignatureLength = 0;
            for (ImageFormatDescription.Signature signature : this.loaderFactoriesBySignature.keySet()) {
                int n2 = signature.getLength();
                if (this.maxSignatureLength >= n2) continue;
                this.maxSignatureLength = n2;
            }
        }
        return this.maxSignatureLength;
    }

    private ImageFrame[] loadAll(ImageLoader imageLoader, double d2, double d3, boolean bl2, float f2, boolean bl3) throws ImageStorageException {
        ImageFrame[] imageFrameArray = null;
        ArrayList<ImageFrame> arrayList = new ArrayList<ImageFrame>();
        int n2 = 0;
        ImageFrame imageFrame = null;
        int n3 = (int)Math.round(d2 * (double)f2);
        int n4 = (int)Math.round(d3 * (double)f2);
        while (true) {
            try {
                imageFrame = imageLoader.load(n2++, n3, n4, bl2, bl3);
            }
            catch (Exception exception) {
                if (n2 > 1) break;
                throw new ImageStorageException(exception.getMessage(), exception);
            }
            if (imageFrame == null) break;
            imageFrame.setPixelScale(f2);
            arrayList.add(imageFrame);
        }
        int n5 = arrayList.size();
        if (n5 > 0) {
            imageFrameArray = new ImageFrame[n5];
            arrayList.toArray(imageFrameArray);
        }
        return imageFrameArray;
    }

    private ImageLoader getLoaderBySignature(InputStream inputStream, ImageLoadListener imageLoadListener) throws IOException {
        byte[] byArray = new byte[this.getMaxSignatureLength()];
        try {
            ImageTools.readFully(inputStream, byArray);
        }
        catch (EOFException eOFException) {
            return null;
        }
        for (Map.Entry<ImageFormatDescription.Signature, ImageLoaderFactory> entry : this.loaderFactoriesBySignature.entrySet()) {
            if (!entry.getKey().matches(byArray)) continue;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            SequenceInputStream sequenceInputStream = new SequenceInputStream(byteArrayInputStream, inputStream);
            ImageLoader imageLoader = entry.getValue().createImageLoader(sequenceInputStream);
            if (imageLoadListener != null) {
                imageLoader.addListener(imageLoadListener);
            }
            return imageLoader;
        }
        return null;
    }

    private static class InstanceHolder {
        static final ImageStorage INSTANCE = new ImageStorage();

        private InstanceHolder() {
        }
    }

    public static enum ImageType {
        GRAY,
        GRAY_ALPHA,
        GRAY_ALPHA_PRE,
        PALETTE,
        PALETTE_ALPHA,
        PALETTE_ALPHA_PRE,
        PALETTE_TRANS,
        RGB,
        RGBA,
        RGBA_PRE;

    }
}

