/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.PrismFontFactory;
import java.util.Map;

class WindowsFontMap {
    private static Map<String, FamilyDescription> PLATFORM_FONT_MAP;

    WindowsFontMap() {
    }

    private static void populateHardcodedFileNameMap() {
        FamilyDescription familyDescription = new FamilyDescription();
        familyDescription.familyName = "Segoe UI";
        familyDescription.plainFullName = "Segoe UI";
        familyDescription.plainFileName = "segoeui.ttf";
        familyDescription.boldFullName = "Segoe UI Bold";
        familyDescription.boldFileName = "segoeuib.ttf";
        familyDescription.italicFullName = "Segoe UI Italic";
        familyDescription.italicFileName = "segoeuii.ttf";
        familyDescription.boldItalicFullName = "Segoe UI Bold Italic";
        familyDescription.boldItalicFileName = "segoeuiz.ttf";
        FamilyDescription familyDescription2 = new FamilyDescription();
        familyDescription2.familyName = "Tahoma";
        familyDescription2.plainFullName = "Tahoma";
        familyDescription2.plainFileName = "tahoma.ttf";
        familyDescription2.boldFullName = "Tahoma Bold";
        familyDescription2.boldFileName = "tahomabd.ttf";
        FamilyDescription familyDescription3 = new FamilyDescription();
        familyDescription3.familyName = "Verdana";
        familyDescription3.plainFullName = "Verdana";
        familyDescription3.plainFileName = "verdana.TTF";
        familyDescription3.boldFullName = "Verdana Bold";
        familyDescription3.boldFileName = "verdanab.TTF";
        familyDescription3.italicFullName = "Verdana Italic";
        familyDescription3.italicFileName = "verdanai.TTF";
        familyDescription3.boldItalicFullName = "Verdana Bold Italic";
        familyDescription3.boldItalicFileName = "verdanaz.TTF";
        FamilyDescription familyDescription4 = new FamilyDescription();
        familyDescription4.familyName = "Arial";
        familyDescription4.plainFullName = "Arial";
        familyDescription4.plainFileName = "ARIAL.TTF";
        familyDescription4.boldFullName = "Arial Bold";
        familyDescription4.boldFileName = "ARIALBD.TTF";
        familyDescription4.italicFullName = "Arial Italic";
        familyDescription4.italicFileName = "ARIALI.TTF";
        familyDescription4.boldItalicFullName = "Arial Bold Italic";
        familyDescription4.boldItalicFileName = "ARIALBI.TTF";
        FamilyDescription familyDescription5 = new FamilyDescription();
        familyDescription5.familyName = "Times New Roman";
        familyDescription5.plainFullName = "Times New Roman";
        familyDescription5.plainFileName = "times.ttf";
        familyDescription5.boldFullName = "Times New Roman Bold";
        familyDescription5.boldFileName = "timesbd.ttf";
        familyDescription5.italicFullName = "Times New Roman Italic";
        familyDescription5.italicFileName = "timesi.ttf";
        familyDescription5.boldItalicFullName = "Times New Roman Bold Italic";
        familyDescription5.boldItalicFileName = "timesbi.ttf";
        FamilyDescription familyDescription6 = new FamilyDescription();
        familyDescription6.familyName = "Courier New";
        familyDescription6.plainFullName = "Courier New";
        familyDescription6.plainFileName = "cour.ttf";
        familyDescription6.boldFullName = "Courier New Bold";
        familyDescription6.boldFileName = "courbd.ttf";
        familyDescription6.italicFullName = "Courier New Italic";
        familyDescription6.italicFileName = "couri.ttf";
        familyDescription6.boldItalicFullName = "Courier New Bold Italic";
        familyDescription6.boldItalicFileName = "courbi.ttf";
        PLATFORM_FONT_MAP = Map.of("segoe", familyDescription, "tahoma", familyDescription2, "verdana", familyDescription3, "arial", familyDescription4, "times", familyDescription5, "courier", familyDescription6);
    }

    static String getPathName(String string) {
        return PrismFontFactory.getPathNameWindows(string);
    }

    static String findFontFile(String string, int n2) {
        FamilyDescription familyDescription;
        if (PLATFORM_FONT_MAP == null) {
            WindowsFontMap.populateHardcodedFileNameMap();
        }
        if (PLATFORM_FONT_MAP == null || PLATFORM_FONT_MAP.size() == 0) {
            return null;
        }
        int n3 = string.indexOf(32);
        String string2 = string;
        if (n3 > 0) {
            string2 = string.substring(0, n3);
        }
        if ((familyDescription = PLATFORM_FONT_MAP.get(string2)) == null) {
            return null;
        }
        String string3 = null;
        if (n2 < 0) {
            if (string.equalsIgnoreCase(familyDescription.plainFullName)) {
                string3 = familyDescription.plainFileName;
            } else if (string.equalsIgnoreCase(familyDescription.boldFullName)) {
                string3 = familyDescription.boldFileName;
            } else if (string.equalsIgnoreCase(familyDescription.italicFullName)) {
                string3 = familyDescription.italicFileName;
            } else if (string.equalsIgnoreCase(familyDescription.boldItalicFullName)) {
                string3 = familyDescription.boldItalicFileName;
            }
            if (string3 != null) {
                return WindowsFontMap.getPathName(string3);
            }
            return null;
        }
        if (!string.equalsIgnoreCase(familyDescription.familyName)) {
            return null;
        }
        switch (n2) {
            case 0: {
                string3 = familyDescription.plainFileName;
                break;
            }
            case 1: {
                string3 = familyDescription.boldFileName;
                if (string3 != null) break;
                string3 = familyDescription.plainFileName;
                break;
            }
            case 2: {
                string3 = familyDescription.italicFileName;
                if (string3 != null) break;
                string3 = familyDescription.plainFileName;
                break;
            }
            case 3: {
                string3 = familyDescription.boldItalicFileName;
                if (string3 == null) {
                    string3 = familyDescription.italicFileName;
                }
                if (string3 == null) {
                    string3 = familyDescription.boldFileName;
                }
                if (string3 != null) break;
                string3 = familyDescription.plainFileName;
            }
        }
        if (string3 != null) {
            return WindowsFontMap.getPathName(string3);
        }
        return null;
    }

    private static class FamilyDescription {
        private String familyName;
        private String plainFullName;
        private String boldFullName;
        private String italicFullName;
        private String boldItalicFullName;
        private String plainFileName;
        private String boldFileName;
        private String italicFileName;
        private String boldItalicFileName;

        private FamilyDescription() {
        }
    }
}

