/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.InternalFormattedDiffCommandStep$DiffFormat;
import com.datical.liquibase.ext.diff.FormattedChangeObject;
import com.datical.liquibase.ext.diff.FormattedDiffDatabase;
import com.datical.liquibase.ext.diff.FormattedDiffDatabases;
import com.datical.liquibase.ext.diff.FormattedDiffModel;
import com.datical.liquibase.ext.diff.FormattedDiffObject;
import com.datical.liquibase.ext.diff.FormattedDiffSerializer;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResults;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.DiffCommandStep;
import liquibase.command.core.InternalDiffCommandStep;
import liquibase.database.Database;
import liquibase.diff.DiffResult;
import liquibase.diff.Difference;
import liquibase.diff.StringDiff;
import liquibase.license.LicenseServiceUtils;
import liquibase.structure.DatabaseObject;

public class InternalFormattedDiffCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"internalFormattedDiff"};
    public static final CommandArgumentDefinition<InternalFormattedDiffCommandStep$DiffFormat> FORMAT_ARG;
    public static final CommandArgumentDefinition<CommandScope> DIFF_COMMAND_ARG;

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setInternal(true);
    }

    @Override
    public int getOrder(CommandDefinition commandDefinition) {
        int n2 = super.getOrder(commandDefinition);
        if (n2 < 0) {
            return n2;
        }
        return 101;
    }

    @Override
    public void validate(CommandScope commandScope) {
        super.validate(commandScope);
    }

    @Override
    public void run(CommandResultsBuilder commandResultsBuilder) {
        Object object = commandResultsBuilder.getCommandScope();
        CommandScope object22 = ((CommandScope)object).getArgumentValue(DIFF_COMMAND_ARG);
        if ((object = ((CommandScope)object).getArgumentValue(FORMAT_ARG)) == InternalFormattedDiffCommandStep$DiffFormat.JSON) {
            LicenseServiceUtils.checkProLicenseAndThrowException(DiffCommandStep.COMMAND_NAME);
        }
        object = object != InternalFormattedDiffCommandStep$DiffFormat.JSON;
        object22.addArgumentValue(InternalDiffCommandStep.PRINT_RESULT, object);
        CommandResults commandResults = object22.execute();
        if (((Boolean)object).booleanValue()) {
            for (Map.Entry entry : commandResults.getResults().entrySet()) {
                commandResultsBuilder.addResult((String)entry.getKey(), entry.getValue());
            }
            return;
        }
        object = (DiffResult)commandResults.getResult("diffResult");
        String string = this.createJsonOutput((DiffResult)object);
        commandResultsBuilder.getOutputStream().write(string.getBytes());
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    private static boolean validateDiffFormat(String string) {
        InternalFormattedDiffCommandStep$DiffFormat[] internalFormattedDiffCommandStep$DiffFormatArray = InternalFormattedDiffCommandStep$DiffFormat.values();
        int n2 = internalFormattedDiffCommandStep$DiffFormatArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!internalFormattedDiffCommandStep$DiffFormatArray[i2].toString().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private String createJsonOutput(DiffResult diffResult) {
        Iterator iterator = diffResult.getComparisonSnapshot().getDatabase();
        Database iterator22 = diffResult.getReferenceSnapshot().getDatabase();
        String string = iterator.getConnection().getURL();
        iterator = iterator.getDatabaseProductName();
        Object object = diffResult.getProductVersionDiff();
        String string2 = ((StringDiff)object).getTargetVersion();
        String string3 = iterator22.getConnection().getURL();
        String string4 = iterator22.getDatabaseProductName();
        object = ((StringDiff)object).getReferenceVersion();
        FormattedDiffModel formattedDiffModel = new FormattedDiffModel();
        new FormattedDiffModel().created = new Date().toString();
        formattedDiffModel.databases = new FormattedDiffDatabases();
        formattedDiffModel.databases.reference = new FormattedDiffDatabase();
        formattedDiffModel.databases.reference.name = string4;
        formattedDiffModel.databases.reference.majorVersion = "";
        if (object != null) {
            this.assignVersionInfo((String)object, "reference", formattedDiffModel);
        }
        formattedDiffModel.databases.reference.url = string3;
        formattedDiffModel.databases.target = new FormattedDiffDatabase();
        formattedDiffModel.databases.target.name = iterator;
        formattedDiffModel.databases.target.majorVersion = "";
        formattedDiffModel.databases.target.minorVersion = "";
        if (string2 != null) {
            this.assignVersionInfo((String)object, "target", formattedDiffModel);
        }
        formattedDiffModel.databases.target.url = string;
        for (DatabaseObject databaseObject : diffResult.getMissingObjects()) {
            FormattedDiffObject formattedDiffObject = new FormattedDiffObject(databaseObject, "missingObject");
            formattedDiffModel.missingObjects.add(formattedDiffObject);
        }
        for (DatabaseObject databaseObject : diffResult.getUnexpectedObjects()) {
            FormattedDiffObject formattedDiffObject = new FormattedDiffObject(databaseObject, "unexpectedObject");
            formattedDiffModel.unexpectedObjects.add(formattedDiffObject);
        }
        for (DatabaseObject databaseObject : diffResult.getChangedObjects().keySet()) {
            iterator = diffResult.getChangedObjects().get(databaseObject).getDifferences();
            DatabaseObject databaseObject2 = diffResult.getComparisonSnapshot().get(databaseObject);
            FormattedDiffObject formattedDiffObject = new FormattedDiffObject(databaseObject2, "");
            FormattedChangeObject formattedChangeObject = new FormattedChangeObject(formattedDiffObject);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object = (Difference)iterator.next();
                formattedChangeObject.differences.add((Difference)object);
            }
            formattedDiffModel.changedObjects.add(formattedChangeObject);
        }
        return new FormattedDiffSerializer().serialize(formattedDiffModel, true).replaceAll("!!com.datical.liquibase.[^\\s]+ (.*)", "$1");
    }

    private String[] assignVersionInfo(String stringArray, String string, FormattedDiffModel formattedDiffModel) {
        String string2;
        if (stringArray == null) {
            return new String[0];
        }
        stringArray = stringArray.split("\\.");
        String string3 = stringArray[0];
        String string4 = string2 = stringArray.length > 1 ? stringArray[1] : "";
        if (string.equals("reference")) {
            formattedDiffModel.databases.reference.majorVersion = string3;
            formattedDiffModel.databases.reference.minorVersion = string2;
        } else {
            formattedDiffModel.databases.target.majorVersion = string3;
            formattedDiffModel.databases.target.minorVersion = string2;
        }
        return stringArray;
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        FORMAT_ARG = commandBuilder.argument("format", InternalFormattedDiffCommandStep$DiffFormat.class).defaultValue(InternalFormattedDiffCommandStep$DiffFormat.TXT).setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (object instanceof InternalFormattedDiffCommandStep$DiffFormat) {
                return (InternalFormattedDiffCommandStep$DiffFormat)((Object)((Object)object));
            }
            if (!InternalFormattedDiffCommandStep.validateDiffFormat((String)(object = String.valueOf(object)))) {
                object = "\nWARNING: The diff command optional Pro parameter '--format' currently supports only 'TXT' or 'JSON' as values.  (Blank defaults to 'TXT')";
                throw new IllegalArgumentException((String)object);
            }
            if (!((String)object).toUpperCase().equals(InternalFormattedDiffCommandStep$DiffFormat.JSON.toString())) {
                return InternalFormattedDiffCommandStep$DiffFormat.TXT;
            }
            return InternalFormattedDiffCommandStep$DiffFormat.JSON;
        }).build();
        DIFF_COMMAND_ARG = commandBuilder.argument("diffCommand", CommandScope.class).required().build();
    }
}

