/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PGtokenizer {
    private static final Map<Character, Character> CLOSING_TO_OPENING_CHARACTER = new HashMap<Character, Character>();
    protected List<String> tokens = new ArrayList<String>();

    public PGtokenizer(String string, char delim) {
        this.tokenize(string, delim);
    }

    public int tokenize(String string, char delim) {
        this.tokens.clear();
        ArrayDeque<Character> stack = new ArrayDeque<Character>();
        boolean skipChar = false;
        boolean nestedDoubleQuote = false;
        char c2 = '\u0000';
        int s2 = 0;
        for (int p2 = 0; p2 < string.length(); ++p2) {
            c2 = string.charAt(p2);
            if (c2 == '(' || c2 == '[' || c2 == '<' || !nestedDoubleQuote && !skipChar && c2 == '\"') {
                stack.push(Character.valueOf(c2));
                if (c2 == '\"') {
                    nestedDoubleQuote = true;
                    skipChar = true;
                }
            }
            if (c2 == ')' || c2 == ']' || c2 == '>' || nestedDoubleQuote && !skipChar && c2 == '\"') {
                if (c2 == '\"') {
                    while (!stack.isEmpty() && !Character.valueOf('\"').equals(stack.peek())) {
                        stack.pop();
                    }
                    nestedDoubleQuote = false;
                    stack.pop();
                } else {
                    Character ch2 = CLOSING_TO_OPENING_CHARACTER.get(Character.valueOf(c2));
                    if (!stack.isEmpty() && ch2 != null && ch2.equals(stack.peek())) {
                        stack.pop();
                    }
                }
            }
            boolean bl2 = skipChar = c2 == '\\';
            if (!stack.isEmpty() || c2 != delim) continue;
            this.tokens.add(string.substring(s2, p2));
            s2 = p2 + 1;
        }
        if (s2 < string.length()) {
            this.tokens.add(string.substring(s2));
        }
        if (s2 == string.length() && c2 == delim) {
            this.tokens.add("");
        }
        return this.tokens.size();
    }

    public int getSize() {
        return this.tokens.size();
    }

    public String getToken(int n2) {
        return this.tokens.get(n2);
    }

    public PGtokenizer tokenizeToken(int n2, char delim) {
        return new PGtokenizer(this.getToken(n2), delim);
    }

    public static String remove(String s2, String l2, String t2) {
        if (s2.startsWith(l2)) {
            s2 = s2.substring(l2.length());
        }
        if (s2.endsWith(t2)) {
            s2 = s2.substring(0, s2.length() - t2.length());
        }
        return s2;
    }

    public void remove(String l2, String t2) {
        for (int i2 = 0; i2 < this.tokens.size(); ++i2) {
            this.tokens.set(i2, PGtokenizer.remove(this.tokens.get(i2), l2, t2));
        }
    }

    public static String removePara(String s2) {
        return PGtokenizer.remove(s2, "(", ")");
    }

    public void removePara() {
        this.remove("(", ")");
    }

    public static String removeBox(String s2) {
        return PGtokenizer.remove(s2, "[", "]");
    }

    public void removeBox() {
        this.remove("[", "]");
    }

    public static String removeAngle(String s2) {
        return PGtokenizer.remove(s2, "<", ">");
    }

    public void removeAngle() {
        this.remove("<", ">");
    }

    public static String removeCurlyBrace(String s2) {
        return PGtokenizer.remove(s2, "{", "}");
    }

    public void removeCurlyBrace() {
        this.remove("{", "}");
    }

    static {
        CLOSING_TO_OPENING_CHARACTER.put(Character.valueOf(')'), Character.valueOf('('));
        CLOSING_TO_OPENING_CHARACTER.put(Character.valueOf(']'), Character.valueOf('['));
        CLOSING_TO_OPENING_CHARACTER.put(Character.valueOf('>'), Character.valueOf('<'));
        CLOSING_TO_OPENING_CHARACTER.put(Character.valueOf('\"'), Character.valueOf('\"'));
    }
}

