/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;

public class PGpolygon
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint @Nullable [] points;

    public PGpolygon(PGpoint[] points) {
        this();
        this.points = points;
    }

    public PGpolygon(String s2) throws SQLException {
        this();
        this.setValue(s2);
    }

    public PGpolygon() {
        this.type = "polygon";
    }

    @Override
    public void setValue(@Nullable String s2) throws SQLException {
        if (s2 == null) {
            this.points = null;
            return;
        }
        PGtokenizer t2 = new PGtokenizer(PGtokenizer.removePara(s2), ',');
        int npoints = t2.getSize();
        PGpoint[] points = this.points;
        if (points == null || points.length != npoints) {
            this.points = points = new PGpoint[npoints];
        }
        for (int p2 = 0; p2 < npoints; ++p2) {
            points[p2] = new PGpoint(t2.getToken(p2));
        }
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof PGpolygon) {
            PGpolygon p2 = (PGpolygon)obj;
            PGpoint[] points = this.points;
            PGpoint[] pPoints = p2.points;
            if (points == null) {
                return pPoints == null;
            }
            if (pPoints == null) {
                return false;
            }
            if (pPoints.length != points.length) {
                return false;
            }
            for (int i2 = 0; i2 < points.length; ++i2) {
                if (points[i2].equals(pPoints[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        PGpoint[] points = this.points;
        if (points == null) {
            return hash;
        }
        for (int i2 = 0; i2 < points.length && i2 < 5; ++i2) {
            hash = hash * 31 + points[i2].hashCode();
        }
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PGpolygon newPGpolygon = (PGpolygon)super.clone();
        if (newPGpolygon.points != null) {
            PGpoint[] newPoints = (PGpoint[])newPGpolygon.points.clone();
            newPGpolygon.points = newPoints;
            for (int i2 = 0; i2 < newPGpolygon.points.length; ++i2) {
                if (newPGpolygon.points[i2] == null) continue;
                newPoints[i2] = (PGpoint)newPGpolygon.points[i2].clone();
            }
        }
        return newPGpolygon;
    }

    @Override
    public @Nullable String getValue() {
        PGpoint[] points = this.points;
        if (points == null) {
            return null;
        }
        StringBuilder b2 = new StringBuilder();
        b2.append("(");
        for (int p2 = 0; p2 < points.length; ++p2) {
            if (p2 > 0) {
                b2.append(",");
            }
            b2.append(points[p2].toString());
        }
        b2.append(")");
        return b2.toString();
    }
}

