/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.xml;

import org.jooq.Name;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractRoutineDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultParameterDefinition;
import org.jooq.meta.InOutDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.tools.StringUtils;
import org.jooq.util.xml.jaxb.InformationSchema;
import org.jooq.util.xml.jaxb.Parameter;
import org.jooq.util.xml.jaxb.Routine;

public class XMLRoutineDefinition
extends AbstractRoutineDefinition {
    private final InformationSchema info;
    private final Name specificName;

    public XMLRoutineDefinition(SchemaDefinition schema, PackageDefinition pkg, InformationSchema info, Routine routine) {
        this(schema, pkg, info, routine, "");
    }

    public XMLRoutineDefinition(SchemaDefinition schema, PackageDefinition pkg, InformationSchema info, Routine routine, String comment) {
        super(schema, pkg, routine.getRoutineName(), comment, XMLRoutineDefinition.overload(info, routine));
        this.info = info;
        this.specificName = DSL.name(routine.getSpecificCatalog(), routine.getSpecificSchema(), routine.getSpecificPackage(), routine.getSpecificName());
        if (!StringUtils.isBlank(routine.getDataType())) {
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), schema, routine.getDataType(), (Number)routine.getCharacterMaximumLength(), (Number)routine.getNumericPrecision(), (Number)routine.getNumericScale(), null, (String)null);
            this.returnValue = new DefaultParameterDefinition(this, "RETURN_VALUE", -1, type);
        }
    }

    private static String overload(InformationSchema info, Routine routine) {
        Name routineName = DSL.name(routine.getRoutineCatalog(), routine.getRoutineSchema(), routine.getRoutinePackage(), routine.getRoutineName());
        String result = null;
        int count = 0;
        for (Routine r2 : info.getRoutines()) {
            Name rName = DSL.name(r2.getRoutineCatalog(), r2.getRoutineSchema(), r2.getRoutinePackage(), r2.getRoutineName());
            if (!routineName.equals(rName)) continue;
            ++count;
            if (routine == r2) {
                result = "" + count;
            }
            if (count <= 1 || result == null) continue;
            break;
        }
        return count > 1 ? result : null;
    }

    @Override
    protected void init0() {
        for (Parameter parameter : this.info.getParameters()) {
            Name parameterRoutineName = DSL.name(parameter.getSpecificCatalog(), parameter.getSpecificSchema(), parameter.getSpecificPackage(), parameter.getSpecificName());
            if (!this.specificName.equals(parameterRoutineName)) continue;
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), parameter.getDataType(), (Number)parameter.getCharacterMaximumLength(), (Number)parameter.getNumericPrecision(), (Number)parameter.getNumericScale(), null, parameter.getParameterDefault());
            DefaultParameterDefinition p2 = new DefaultParameterDefinition(this, parameter.getParameterName(), parameter.getOrdinalPosition(), type, !StringUtils.isBlank(parameter.getParameterDefault()), StringUtils.isBlank(parameter.getParameterName()), parameter.getComment());
            switch (parameter.getParameterMode()) {
                case IN: {
                    this.addParameter(InOutDefinition.IN, p2);
                    break;
                }
                case INOUT: {
                    this.addParameter(InOutDefinition.INOUT, p2);
                    break;
                }
                case OUT: {
                    this.addParameter(InOutDefinition.OUT, p2);
                }
            }
        }
    }
}

