/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jooq.DSLContext;
import org.jooq.FilePattern;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.SortOrder;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.xml.XMLPackageDefinition;
import org.jooq.meta.xml.XMLRoutineDefinition;
import org.jooq.meta.xml.XMLTableDefinition;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.util.jaxb.tools.MiniJAXB;
import org.jooq.util.xml.jaxb.CheckConstraint;
import org.jooq.util.xml.jaxb.Index;
import org.jooq.util.xml.jaxb.IndexColumnUsage;
import org.jooq.util.xml.jaxb.InformationSchema;
import org.jooq.util.xml.jaxb.KeyColumnUsage;
import org.jooq.util.xml.jaxb.ReferentialConstraint;
import org.jooq.util.xml.jaxb.Routine;
import org.jooq.util.xml.jaxb.Schema;
import org.jooq.util.xml.jaxb.Sequence;
import org.jooq.util.xml.jaxb.Table;
import org.jooq.util.xml.jaxb.TableConstraint;
import org.jooq.util.xml.jaxb.TableConstraintType;
import org.jooq.util.xml.jaxb.View;

public class XMLDatabase
extends AbstractDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(XMLDatabase.class);
    InformationSchema info;

    private InformationSchema info() {
        if (this.info == null) {
            this.info = new InformationSchema();
            String xml = this.getProperties().getProperty("xmlFiles", this.getProperties().getProperty("xmlFile", this.getProperties().getProperty("xml-file")));
            String xsl = this.getProperties().getProperty("xslFile", this.getProperties().getProperty("xsl-file"));
            String sort = this.getProperties().getProperty("sort", "semantic").toLowerCase();
            if (xml == null) {
                throw new RuntimeException("Must provide an xmlFile property");
            }
            try {
                new FilePattern().basedir(new File(this.getBasedir())).pattern(xml).sort(FilePattern.Sort.of(sort)).load(source -> {
                    String content;
                    block14: {
                        Reader reader = null;
                        try {
                            if (StringUtils.isBlank(xsl)) {
                                content = source.readString();
                                try {
                                    XMLStreamReader xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(content));
                                    String encoding = xmlReader.getCharacterEncodingScheme();
                                    if (encoding != null && !"UTF-8".equals(encoding)) {
                                        content = new String(content.getBytes("UTF-8"), encoding);
                                    }
                                    break block14;
                                }
                                catch (XMLStreamException e1) {
                                    log.warn("Could not open XML Stream: " + e1.getMessage());
                                }
                                catch (UnsupportedEncodingException e2) {
                                    log.warn("Unsupported encoding: " + e2.getMessage());
                                }
                                break block14;
                            }
                            InputStream xslIs = null;
                            try {
                                log.info((Object)"Using XSL file", xsl);
                                xslIs = XMLDatabase.class.getResourceAsStream(xsl);
                                if (xslIs == null) {
                                    xslIs = new FileInputStream(xsl);
                                }
                                StringWriter writer = new StringWriter();
                                TransformerFactory factory = TransformerFactory.newInstance();
                                Transformer transformer = factory.newTransformer(new StreamSource(xslIs));
                                transformer.transform(new StreamSource(reader), new StreamResult(writer));
                                content = writer.getBuffer().toString();
                            }
                            catch (IOException e3) {
                                try {
                                    throw new org.jooq.exception.IOException("Error while loading XSL file", e3);
                                    catch (TransformerException e4) {
                                        throw new RuntimeException("Error while transforming XML file " + xml + " with XSL file " + xsl, e4);
                                    }
                                }
                                catch (Throwable throwable) {
                                    JDBCUtils.safeClose(xslIs);
                                    throw throwable;
                                }
                            }
                            JDBCUtils.safeClose(xslIs);
                        }
                        finally {
                            JDBCUtils.safeClose(reader);
                        }
                    }
                    content = content.replaceAll("<(\\w+:)?information_schema xmlns(:\\w+)?=\"http://www.jooq.org/xsd/jooq-meta-\\d+\\.\\d+\\.\\d+.xsd\">", "<$1information_schema xmlns$2=\"http://www.jooq.org/xsd/jooq-meta-3.16.0.xsd\">");
                    content = content.replace("<information_schema>", "<information_schema xmlns=\"http://www.jooq.org/xsd/jooq-meta-3.16.0.xsd\">");
                    this.info = MiniJAXB.append(this.info, MiniJAXB.unmarshal(content, InformationSchema.class));
                });
            }
            catch (Exception e2) {
                throw new RuntimeException("Error while opening files " + xml + " or " + xsl, e2);
            }
        }
        return this.info;
    }

    @Override
    protected DSLContext create0() {
        SQLDialect dialect = SQLDialect.DEFAULT;
        try {
            dialect = SQLDialect.valueOf(this.getProperties().getProperty("dialect"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DSL.using(dialect.family());
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        final HashMap<Name, SortedSet> indexColumnUsage = new HashMap<Name, SortedSet>();
        for (IndexColumnUsage ic2 : this.info().getIndexColumnUsages()) {
            Name name = DSL.name(ic2.getIndexCatalog(), ic2.getIndexSchema(), ic2.getTableName(), ic2.getIndexName());
            SortedSet list = indexColumnUsage.computeIfAbsent(name, k2 -> new TreeSet((o1, o2) -> {
                int r2 = 0;
                r2 = StringUtils.defaultIfNull(o1.getIndexCatalog(), "").compareTo(StringUtils.defaultIfNull(o2.getIndexCatalog(), ""));
                if (r2 != 0) {
                    return r2;
                }
                r2 = StringUtils.defaultIfNull(o1.getIndexSchema(), "").compareTo(StringUtils.defaultIfNull(o2.getIndexSchema(), ""));
                if (r2 != 0) {
                    return r2;
                }
                r2 = StringUtils.defaultIfNull(o1.getTableName(), "").compareTo(StringUtils.defaultIfNull(o2.getTableName(), ""));
                if (r2 != 0) {
                    return r2;
                }
                r2 = StringUtils.defaultIfNull(o1.getIndexName(), "").compareTo(StringUtils.defaultIfNull(o2.getIndexName(), ""));
                if (r2 != 0) {
                    return r2;
                }
                return Integer.compare(o1.getOrdinalPosition(), o2.getOrdinalPosition());
            }));
            list.add(ic2);
        }
        for (Index i2 : this.info().getIndexes()) {
            SchemaDefinition schema;
            TableDefinition table;
            if (!this.getInputSchemata().contains(i2.getTableSchema()) || (table = this.getTable(schema = this.getSchema(i2.getTableSchema()), i2.getTableName())) == null) continue;
            final Name name = DSL.name(i2.getIndexCatalog(), i2.getIndexSchema(), i2.getTableName(), i2.getIndexName());
            AbstractIndexDefinition index = new AbstractIndexDefinition(schema, i2.getIndexName(), table, Boolean.TRUE.equals(i2.isIsUnique()), i2.getComment()){
                private final List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name3, table2, unique, comment);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    SortedSet list = (SortedSet)indexColumnUsage.get(name);
                    if (list != null) {
                        for (IndexColumnUsage ic2 : list) {
                            ColumnDefinition column = table.getColumn(ic2.getColumnName());
                            if (column != null) {
                                this.indexColumns.add(new DefaultIndexColumnDefinition(this, column, Boolean.TRUE.equals(ic2.isIsDescending()) ? SortOrder.DESC : SortOrder.ASC, ic2.getOrdinalPosition()));
                                continue;
                            }
                            log.error(String.format("Column %s not found in table %s.", ic2.getColumnName(), table));
                        }
                    } else {
                        log.error(String.format("No columns found for index %s.", name));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            };
            result.add(index);
        }
        return result;
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) {
        for (KeyColumnUsage usage : this.keyColumnUsage(TableConstraintType.PRIMARY_KEY)) {
            SchemaDefinition schema = this.getSchema(usage.getConstraintSchema());
            String key = usage.getConstraintName();
            String tableName = usage.getTableName();
            String columnName = usage.getColumnName();
            TableConstraint tc = this.tableConstraint(usage.getConstraintCatalog(), usage.getConstraintSchema(), usage.getConstraintName());
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table, table.getColumn(columnName), tc != null && !Boolean.FALSE.equals(tc.isEnforced()));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) {
        for (KeyColumnUsage usage : this.keyColumnUsage(TableConstraintType.UNIQUE)) {
            SchemaDefinition schema = this.getSchema(usage.getConstraintSchema());
            String key = usage.getConstraintName();
            String tableName = usage.getTableName();
            String columnName = usage.getColumnName();
            TableConstraint tc = this.tableConstraint(usage.getConstraintCatalog(), usage.getConstraintSchema(), usage.getConstraintName());
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table, table.getColumn(columnName), tc != null && !Boolean.FALSE.equals(tc.isEnforced()));
        }
    }

    private List<KeyColumnUsage> keyColumnUsage(TableConstraintType constraintType) {
        ArrayList<KeyColumnUsage> result = new ArrayList<KeyColumnUsage>();
        for (TableConstraint constraint : this.info().getTableConstraints()) {
            if (constraintType != constraint.getConstraintType() || !this.getInputSchemata().contains(constraint.getConstraintSchema())) continue;
            for (KeyColumnUsage usage : this.info().getKeyColumnUsages()) {
                if (!StringUtils.equals(StringUtils.defaultIfNull(constraint.getConstraintCatalog(), ""), StringUtils.defaultIfNull(usage.getConstraintCatalog(), "")) || !StringUtils.equals(StringUtils.defaultIfNull(constraint.getConstraintSchema(), ""), StringUtils.defaultIfNull(usage.getConstraintSchema(), "")) || !StringUtils.equals(StringUtils.defaultIfNull(constraint.getConstraintName(), ""), StringUtils.defaultIfNull(usage.getConstraintName(), ""))) continue;
                result.add(usage);
            }
        }
        result.sort((o1, o2) -> {
            int r2 = 0;
            r2 = StringUtils.defaultIfNull(o1.getConstraintCatalog(), "").compareTo(StringUtils.defaultIfNull(o2.getConstraintCatalog(), ""));
            if (r2 != 0) {
                return r2;
            }
            r2 = StringUtils.defaultIfNull(o1.getConstraintSchema(), "").compareTo(StringUtils.defaultIfNull(o2.getConstraintSchema(), ""));
            if (r2 != 0) {
                return r2;
            }
            r2 = StringUtils.defaultIfNull(o1.getConstraintName(), "").compareTo(StringUtils.defaultIfNull(o2.getConstraintName(), ""));
            if (r2 != 0) {
                return r2;
            }
            return Integer.compare(o1.getOrdinalPosition(), o2.getOrdinalPosition());
        });
        return result;
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) {
        for (ReferentialConstraint fk2 : this.info().getReferentialConstraints()) {
            if (!this.getInputSchemata().contains(fk2.getConstraintSchema())) continue;
            for (KeyColumnUsage usage : this.info().getKeyColumnUsages()) {
                if (!StringUtils.equals(StringUtils.defaultIfNull(fk2.getConstraintCatalog(), ""), StringUtils.defaultIfNull(usage.getConstraintCatalog(), "")) || !StringUtils.equals(StringUtils.defaultIfNull(fk2.getConstraintSchema(), ""), StringUtils.defaultIfNull(usage.getConstraintSchema(), "")) || !StringUtils.equals(StringUtils.defaultIfNull(fk2.getConstraintName(), ""), StringUtils.defaultIfNull(usage.getConstraintName(), ""))) continue;
                SchemaDefinition foreignKeySchema = this.getSchema(fk2.getConstraintSchema());
                SchemaDefinition uniqueKeySchema = this.getSchema(fk2.getUniqueConstraintSchema());
                String foreignKey = usage.getConstraintName();
                String foreignKeyTableName = usage.getTableName();
                String foreignKeyColumn = usage.getColumnName();
                String uniqueKey = fk2.getUniqueConstraintName();
                TableConstraint fktc = this.tableConstraint(fk2.getConstraintCatalog(), fk2.getConstraintSchema(), fk2.getConstraintName());
                TableConstraint uktc = this.tableConstraint(fk2.getUniqueConstraintCatalog(), fk2.getUniqueConstraintSchema(), fk2.getUniqueConstraintName());
                if (fktc == null || uktc == null) continue;
                TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
                TableDefinition uniqueKeyTable = this.getTable(uniqueKeySchema, uktc.getTableName());
                if (foreignKeyTable == null || uniqueKeyTable == null) continue;
                relations2.addForeignKey(foreignKey, foreignKeyTable, foreignKeyTable.getColumn(foreignKeyColumn), uniqueKey, uniqueKeyTable, !Boolean.FALSE.equals(fktc.isEnforced()));
            }
        }
    }

    private TableConstraint tableConstraint(String constraintCatalog, String constraintSchema, String constraintName) {
        for (TableConstraint uk : this.info().getTableConstraints()) {
            if (!StringUtils.equals(StringUtils.defaultIfNull(constraintCatalog, ""), StringUtils.defaultIfNull(uk.getConstraintCatalog(), "")) || !StringUtils.equals(StringUtils.defaultIfNull(constraintSchema, ""), StringUtils.defaultIfNull(uk.getConstraintSchema(), "")) || !StringUtils.equals(StringUtils.defaultIfNull(constraintName, ""), StringUtils.defaultIfNull(uk.getConstraintName(), ""))) continue;
            return uk;
        }
        return null;
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r2) {
        for (CheckConstraint check : this.info().getCheckConstraints()) {
            TableDefinition table;
            TableConstraint tc;
            SchemaDefinition schema;
            if (!this.getInputSchemata().contains(check.getConstraintSchema()) || (schema = this.getSchema(check.getConstraintSchema())) == null || (tc = this.tableConstraint(check.getConstraintCatalog(), check.getConstraintSchema(), check.getConstraintName())) == null || (table = this.getTable(schema, tc.getTableName())) == null) continue;
            r2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, check.getConstraintName(), check.getCheckClause(), !Boolean.FALSE.equals(tc.isEnforced())));
        }
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (Schema schema : this.info().getSchemata()) {
            String schemaName = schema.getSchemaName();
            result.add(new SchemaDefinition((Database)this, StringUtils.defaultIfNull(schemaName, ""), schema.getComment()));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Sequence sequence : this.info().getSequences()) {
            if (!this.getInputSchemata().contains(sequence.getSequenceSchema())) continue;
            SchemaDefinition schema = this.getSchema(sequence.getSequenceSchema());
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition((Database)this, schema, sequence.getDataType(), (Number)sequence.getCharacterMaximumLength(), (Number)sequence.getNumericPrecision(), (Number)sequence.getNumericScale(), (Boolean)false, (String)null);
            result.add(new DefaultSequenceDefinition(schema, sequence.getSequenceName(), type, sequence.getComment(), sequence.getStartValue(), sequence.getIncrement(), sequence.getMinimumValue(), sequence.getMaximumValue(), Boolean.TRUE.equals(sequence.isCycleOption()), sequence.getCache()));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Table table : this.info().getTables()) {
            TableOptions.TableType tableType;
            if (!this.getInputSchemata().contains(table.getTableSchema())) continue;
            SchemaDefinition schema = this.getSchema(table.getTableSchema());
            switch (table.getTableType()) {
                case GLOBAL_TEMPORARY: {
                    tableType = TableOptions.TableType.TEMPORARY;
                    break;
                }
                case VIEW: {
                    tableType = TableOptions.TableType.VIEW;
                    break;
                }
                default: {
                    tableType = TableOptions.TableType.TABLE;
                }
            }
            String source = null;
            if (tableType == TableOptions.TableType.VIEW) {
                for (View view : this.info().getViews()) {
                    if (!StringUtils.equals(StringUtils.defaultIfNull(table.getTableCatalog(), ""), StringUtils.defaultIfNull(view.getTableCatalog(), "")) || !StringUtils.equals(StringUtils.defaultIfNull(table.getTableSchema(), ""), StringUtils.defaultIfNull(view.getTableSchema(), "")) || !StringUtils.equals(StringUtils.defaultIfNull(table.getTableName(), ""), StringUtils.defaultIfNull(view.getTableName(), ""))) continue;
                    source = view.getViewDefinition();
                    break;
                }
            }
            result.add(new XMLTableDefinition(schema, this.info(), table, table.getComment(), tableType, source));
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        for (Routine routine : this.info().getRoutines()) {
            if (!StringUtils.isBlank(routine.getSpecificPackage()) || !StringUtils.isBlank(routine.getRoutinePackage())) continue;
            String schemaName = StringUtils.defaultIfBlank(routine.getSpecificSchema(), routine.getRoutineSchema());
            if (!this.getInputSchemata().contains(schemaName)) continue;
            SchemaDefinition schema = this.getSchema(schemaName);
            result.add(new XMLRoutineDefinition(schema, null, this.info(), routine, routine.getComment()));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        HashSet<String> packages = new HashSet<String>();
        for (Routine routine : this.info().getRoutines()) {
            String schemaName = StringUtils.defaultIfBlank(routine.getSpecificSchema(), routine.getRoutineSchema());
            if (!this.getInputSchemata().contains(schemaName)) continue;
            SchemaDefinition schema = this.getSchema(schemaName);
            String packageName = StringUtils.defaultIfBlank(routine.getSpecificPackage(), routine.getRoutinePackage());
            if (StringUtils.isBlank(packageName) || !packages.add(packageName)) continue;
            result.add(new XMLPackageDefinition(schema, this.info(), packageName));
        }
        return result;
    }

    static int unbox(Integer i2) {
        return i2 == null ? 0 : i2;
    }

    static long unbox(Long l2) {
        return l2 == null ? 0L : l2;
    }
}

