/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.postgres;

import java.sql.SQLException;
import java.util.Arrays;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.TableLike;
import org.jooq.WindowFinalStep;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractRoutineDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultParameterDefinition;
import org.jooq.meta.InOutDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.postgres.PostgresDatabase;
import org.jooq.meta.postgres.information_schema.Tables;
import org.jooq.meta.postgres.information_schema.tables.Parameters;
import org.jooq.tools.StringUtils;

public class PostgresRoutineDefinition
extends AbstractRoutineDefinition {
    private final String specificName;
    private final boolean isProcedure;

    public PostgresRoutineDefinition(Database database, Record record) {
        super(database.getSchema((String)record.get(Tables.ROUTINES.ROUTINE_SCHEMA)), null, (String)record.get(Tables.ROUTINES.ROUTINE_NAME), null, record.get("overload", String.class), record.get("is_agg", Boolean.TYPE));
        String dataType = record.get("data_type", String.class);
        if (dataType != null && !Arrays.asList("void", "record").contains(dataType)) {
            SchemaDefinition typeSchema = null;
            String schemaName = (String)record.get(Tables.ROUTINES.TYPE_UDT_SCHEMA);
            if (schemaName != null) {
                typeSchema = this.getDatabase().getSchema(schemaName);
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), typeSchema == null ? database.getSchema((String)record.get(Tables.ROUTINES.ROUTINE_SCHEMA)) : typeSchema, dataType, (Number)record.get(Tables.ROUTINES.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(Tables.ROUTINES.NUMERIC_PRECISION), (Number)record.get(Tables.ROUTINES.NUMERIC_SCALE), null, (String)null, DSL.name((String)record.get(Tables.ROUTINES.TYPE_UDT_SCHEMA), (String)record.get(Tables.ROUTINES.TYPE_UDT_NAME)));
            this.returnValue = new DefaultParameterDefinition(this, "RETURN_VALUE", -1, type);
        }
        this.specificName = (String)record.get(Tables.ROUTINES.SPECIFIC_NAME);
        this.isProcedure = "PROCEDURE".equalsIgnoreCase((String)record.get(Tables.ROUTINES.ROUTINE_TYPE));
    }

    PostgresRoutineDefinition(Database database, String schema, String name, String specificName) {
        super(database.getSchema(schema), null, name, null, null);
        this.specificName = specificName;
        this.isProcedure = false;
    }

    @Override
    protected void init0() throws SQLException {
        Parameters p2 = Tables.PARAMETERS;
        WindowFinalStep count = DSL.count().filterWhere(p2.PARAMETER_NAME.ne(DSL.inline(""))).over(DSL.partitionBy(p2.SPECIFIC_NAME, p2.PARAMETER_NAME));
        Field c2 = count.as("c");
        for (Record record : this.create().select(p2.PARAMETER_NAME, DSL.when(p2.DATA_TYPE.eq(DSL.inline("USER-DEFINED")).and(p2.UDT_NAME.eq(DSL.inline("geometry"))), DSL.inline("geometry")).else_(p2.DATA_TYPE).as(p2.DATA_TYPE), p2.CHARACTER_MAXIMUM_LENGTH, PostgresRoutineDefinition.pNumericPrecision(p2).as(p2.NUMERIC_PRECISION), p2.NUMERIC_SCALE, p2.UDT_SCHEMA, p2.UDT_NAME, p2.ORDINAL_POSITION, p2.PARAMETER_MODE, ((PostgresDatabase)this.getDatabase()).is94() ? p2.PARAMETER_DEFAULT : DSL.inline((String)null).as(p2.PARAMETER_DEFAULT), c2).from((TableLike<?>)p2).where(p2.SPECIFIC_SCHEMA.equal(this.getSchema().getName())).and(p2.SPECIFIC_NAME.equal(this.specificName)).orderBy(p2.ORDINAL_POSITION.asc())) {
            String parameterName = (String)record.get(p2.PARAMETER_NAME);
            String inOut = (String)record.get(p2.PARAMETER_MODE);
            SchemaDefinition typeSchema = null;
            String schemaName = (String)record.get(p2.UDT_SCHEMA);
            if (schemaName != null) {
                typeSchema = this.getDatabase().getSchema(schemaName);
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), typeSchema, (String)record.get(p2.DATA_TYPE), (Number)record.get(p2.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(p2.NUMERIC_PRECISION), (Number)record.get(p2.NUMERIC_SCALE), null, (String)record.get(p2.PARAMETER_DEFAULT), DSL.name((String)record.get(p2.UDT_SCHEMA), (String)record.get(p2.UDT_NAME)));
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, parameterName, (Integer)record.get(p2.ORDINAL_POSITION), type, record.get(p2.PARAMETER_DEFAULT) != null, StringUtils.isBlank(parameterName), "", (Integer)record.get(c2) > 1 ? record.get(p2.ORDINAL_POSITION, String.class) : null);
            this.addParameter(InOutDefinition.getFromString(inOut), parameter);
        }
    }

    static Field<Integer> pNumericPrecision(Parameters p2) {
        return DSL.when(p2.NUMERIC_PRECISION.isNull().and(p2.DATA_TYPE.in(new Field[]{DSL.inline("time"), DSL.inline("timetz"), DSL.inline("time without time zone"), DSL.inline("time with time zone"), DSL.inline("timestamp"), DSL.inline("timestamptz"), DSL.inline("timestamp without time zone"), DSL.inline("timestamp with time zone")})), DSL.inline(6)).else_(p2.NUMERIC_PRECISION);
    }

    public boolean isProcedure() {
        return this.isProcedure;
    }
}

