/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.firebird;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jooq.Record;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.firebird.FirebirdDatabase;
import org.jooq.meta.firebird.rdb.Tables;
import org.jooq.meta.firebird.rdb.tables.Rdb$fields;
import org.jooq.meta.firebird.rdb.tables.Rdb$relationFields;

public class FirebirdTableDefinition
extends AbstractTableDefinition {
    private static final Pattern P_DEFAULT = Pattern.compile("DEFAULT\\s+");

    public FirebirdTableDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema, name, comment);
    }

    public FirebirdTableDefinition(SchemaDefinition schema, String name, String comment, TableOptions.TableType tableType, String source) {
        super(schema, name, comment, tableType, source);
    }

    @Override
    protected List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        Rdb$relationFields r2 = Tables.RDB$RELATION_FIELDS.as("r");
        Rdb$fields f2 = Tables.RDB$FIELDS.as("f");
        for (Record record : this.create().select(DSL.trim(r2.RDB$FIELD_NAME).as(r2.RDB$FIELD_NAME), r2.RDB$DESCRIPTION, r2.RDB$DEFAULT_VALUE, DSL.bitOr(r2.RDB$NULL_FLAG.nvl(DSL.inline((short)0)), f2.RDB$NULL_FLAG.nvl(DSL.inline((short)0))).as(r2.RDB$NULL_FLAG), r2.RDB$DEFAULT_SOURCE, f2.RDB$COMPUTED_SOURCE, r2.RDB$FIELD_POSITION, FirebirdDatabase.CHARACTER_LENGTH(f2).as("CHAR_LEN"), f2.RDB$FIELD_PRECISION, FirebirdDatabase.FIELD_SCALE(f2).as("FIELD_SCALE"), FirebirdDatabase.FIELD_TYPE(f2).as("FIELD_TYPE"), DSL.trim(f2.RDB$FIELD_NAME).as("DOMAIN_NAME"), r2.RDB$DESCRIPTION, (((FirebirdDatabase)this.getDatabase()).is30() ? r2.RDB$IDENTITY_TYPE : DSL.inline((short)0)).as(r2.RDB$IDENTITY_TYPE)).from((TableLike<?>)r2).leftOuterJoin(f2).on(r2.RDB$FIELD_SOURCE.eq(f2.RDB$FIELD_NAME)).where(r2.RDB$RELATION_NAME.eq(this.getName())).orderBy(r2.RDB$FIELD_POSITION)) {
            boolean computed;
            String defaultValue = (String)record.get(r2.RDB$DEFAULT_SOURCE);
            boolean bl2 = computed = record.get(f2.RDB$COMPUTED_SOURCE) != null;
            if (defaultValue != null) {
                defaultValue = P_DEFAULT.matcher(defaultValue).replaceFirst("");
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), record.get("FIELD_TYPE", String.class), (Number)record.get("CHAR_LEN", Short.TYPE), (Number)record.get(f2.RDB$FIELD_PRECISION), (Number)record.get("FIELD_SCALE", Integer.class), (Boolean)((Short)record.get(r2.RDB$NULL_FLAG) == 0 ? 1 : 0), computed ? null : defaultValue, record.get("DOMAIN_NAME") == null ? null : DSL.name(record.get("DOMAIN_NAME", String.class))).generatedAlwaysAs(computed ? (String)record.get(f2.RDB$COMPUTED_SOURCE) : null);
            result.add(new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), (String)record.get(r2.RDB$FIELD_NAME), result.size() + 1, (DataTypeDefinition)type, record.get(r2.RDB$IDENTITY_TYPE, Boolean.TYPE), (String)record.get(r2.RDB$DESCRIPTION)));
        }
        return result;
    }
}

