/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.derby;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record12;
import org.jooq.Record5;
import org.jooq.Record6;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.SQLDialect;
import org.jooq.SortOrder;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.ResultQueryDatabase;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.derby.DerbyTableDefinition;
import org.jooq.meta.derby.sys.Tables;

public class DerbyDatabase
extends AbstractDatabase
implements ResultQueryDatabase {
    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("P")) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SYSSCHEMAS.SCHEMANAME));
            String key = (String)record.get(Tables.SYSCONSTRAINTS.CONSTRAINTNAME);
            String tableName = (String)record.get(Tables.SYSTABLES.TABLENAME);
            String descriptor = record.get(Tables.SYSCONGLOMERATES.DESCRIPTOR, String.class);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            for (int index : this.decode(descriptor)) {
                relations2.addPrimaryKey(key, table, table.getColumn(index));
            }
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("U")) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SYSSCHEMAS.SCHEMANAME));
            String key = (String)record.get(Tables.SYSCONSTRAINTS.CONSTRAINTNAME);
            String tableName = (String)record.get(Tables.SYSTABLES.TABLENAME);
            String descriptor = record.get(Tables.SYSCONGLOMERATES.DESCRIPTOR, String.class);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            for (int index : this.decode(descriptor)) {
                relations2.addUniqueKey(key, table, table.getColumn(index));
            }
        }
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> primaryKeys(List<String> schemas) {
        return null;
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> uniqueKeys(List<String> schemas) {
        return null;
    }

    private Result<Record5<String, String, String, String, String>> fetchKeys(String constraintType) {
        return this.create().select(Tables.SYSKEYS.sysconglomerates().systables().sysschemas().SCHEMANAME, Tables.SYSKEYS.sysconglomerates().systables().TABLENAME, Tables.SYSKEYS.sysconglomerates().systables().TABLEID, Tables.SYSKEYS.sysconstraints().CONSTRAINTNAME, Tables.SYSKEYS.sysconglomerates().DESCRIPTOR).from((TableLike<?>)Tables.SYSKEYS).where(Tables.SYSKEYS.sysconglomerates().systables().sysschemas().SCHEMANAME.cast(SQLDataType.VARCHAR(32672)).in((Collection<?>)this.getInputSchemata())).and(Tables.SYSKEYS.sysconstraints().TYPE.cast(SQLDataType.VARCHAR(32672)).equal(constraintType)).orderBy(Tables.SYSKEYS.sysconglomerates().systables().sysschemas().SCHEMANAME, Tables.SYSKEYS.sysconglomerates().systables().TABLENAME, Tables.SYSKEYS.sysconstraints().CONSTRAINTNAME).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        Field<String> fkName = DSL.field("fc.constraintname", String.class);
        Field<String> fkTable = DSL.field("ft.tablename", String.class);
        Field<String> fkSchema = DSL.field("fs.schemaname", String.class);
        Field<Object> fkDescriptor = DSL.field("fg.descriptor");
        Field<String> ukName = DSL.field("pc.constraintname", String.class);
        Field<String> ukTable = DSL.field("pt.tablename", String.class);
        Field<String> ukSchema = DSL.field("ps.schemaname", String.class);
        for (Record record : this.create().select(fkName, fkTable, fkSchema, fkDescriptor, ukName, ukTable, ukSchema).from("sys.sysconstraints   fc").join("sys.sysforeignkeys   f ").on("f.constraintid = fc.constraintid").join("sys.sysconglomerates fg").on("fg.conglomerateid = f.conglomerateid").join("sys.systables        ft").on("ft.tableid = fg.tableid").join("sys.sysschemas       fs").on("ft.schemaid = fs.schemaid").join("sys.sysconstraints   pc").on("pc.constraintid = f.keyconstraintid").join("sys.systables        pt").on("pt.tableid = pc.tableid").join("sys.sysschemas       ps").on("ps.schemaid = pt.schemaid").where("cast(fc.type as varchar(32672)) = 'F'").fetch()) {
            SchemaDefinition foreignKeySchema = this.getSchema(record.get(fkSchema));
            SchemaDefinition uniqueKeySchema = this.getSchema(record.get(ukSchema));
            String foreignKeyName = record.get(fkName);
            String foreignKeyTableName = record.get(fkTable);
            List<Integer> foreignKeyIndexes = this.decode(record.get(fkDescriptor, String.class));
            String uniqueKeyName = record.get(ukName);
            String uniqueKeyTableName = record.get(ukTable);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            TableDefinition uniqueKeyTable = this.getTable(uniqueKeySchema, uniqueKeyTableName);
            if (foreignKeyTable == null || uniqueKeyTable == null) continue;
            for (int i2 = 0; i2 < foreignKeyIndexes.size(); ++i2) {
                relations2.addForeignKey(foreignKeyName, foreignKeyTable, foreignKeyTable.getColumn(foreignKeyIndexes.get(i2)), uniqueKeyName, uniqueKeyTable);
            }
        }
    }

    private List<Integer> decode(String descriptor) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Pattern p2 = Pattern.compile(".*?\\((.*?)\\)");
        Matcher m3 = p2.matcher(descriptor);
        while (m3.find()) {
            String[] split = m3.group(1).split(",");
            if (split == null) continue;
            for (String index : split) {
                result.add(Integer.parseInt(index.trim()) - 1);
            }
        }
        return result;
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        for (Record record : this.create().select(Tables.SYSCHECKS.sysconstraints().systables().sysschemas().SCHEMANAME, Tables.SYSCHECKS.sysconstraints().systables().TABLENAME, Tables.SYSCHECKS.sysconstraints().CONSTRAINTNAME, Tables.SYSCHECKS.CHECKDEFINITION).from((TableLike<?>)Tables.SYSCHECKS).where(Tables.SYSCHECKS.sysconstraints().systables().sysschemas().SCHEMANAME.in((Collection<?>)this.getInputSchemata()))) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SYSCHECKS.sysconstraints().systables().sysschemas().SCHEMANAME));
            TableDefinition table = this.getTable(schema, (String)record.get(Tables.SYSCHECKS.sysconstraints().systables().TABLENAME));
            if (table == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.get(Tables.SYSCHECKS.sysconstraints().CONSTRAINTNAME), (String)record.get(Tables.SYSCHECKS.CHECKDEFINITION)));
        }
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        for (Record record : this.create().select(Tables.SYSCONGLOMERATES.systables().sysschemas().SCHEMANAME, Tables.SYSCONGLOMERATES.systables().TABLENAME, Tables.SYSCONGLOMERATES.CONGLOMERATENAME, Tables.SYSCONGLOMERATES.DESCRIPTOR).from((TableLike<?>)Tables.SYSCONGLOMERATES).where(Tables.SYSCONGLOMERATES.systables().sysschemas().SCHEMANAME.cast(SQLDataType.VARCHAR(32672)).in((Collection<?>)this.getInputSchemata())).and(Tables.SYSCONGLOMERATES.ISINDEX).and(this.getIncludeSystemIndexes() ? DSL.noCondition() : DSL.not(DSL.condition(Tables.SYSCONGLOMERATES.ISCONSTRAINT))).orderBy(Tables.SYSCONGLOMERATES.systables().sysschemas().SCHEMANAME, Tables.SYSCONGLOMERATES.systables().TABLENAME, Tables.SYSCONGLOMERATES.CONGLOMERATENAME)) {
            String descriptor;
            SchemaDefinition tableSchema = this.getSchema((String)record.get(Tables.SYSCONGLOMERATES.systables().sysschemas().SCHEMANAME));
            if (tableSchema == null) continue;
            String indexName = (String)record.get(Tables.SYSCONGLOMERATES.CONGLOMERATENAME);
            String tableName = (String)record.get(Tables.SYSCONGLOMERATES.systables().TABLENAME);
            final TableDefinition table = this.getTable(tableSchema, tableName);
            if (table == null || (descriptor = (String)record.get(Tables.SYSCONGLOMERATES.DESCRIPTOR)) == null) continue;
            result.add(new AbstractIndexDefinition(tableSchema, indexName, table, descriptor.toUpperCase().contains("UNIQUE")){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    List<Integer> columnIndexes = DerbyDatabase.this.decode(descriptor);
                    for (int i2 = 0; i2 < columnIndexes.size(); ++i2) {
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, table.getColumn(columnIndexes.get(i2)), SortOrder.ASC, i2 + 1));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        return this.create().select(Tables.SYSSCHEMAS.SCHEMANAME).from((TableLike<?>)Tables.SYSSCHEMAS).collect(Collectors.mapping(r2 -> new SchemaDefinition((Database)this, (String)r2.value1(), ""), Collectors.toList()));
    }

    @Override
    public ResultQuery<Record12<String, String, String, String, Integer, Integer, Long, Long, BigDecimal, BigDecimal, Boolean, Long>> sequences(List<String> schemas) {
        return this.create().select(DSL.inline(null, SQLDataType.VARCHAR).cast(SQLDataType.VARCHAR).as("catalog"), Tables.SYSSEQUENCES.sysschemas().SCHEMANAME, Tables.SYSSEQUENCES.SEQUENCENAME, Tables.SYSSEQUENCES.SEQUENCEDATATYPE, DSL.inline(null, SQLDataType.INTEGER).cast(SQLDataType.INTEGER).as("numeric_precision"), DSL.inline(null, SQLDataType.INTEGER).cast(SQLDataType.INTEGER).as("numeric_scale"), DSL.nullif(Tables.SYSSEQUENCES.STARTVALUE, DSL.inline(1L)).as(Tables.SYSSEQUENCES.STARTVALUE), DSL.nullif(Tables.SYSSEQUENCES.INCREMENT, DSL.inline(1L)).as(Tables.SYSSEQUENCES.INCREMENT), DSL.nullif(Tables.SYSSEQUENCES.MINIMUMVALUE, DSL.case_(DSL.cast(Tables.SYSSEQUENCES.SEQUENCEDATATYPE, SQLDataType.VARCHAR)).when((Field<String>)DSL.inline("SMALLINT"), DSL.inline(-32768L)).when(DSL.inline("INTEGER"), DSL.inline(Integer.MIN_VALUE)).when(DSL.inline("BIGINT"), DSL.inline(Long.MIN_VALUE))).coerce(SQLDataType.NUMERIC).as(Tables.SYSSEQUENCES.MINIMUMVALUE), DSL.nullif(Tables.SYSSEQUENCES.MAXIMUMVALUE, DSL.case_(DSL.cast(Tables.SYSSEQUENCES.SEQUENCEDATATYPE, SQLDataType.VARCHAR)).when((Field<String>)DSL.inline("SMALLINT"), DSL.inline(32767L)).when(DSL.inline("INTEGER"), DSL.inline(Integer.MAX_VALUE)).when(DSL.inline("BIGINT"), DSL.inline(Long.MAX_VALUE))).coerce(SQLDataType.NUMERIC).as(Tables.SYSSEQUENCES.MAXIMUMVALUE), DSL.field(Tables.SYSSEQUENCES.CYCLEOPTION.eq(DSL.inline("Y"))).as(Tables.SYSSEQUENCES.CYCLEOPTION), DSL.inline(null, SQLDataType.BIGINT).cast(SQLDataType.BIGINT).as("cache")).from((TableLike<?>)Tables.SYSSEQUENCES).where(Tables.SYSSEQUENCES.sysschemas().SCHEMANAME.cast(SQLDataType.VARCHAR(32672)).in((Collection<?>)schemas)).orderBy(Tables.SYSSEQUENCES.sysschemas().SCHEMANAME, Tables.SYSSEQUENCES.SEQUENCENAME);
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.sequences(this.getInputSchemata())) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SYSSEQUENCES.sysschemas().SCHEMANAME));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, (String)record.get(Tables.SYSSEQUENCES.SEQUENCEDATATYPE));
            result.add(new DefaultSequenceDefinition(schema, (String)record.get(Tables.SYSSEQUENCES.SEQUENCENAME), type, null, (Number)record.get(Tables.SYSSEQUENCES.STARTVALUE), (Number)record.get(Tables.SYSSEQUENCES.INCREMENT), (Number)record.get(Tables.SYSSEQUENCES.MINIMUMVALUE), (Number)record.get(Tables.SYSSEQUENCES.MAXIMUMVALUE), record.get(Tables.SYSSEQUENCES.CYCLEOPTION, Boolean.class), null));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(Tables.SYSTABLES.sysschemas().SCHEMANAME, Tables.SYSTABLES.TABLENAME, Tables.SYSTABLES.TABLEID, DSL.when(Tables.SYSTABLES.TABLETYPE.eq(DSL.inline("V")), DSL.inline(TableOptions.TableType.VIEW.name())).else_(DSL.inline(TableOptions.TableType.TABLE.name())).as("table_type"), Tables.SYSVIEWS.VIEWDEFINITION).from((TableLike<?>)Tables.SYSTABLES).leftJoin(Tables.SYSVIEWS).on(Tables.SYSTABLES.TABLEID.eq(Tables.SYSVIEWS.TABLEID)).where(Tables.SYSTABLES.sysschemas().SCHEMANAME.cast(SQLDataType.VARCHAR(32672)).in((Collection<?>)this.getInputSchemata())).orderBy(Tables.SYSTABLES.sysschemas().SCHEMANAME, Tables.SYSTABLES.TABLENAME)) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SYSTABLES.sysschemas().SCHEMANAME));
            String name = (String)record.get(Tables.SYSTABLES.TABLENAME);
            String id2 = (String)record.get(Tables.SYSTABLES.TABLEID);
            TableOptions.TableType tableType = record.get("table_type", TableOptions.TableType.class);
            String source = (String)record.get(Tables.SYSVIEWS.VIEWDEFINITION);
            DerbyTableDefinition table = new DerbyTableDefinition(schema, name, id2, tableType, source);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using(this.getConnection(), SQLDialect.DERBY);
    }
}

