/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jooq.DSLContext;
import org.jooq.Meta;
import org.jooq.Queries;
import org.jooq.Query;
import org.jooq.Source;
import org.jooq.Version;
import org.jooq.conf.InterpreterSearchSchema;
import org.jooq.exception.DataDefinitionException;
import org.jooq.impl.AbstractNode;
import org.jooq.impl.DSL;
import org.jooq.impl.Tools;

final class VersionImpl
extends AbstractNode<Version>
implements Version {
    private final DSLContext ctx;
    private final Meta meta;
    private final List<Parent> parents;

    private VersionImpl(DSLContext ctx, String id2, Meta meta, List<Parent> parents) {
        super(id2, null);
        this.ctx = ctx;
        this.meta = meta != null ? meta : VersionImpl.init(ctx);
        this.parents = parents;
    }

    private static final Meta init(DSLContext ctx) {
        Meta result = ctx.meta("");
        List<InterpreterSearchSchema> searchPath = ctx.settings().getInterpreterSearchPath();
        for (InterpreterSearchSchema schema : searchPath) {
            result = result.apply(DSL.createSchema(DSL.schema(DSL.name(schema.getCatalog(), schema.getSchema()))));
        }
        return result;
    }

    VersionImpl(DSLContext ctx, String id2, Meta meta, Version parent, Queries queries) {
        this(ctx, id2, meta, Arrays.asList(new Parent((VersionImpl)parent, queries)));
    }

    VersionImpl(DSLContext ctx, String id2, Meta meta, Version[] parents) {
        this(ctx, id2, meta, VersionImpl.wrap(parents));
    }

    private static List<Parent> wrap(Version[] parents) {
        return Tools.map(parents, p2 -> new Parent((VersionImpl)p2, null));
    }

    @Override
    public final Meta meta() {
        return this.meta;
    }

    @Override
    public final List<Version> parents() {
        return new AbstractList<Version>(){

            @Override
            public Version get(int index) {
                return VersionImpl.this.parents.get((int)index).version;
            }

            @Override
            public int size() {
                return VersionImpl.this.parents.size();
            }
        };
    }

    @Override
    public final Version apply(String newId, Query ... migration) {
        return this.apply(newId, this.ctx.queries(migration));
    }

    @Override
    public final Version apply(String newId, Collection<? extends Query> migration) {
        return this.apply(newId, this.ctx.queries(migration));
    }

    @Override
    public final Version apply(String newId, String migration) {
        return this.apply(newId, this.ctx.parser().parse(migration));
    }

    @Override
    public final Version apply(String newId, Queries migration) {
        return new VersionImpl(this.ctx, newId, this.meta().apply(migration), this, migration);
    }

    @Override
    public final Queries migrateTo(Version version) {
        if (this.equals(version)) {
            return this.ctx.queries(new Query[0]);
        }
        VersionImpl subgraph = ((VersionImpl)version).subgraphTo(this);
        if (subgraph == null) {
            throw new DataDefinitionException("No forward path available between versions " + this.id() + " and " + version.id() + ". Use Settings.migrationAllowsUndo to enable this feature.");
        }
        return this.migrateTo(subgraph, this.ctx.queries(new Query[0]));
    }

    private final VersionImpl subgraphTo(VersionImpl ancestor) {
        ArrayList<Parent> list = null;
        for (Parent parent : this.parents) {
            if (parent.version.equals(ancestor)) {
                if (list == null) {
                    list = new ArrayList<Parent>();
                }
                list.add(new Parent(new VersionImpl(this.ctx, parent.version.id(), parent.version.meta, Collections.emptyList()), parent.queries));
                continue;
            }
            VersionImpl p2 = parent.version.subgraphTo(ancestor);
            if (p2 == null) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(new Parent(p2, parent.queries));
        }
        return list == null ? null : new VersionImpl(this.ctx, this.id(), this.meta, list);
    }

    private final Queries migrateTo(VersionImpl target, Queries result) {
        if (!target.forceApply()) {
            return this.meta().migrateTo(target.meta());
        }
        for (Parent parent : target.parents) {
            result = this.migrateTo(parent.version, result);
            if (parent.queries != null) {
                result = result.concat(parent.queries);
                continue;
            }
            result = result.concat(parent.version.meta().migrateTo(target.meta()));
        }
        return result;
    }

    private final boolean forceApply() {
        return Tools.anyMatch(this.parents, p2 -> p2.queries != null || p2.version.forceApply());
    }

    @Override
    public final Version commit(String newId, String ... newMeta) {
        return this.commit(newId, this.ctx.meta(newMeta));
    }

    @Override
    public final Version commit(String newId, Source ... newMeta) {
        return this.commit(newId, this.ctx.meta(newMeta));
    }

    @Override
    public final Version commit(String newId, Meta newMeta) {
        return new VersionImpl(this.ctx, newId, newMeta, new Version[]{this});
    }

    @Override
    public final Version merge(String newId, Version with) {
        Meta m3 = this.commonAncestor(with).meta();
        return new VersionImpl(this.ctx, newId, m3.apply(m3.migrateTo(this.meta()).concat(m3.migrateTo(with.meta()))), new Version[]{this, with});
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id() == null ? 0 : this.id().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionImpl other = (VersionImpl)obj;
        return !(this.id() == null ? other.id() != null : !this.id().equals(other.id()));
    }

    public String toString() {
        return "-- Version: " + this.id() + "\n" + this.meta();
    }

    private static final class Parent {
        private final VersionImpl version;
        private final Queries queries;

        public Parent(VersionImpl version, Queries queries) {
            this.version = version;
            this.queries = queries;
        }

        public VersionImpl version() {
            return this.version;
        }

        public Queries queries() {
            return this.queries;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof Parent)) {
                return false;
            }
            Parent other = (Parent)o2;
            if (!Objects.equals(this.version, other.version)) {
                return false;
            }
            return Objects.equals(this.queries, other.queries);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.queries);
        }

        public String toString() {
            return this.version.toString();
        }
    }
}

