/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.UUID;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.TableLike;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

final class Uuid
extends AbstractField<UUID>
implements QOM.Uuid {
    Uuid() {
        super(Names.N_UUID, Tools.allNotNull(SQLDataType.UUID));
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                ctx.visit(DSL.function(Names.N_GEN_RANDOM_UUID, this.getDataType(), new Field[0]));
                break;
            }
            case FIREBIRD: {
                ctx.visit(DSL.function(Names.N_UUID_TO_CHAR, this.getDataType(), DSL.function(Names.N_GEN_UUID, this.getDataType(), new Field[0])));
                break;
            }
            case H2: {
                ctx.visit(DSL.function(Names.N_RANDOM_UUID, this.getDataType(), new Field[0]));
                break;
            }
            case HSQLDB: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: {
                ctx.visit(DSL.function(Names.N_UUID, this.getDataType(), new Field[0]));
                break;
            }
            case SQLITE: {
                Field<String> u2 = DSL.field(DSL.name("u"), SQLDataType.VARCHAR);
                ctx.visit(DSL.field(DSL.select(DSL.substring(u2, DSL.inline(1), DSL.inline(8)).concat(DSL.inline('-')).concat(DSL.substring(u2, DSL.inline(9), DSL.inline(4)).concat(DSL.inline('-'))).concat(DSL.substring(u2, DSL.inline(13), DSL.inline(4)).concat(DSL.inline('-'))).concat(DSL.substring(u2, DSL.inline(17), DSL.inline(4)).concat(DSL.inline('-'))).concat(DSL.substring(u2, DSL.inline(21)))).from((TableLike<?>)DSL.select(DSL.lower(DSL.function(Names.N_HEX, SQLDataType.VARCHAR, DSL.function(Names.N_RANDOMBLOB, SQLDataType.BINARY, DSL.inline(16)))).as(u2)).asTable(DSL.unquotedName("t")))));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_UUID, this.getDataType(), new Field[0]));
            }
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Uuid) {
            QOM.Uuid o2 = (QOM.Uuid)that;
            return true;
        }
        return super.equals(that);
    }
}

